package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.ButtonDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.MenuDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.AppInstanceQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ButtonQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.MenuQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserAccessRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IApplicationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IResourceQueryApi;
import com.dtyunxi.yundt.module.customer.api.user.IAccessExtService;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 权限查询服务实现
 */
@Service
public class IAccessExtServiceImpl  implements IAccessExtService {
    private static final Logger logger = LoggerFactory.getLogger(IAccessExtServiceImpl.class);

    @Resource
    private IAccessExtQueryApi accessExtQueryApi;
    @Resource
    private HttpServletRequest request;
    @Resource
    private IDictQueryApi dictQueryApi;
    @Resource
    private IApplicationQueryApi applicationQueryApi;

    /**
     * 获取请求头的组织ID
     *
     * @return 组织ID
     */
    public String headerOrgId() {
        String organizationId = request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("获取请求头组织ID：{}", organizationId);
        return organizationId;
    }


    @Override
    public RestResponse<UserAccessRespDto> queryUserAccess(Long userId, Long instanceId) {
        UserAccessRespDto respDto = new UserAccessRespDto();
        respDto.setUserId(userId);
        respDto.setMenus(new ArrayList<>());
        /* 获取组织信息 */
        String organizationId = this.headerOrgId();
        logger.info("请求头组织ID：{}", organizationId);

//        if (StringUtils.isBlank(organizationId)){
//            organizationId = nacosPropertiesOrgEntity.orgId();
//            logger.info("nacos配置的组织ID：{}", organizationId);
//        }
        if(StringUtils.isBlank(organizationId)){
            logger.error("请求头缺失组织ID");
            return new RestResponse<>(respDto);
        }
        //配置了主数据组织信息
        RestResponse<DictDto> dictDtoRestResponse = dictQueryApi.queryByGroupCodeAndCode(1L, "master_data_org", organizationId);
        if(Objects.isNull(dictDtoRestResponse) || Objects.isNull(dictDtoRestResponse.getData()) || Objects.equals(dictDtoRestResponse.getData().getStatus(),2)){
            UserAccessRespDto userAccessRespDto = new UserAccessRespDto();
            AppInstanceQueryResDto appInstanceQueryResDto = RestResponseHelper.extractData(applicationQueryApi.queryInsByInstanceIdAndResources(instanceId, null, Lists.newArrayList("buttons", "menus"), "{}"));
            MenuQueryResDto menus = appInstanceQueryResDto.getMenus();
            List<MenuDto> menusNew = Lists.newArrayList();
            if(Objects.nonNull(menus) && CollectionUtils.isNotEmpty(menus.getChildren())){
                MenuQueryResDto menuQueryResDto = menus.getChildren().get(0);
                if(CollectionUtils.isNotEmpty(menuQueryResDto.getChildren())){
                    CubeBeanUtils.copyCollection(menusNew,menuQueryResDto.getChildren(),MenuDto.class);
                }
            }
            List<ButtonQueryResDto> buttons = appInstanceQueryResDto.getButtons();
            List<ButtonDto> buttonsNew = Lists.newArrayList();
            CubeBeanUtils.copyCollection(buttonsNew,buttons,MenuDto.class);
            userAccessRespDto.setMenus(menusNew);
            userAccessRespDto.setButtons(buttonsNew);
            return new RestResponse<>(userAccessRespDto);
        }
        ServiceContext.getContext().setAttachment("yes.req.cus.b2b.organizationId",organizationId);
        UserAccessRespDto userAccessRespDto = RestResponseHelper.extractData(accessExtQueryApi.queryUserAccess(userId,organizationId, instanceId));
        if (userAccessRespDto != null) {
            final List<MenuDto> newList = userAccessRespDto.getMenus().stream().filter(a -> instanceId.equals(a.getInstanceId())).collect(Collectors.toList());
            userAccessRespDto.setMenus(newList);
        }
        return new RestResponse<>(userAccessRespDto);
    }



}
