package com.dtyunxi.yundt.module.customer.biz.impl;

import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerAreaApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaReqDto;
import com.dtyunxi.yundt.module.customer.api.ICustomerAreaExtService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 客户区域服务
 *
 * @author moming
 */
@Slf4j
@Service("customerAreaExtServiceImpl")
public class ICustomerAreaExtServiceImpl implements ICustomerAreaExtService {

    @Resource
    private ICustomerAreaApi customerAreaApi;

    @Override
    public Long saveAreaGroup(CustomerAreaReqDto customerAreaReqDto) {
        return RestResponseHelper.extractData(customerAreaApi.saveCustomerArea(customerAreaReqDto));
    }

}
