package com.dtyunxi.yundt.module.customer.biz.impl.user;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerAreaListExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeRegionQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.entity.ImportBaseResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeImportReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleExpandRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserOrgizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.EmployeeOrgExcelRespDto;
import com.dtyunxi.yundt.module.customer.api.user.IEmployeeExpand2Service;
import com.dtyunxi.yundt.module.customer.api.user.IOrgEmployeeExpandService;
import com.dtyunxi.yundt.module.customer.biz.util.CommonUtil;
import com.dtyunxi.yundt.module.customer.biz.util.EasyPoiExportUtil;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;


/**
 * @author liangfa
 * @Description 人员管理接口实现
 * @date 2022-01-14 14:06
 * @since 1.0.0
 */
@Service
public class OrgEmployeeExpandServiceImpl  implements IOrgEmployeeExpandService {

    private static final Logger logger = LoggerFactory.getLogger(OrgEmployeeExpandServiceImpl.class);

    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;
    @Resource
    private IEmployeeRegionQueryApi employeeRegionQueryApi;
    @Resource
    private IEmployeeExpand2Service employeeExpand2Service;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private HttpServletRequest request;


    /**
     * 组织人员导入
     * @return
     */
    @Override
    //@Transactional(rollbackFor = Exception.class)
    public RestResponse<ImportBaseResponse> importOrgExcelEmployee(EmployeeImportReqDto importReqDto) {
        logger.info("importOrgExcelEmployee==>{}",JSON.toJSONString(importReqDto));
        String fileUrl = importReqDto.getFileUrl();
        AssertUtil.assertNotBlank(fileUrl, "导入的文件路径为空");
        Long instanceId = importReqDto.getInstanceId();
        /* 设置默认结果 */
        ImportBaseResponse response = new ImportBaseResponse();
        /* 处理文件，读取数据 */
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);// 表格标题行数,默认0
        importParams.setTitleRows(0);//表头行数,默认1
        List<EmployeeOrgExcelRespDto> importDataList = new ArrayList<>();
        try {
            ExcelImportResult<EmployeeOrgExcelRespDto> result = ExcelImportUtil.importExcelMore(EasyPoiExportUtil.getInputStream(fileUrl), EmployeeOrgExcelRespDto.class, importParams);
            if (ObjectUtils.isNotEmpty(result)) {
                importDataList = result.getList();
                //筛选对象属性全部为null数据
                importDataList = BeanPropertyNullUtil.getAllFieldNullList(importDataList);
            }
            if (CollectionUtils.isEmpty(importDataList)) {
                throw new BizException("无法读取 Excel 中的数据，请检查数据是否符合模板格式要求");
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new BizException("无法读取 Excel 文件，请检查文件类型");
        }
        response.setTotalNum(importDataList.size());
        /* 获取角色列表数据 */
        List<String> roleNameList = importDataList.stream().filter(data -> StringUtils.isNotEmpty(data.getRoleName())).map(EmployeeOrgExcelRespDto::getRoleName).distinct().collect(Collectors.toList());
        Map<String, List<RoleExpandRespDto>> roleMap =employeeExpand2Service.getRoleMap(roleNameList,null);
        /** 获取组织数据 */
        List<String> orgNameList = importDataList.stream().filter(data -> StringUtils.isNotEmpty(data.getOrganizationName())).map(EmployeeOrgExcelRespDto::getOrganizationName).distinct().collect(Collectors.toList());
        Map<String, OrganizationDto> orgInfoMap = employeeExpand2Service.getOrgByNameMap(orgNameList);

        //获取经销商数据
        List<String> dealerCodeList = importDataList.stream().filter(data -> StringUtils.isNotEmpty(data.getDealerCode())).map(EmployeeOrgExcelRespDto::getDealerCode).distinct().collect(Collectors.toList());
        Map<String, CustomerRespDto> orgCustomerMap = employeeExpand2Service.getOrgCustomerMap(dealerCodeList);
        //获取账户信息
        List<String> accountList = importDataList.stream().filter(data -> StringUtils.isNotEmpty(data.getAccount())).map(EmployeeOrgExcelRespDto::getAccount).distinct().collect(Collectors.toList());
        logger.info("获取账户信息获取账号信息：{}", JSON.toJSONString(accountList));
        Map<String, List<UserOrgizationRespDto>> userOrgMap = employeeExpand2Service.getAccoutMap(accountList);
        //获取客户区域
        Map<String, List<CustomerAreaRespDto>> customerAreasMap = new HashMap<>();
        List<String> governAreaList = importDataList.stream().filter(data -> StringUtils.isNotEmpty(data.getGovernArea())).map(EmployeeOrgExcelRespDto::getGovernArea).distinct().collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(governAreaList)){
            CustomerAreaListExtReqDto areaListReqDto = new CustomerAreaListExtReqDto();
            areaListReqDto.setNameList(governAreaList);
            RestResponse<List<CustomerAreaRespDto>> areaRest = employeeRegionQueryApi.queryCustomerAreaByNames(areaListReqDto);
            if (null != areaRest && CollectionUtils.isNotEmpty(areaRest.getData())) {
                List<CustomerAreaRespDto> customerAreaList = areaRest.getData();
                if(CollectionUtils.isNotEmpty(customerAreaList)){
                    customerAreasMap = customerAreaList.stream().collect(Collectors.groupingBy(CustomerAreaRespDto::getName));
                }
            }
        }

        /* 校验数据 */
        importDataList = this.verifyOrgData(importDataList,roleMap,customerAreasMap,orgInfoMap,orgCustomerMap,userOrgMap);
        List<EmployeeOrgExcelRespDto> successList = importDataList.stream().filter(dto -> StringUtils.isEmpty(dto.getErrorMsg())).collect(Collectors.toList());
        /* 合并数据 */
        List<EmployeeOrgExcelRespDto> orgExcelDtoList = this.mergeOrgData(successList);

        Map<String,Long> employeeInfoMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(orgExcelDtoList)){
            List<Long> userIdList = orgExcelDtoList.stream().map(EmployeeOrgExcelRespDto::getUserId).distinct().collect(Collectors.toList());
            List<Long> orgIdList = orgExcelDtoList.stream().map(EmployeeOrgExcelRespDto::getOrgId).distinct().collect(Collectors.toList());
            employeeInfoMap = employeeExpand2Service.getEmployeeMap(userIdList,orgIdList);
        }
        /* 处理数据 */
        for (EmployeeOrgExcelRespDto data : orgExcelDtoList){
            //构建人员对象
            EmployeeExpandReqDto employeeExtReqDto = new EmployeeExpandReqDto();
            employeeExtReqDto.setOrganizationId(data.getOrgId());
            employeeExtReqDto.setOrgId(data.getOrgId());
            employeeExtReqDto.setOrganizationCode(data.getOrgCode());
            employeeExtReqDto.setOrganizationStatus(YesOrNoEnum.YES.getStatus());
            employeeExtReqDto.setName(data.getUserName());//姓名
            employeeExtReqDto.setPosition(data.getPosition());//职位
            employeeExtReqDto.setSex(data.getSex());//性别
            employeeExtReqDto.setStation(data.getDepartment());//部门
            employeeExtReqDto.setEmployeeNo(data.getJobNumber());//工号
            employeeExtReqDto.setPhoneNum(data.getPhoneNumber());//手机号码
            employeeExtReqDto.setEmployeeRoleDtoList(data.getRoleList());//角色
            employeeExtReqDto.setUserId(data.getUserId());//账号
            employeeExtReqDto.setStartTime(new Date());
            employeeExtReqDto.setCustomerInfoList(data.getCustomerInfoList());
            employeeExtReqDto.setCustomerBlackList(data.getCustomerBlackList());
            employeeExtReqDto.setRegionInfoList(data.getAreaList());
            employeeExtReqDto.setStatus(1);
            employeeExtReqDto.setType(0);
            //查询该账号在组织下是否已被绑定，若已绑定，则修改，没有则新增
            String key = data.getOrgId() + "_" + data.getUserId();
            try {
                if(!employeeInfoMap.isEmpty() && employeeInfoMap.containsKey(key)){
                    Long id = employeeInfoMap.get(key);
                    //修改
                    employeeExtReqDto.setId(id);
                    logger.info("修改组织人员入参:{}",JSON.toJSONString(employeeExtReqDto));
                    employeeExpand2Service.modifyEmployee(instanceId,employeeExtReqDto);
                }else {
                    //新增
                    logger.info("新增组织人员入参:{}",JSON.toJSONString(employeeExtReqDto));
                    employeeExpand2Service.addEmployee(instanceId,employeeExtReqDto);
                }
            }catch (Exception e){
                logger.info("导入组织人员失败:{}",e);
                setErrorsOrgMsg(importDataList,data.getAccount(),data.getOrgId(),"执行失败！"+e.getMessage());
            }
        }

        //执行错误的数据形成文件导出
        List<EmployeeOrgExcelRespDto> errorList = importDataList.stream().filter(dto -> StringUtils.isNotEmpty(dto.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(errorList)){
            response.setErrorNum(errorList.size());
            String excelName ="组织人员导入失败信息-明细Excel-"+ com.dtyunxi.cube.utils.DateUtil.getDateFormat(new Date(), com.dtyunxi.cube.utils.DateUtil.YMDSTRING_DATA);
            String exportUrl;
            try {
                exportUrl = EasyPoiExportUtil.getExportUrl(errorList,EmployeeOrgExcelRespDto.class, null, excelName, "xls");
                response.setErrorFileUrl(exportUrl);
            } catch (Exception e) {
                logger.error("组织人员导入失败信息文件生成失败");
                logger.error(e.getMessage(),e);
            }
        }

        response.setSuccessNum(response.getTotalNum()-response.getErrorNum());
        return new RestResponse<>(response);
    }

    //获取请求头，判断是否为品牌方
    public Boolean headerBigB() {
        String bigB = request.getHeader("big-b-request-flag");
        logger.info("获取请求头，判断是否为品牌方：{}",bigB);
        if (ObjectUtils.isNotEmpty(bigB)){
            return Boolean.valueOf(bigB);
        }
        return false;
    }

    /**
     * 校验数据
     * @param list 原数据
     * @return
     */
    public List<EmployeeOrgExcelRespDto> verifyOrgData(List<EmployeeOrgExcelRespDto> list, Map<String,List<RoleExpandRespDto>>  roleMap,
                                                       Map<String, List<CustomerAreaRespDto>> areasMap,Map<String,OrganizationDto> orgInfoMap,
                                                       Map<String,CustomerRespDto> orgCustomerMap,
                                               Map<String, List<UserOrgizationRespDto>> userOrgMap ){
        List<String> codes = new ArrayList<>();
        //获取请求头，判断是否为品牌方
        Boolean ifPPF = this.headerBigB();

        for (EmployeeOrgExcelRespDto vo : list) {
            if (StringUtils.isBlank(vo.getOrganizationName()) && StringUtils.isBlank(vo.getDealerCode())){
                vo.setErrorMsg("组织名称或客户/经销商编号不能为空");
                continue;
            }
            //组织id
            Long orgId = 0L;
            String orgCode = "";
            //优先判断客户编码
            if(StringUtils.isNotEmpty(vo.getDealerCode())){
                if(orgCustomerMap.isEmpty()|| !orgCustomerMap.containsKey(vo.getDealerCode())){
                    vo.setErrorMsg("客户/经销商编号数据错误");
                    continue;
                }
                CustomerRespDto customerRespDto = orgCustomerMap.get(vo.getDealerCode());
                orgId = customerRespDto.getOrgInfoId();
                OrganizationDto organizationDto = RestResponseHelper.extractData(organizationQueryApi.queryById(orgId,""));
                if(Objects.isNull(organizationDto)){
                    vo.setErrorMsg("客户/经销商编号所属组织数据错误");
                    continue;
                }
                orgCode = organizationDto.getCode();
            }
            if(null == orgId && StringUtils.isNotEmpty(vo.getOrganizationName())){
                if(orgInfoMap.isEmpty()|| !orgInfoMap.containsKey(vo.getOrganizationName())){
                    vo.setErrorMsg("组织名称数据错误");
                    continue;
                }
                OrganizationDto organizationEo = orgInfoMap.get(vo.getOrganizationName());
                orgId = organizationEo.getId();
                orgCode = organizationEo.getCode();
            }
            vo.setOrgCode(orgCode);
            vo.setOrgId(orgId);
            if (StringUtils.isBlank(vo.getAccount())){
                vo.setErrorMsg("登录账号不能为空");
                continue;
            }
            if(userOrgMap.isEmpty() || !userOrgMap.containsKey(vo.getAccount())){
                vo.setErrorMsg("登录账号错误");
                continue;
            }
            List<UserOrgizationRespDto> userOrgizationVos = userOrgMap.get(vo.getAccount());
            List<UserOrgizationRespDto> userOrgList = userOrgizationVos.stream().filter(e -> vo.getOrgId().compareTo(e.getOrgId()) == 0).collect(Collectors.toList());
            if(CollectionUtils.isEmpty(userOrgList) && !ifPPF){ //品牌方不校验该信息
                vo.setErrorMsg("登录账号所属组织错误");
                continue;
            }
            if(CollectionUtils.isNotEmpty(userOrgList)){
                vo.setUserId(userOrgList.get(0).getUserId());
            }else {
                vo.setUserId(userOrgizationVos.get(0).getUserId());
            }

            if (StringUtils.isBlank(vo.getUserName())){
                vo.setErrorMsg("姓名不能为空");
                continue;
            }
            if (StringUtils.isBlank(vo.getPosition())){
                vo.setErrorMsg("职位不能为空");
                continue;
            }
            if (StringUtils.isNoneBlank(vo.getRoleName())){
                if(roleMap.isEmpty() || !roleMap.containsKey(vo.getRoleName())){
                    vo.setErrorMsg("角色错误");
                    continue;
                }
                List<RoleExpandRespDto> roleExpandEos = roleMap.get(vo.getRoleName());
                List<RoleExpandRespDto> orgRoleList = roleExpandEos.stream()
                        .filter(e -> (Objects.nonNull(e.getBelongOrgId()) && e.getBelongOrgId().compareTo(vo.getOrgId()) == 0)|| e.getRoleType() == 1)
                        .collect(Collectors.toList());
                if(CollectionUtils.isEmpty(orgRoleList)){
                    vo.setErrorMsg("角色所属组织错误");
                    continue;
                }
                EmployeeRoleReqDto employeeRoleReqDto = new EmployeeRoleReqDto();
                employeeRoleReqDto.setRoleId(orgRoleList.get(0).getId());
                employeeRoleReqDto.setRoleCode(orgRoleList.get(0).getCode());
                vo.setRole(employeeRoleReqDto);
            }
            if(StringUtils.isNotEmpty(vo.getPhoneNumber())){
                if(!CommonUtil.checkPhoneNum(vo.getPhoneNumber())){
                    vo.setErrorMsg("手机号格式不正确;");
                    continue;
                }
            }
            if (StringUtils.isNoneBlank(vo.getGovernArea())){
                List<CustomerAreaRespDto> customerAreaRespDtos = areasMap.get(vo.getGovernArea());
                if(areasMap.isEmpty() || !areasMap.containsKey(vo.getGovernArea())){
                    vo.setErrorMsg("管理区域错误");
                    continue;
                }
                List<CustomerAreaRespDto> orgAreaList = customerAreaRespDtos.stream().filter(e -> e.getOrgInfoId().compareTo(vo.getOrgId()) == 0).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(orgAreaList)){
                    vo.setErrorMsg("管理区域所属组织错误");
                    continue;
                }
                EmployeeRegionReqDto employeeRegionReqDto = new EmployeeRegionReqDto();
                employeeRegionReqDto.setRegionCode(orgAreaList.get(0).getCode());
                employeeRegionReqDto.setStartTime(new Date());
                vo.setArea(employeeRegionReqDto);
            }
            if(StringUtils.isNotEmpty(vo.getGovernCustomer())){
                codes.add(vo.getGovernCustomer());
            }
            if(StringUtils.isNotEmpty(vo.getBlacklist())){
                codes.add(vo.getBlacklist());
            }
        }
        //根据编号获取客户信息
        if (CollectionUtils.isNotEmpty(codes)){
            codes = codes.stream().distinct().collect(Collectors.toList());
            List<CustomerRespDto> customerRespDtos = RestResponseHelper.extractData(employeeCustomerQueryApi.queryCustomerListByCodes(codes));
            Map<String,CustomerRespDto> customersMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(customerRespDtos)){
                customersMap =customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(),(key1, key2)->key2));

            }
            for (EmployeeOrgExcelRespDto vo : list) {
                if (StringUtils.isNoneBlank(vo.getErrorMsg())){
                    continue;
                }
                //根据编号转换管理客户对象
                if(StringUtils.isNotEmpty(vo.getGovernCustomer())){
                    if(customersMap.isEmpty() || !customersMap.containsKey(vo.getGovernCustomer())){
                        vo.setErrorMsg("管理客户（客户编号）错误");
                        continue;
                    }
                    CustomerRespDto customerRespDto = customersMap.get(vo.getGovernCustomer());
                    if (null == customerRespDto.getOrgInfoId() || customerRespDto.getMerchantId().compareTo(vo.getOrgId()) !=0){
                        vo.setErrorMsg("管理客户（客户编号）所属组织错误");
                        continue;
                    }

                    EmployeeCustomerReqDto employeeCustomerReqDto = new EmployeeCustomerReqDto();
                    employeeCustomerReqDto.setCustomerId(customerRespDto.getId());
                    employeeCustomerReqDto.setStartTime(new Date());
                    vo.setCustomerDto(employeeCustomerReqDto);
                }
                if(StringUtils.isNotEmpty(vo.getBlacklist())){
                    //根据编号转换黑名单客户对象
                    if(customersMap.isEmpty() || !customersMap.containsKey(vo.getBlacklist())){
                        vo.setErrorMsg("管理黑名单（客户编号）错误");
                        continue;
                    }
                    CustomerRespDto customerBlacklistRespDto = customersMap.get(vo.getBlacklist());
                    if (null == customerBlacklistRespDto.getOrgInfoId() || customerBlacklistRespDto.getMerchantId().compareTo(vo.getOrgId()) !=0){
                        vo.setErrorMsg("管理黑名单（客户编号）所属组织错误");
                        continue;
                    }
                    EmployeeCustomerBlacklistReqDto customerBlacklistReqDto = new EmployeeCustomerBlacklistReqDto();
                    customerBlacklistReqDto.setCustomerId(customerBlacklistRespDto.getId());
                    customerBlacklistReqDto.setStartTime(new Date());
                    vo.setCustomerBlackDto(customerBlacklistReqDto);
                }

            }

        }
        return list;
    }


    /**
     * 合并数据（合并重复的数据）
     * @param list 原数据
     * @return
     */
    private List<EmployeeOrgExcelRespDto> mergeOrgData(List<EmployeeOrgExcelRespDto> list) {
        if(CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        //根据账户进行分组
        Map<String, List<EmployeeOrgExcelRespDto>> employeeGroupMap = list.stream().collect(Collectors.groupingBy(dto ->dto.getOrgId()+"_"+dto.getAccount()));
        List<EmployeeOrgExcelRespDto> resultVoList = Lists.newArrayList();
        for (String account : employeeGroupMap.keySet()) {
            List<EmployeeOrgExcelRespDto> employeeExcelVos = employeeGroupMap.get(account);
            EmployeeOrgExcelRespDto vo = new EmployeeOrgExcelRespDto();
            CubeBeanUtils.copyProperties(vo,employeeExcelVos.get(0));
            //合并多个角色
            List<EmployeeRoleReqDto> roleList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getRole())).map(EmployeeOrgExcelRespDto::getRole)
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(EmployeeRoleReqDto:: getRoleId))), ArrayList::new));
            if(CollectionUtils.isNotEmpty(roleList)){
                vo.setRoleList(roleList);
            }
            //合并多个区域
            List<EmployeeRegionReqDto> areaList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getArea())).map(EmployeeOrgExcelRespDto::getArea)
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(EmployeeRegionReqDto :: getRegionCode))), ArrayList::new));
            if(CollectionUtils.isNotEmpty(areaList)){
                vo.setAreaList(areaList);
            }
            //合并多个管理客户
            List<EmployeeCustomerReqDto> customerInfoList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getCustomerDto())).map(EmployeeOrgExcelRespDto::getCustomerDto)
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(EmployeeCustomerReqDto :: getCustomerId))), ArrayList::new));
            if(CollectionUtils.isNotEmpty(customerInfoList)){
                vo.setCustomerInfoList(customerInfoList);
            }
            //合并多个黑名单客户
            List<EmployeeCustomerBlacklistReqDto> customerBlackList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getCustomerBlackDto())).map(EmployeeOrgExcelRespDto::getCustomerBlackDto)
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(EmployeeCustomerBlacklistReqDto :: getCustomerId))), ArrayList::new));
            if(CollectionUtils.isNotEmpty(customerBlackList)){
                vo.setCustomerBlackList(customerBlackList);
            }
            resultVoList.add(vo);
        }

        return resultVoList;
    }

    /**
     *
     * @param list 原数据
     * @param account 账号
     * @param errorMsg 错误信息
     * @return
     */
    public List<EmployeeOrgExcelRespDto> setErrorsOrgMsg(List<EmployeeOrgExcelRespDto> list,String account,Long orgId,String errorMsg){
        list.forEach(vo->{
            if(StringUtils.isBlank(vo.getErrorMsg()) && vo.getAccount().equals(account) && vo.getOrgId().equals(orgId)){
                vo.setErrorMsg(errorMsg);
            }
        });
        return list;
    }

    /**
     * 校验满足 1-20位数字
     * @param str
     * @return
     */
    private boolean checkPhoneNum(String str){
        String patent = "^(13[0-9]|14[5|7]|15[0|1|2|3|5|6|7|8|9]|18[0|1|2|3|5|6|7|8|9])\\d{8}$";
        return Pattern.matches(patent, str);
    }


}
