/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl.user;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.dto.entity.NacosPropertiesOrgEntity;
import com.dtyunxi.yundt.cube.center.user.api.dto.entity.ImportBaseResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeImportReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleExpandRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserOrgizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandReqDto;
import com.dtyunxi.yundt.module.customer.api.user.IB2bEmployeeExpandService;
import com.dtyunxi.yundt.module.customer.api.user.IEmployeeExpand2Service;
import com.dtyunxi.yundt.module.customer.api.vo.B2bEmployeeExcelVo;
import com.dtyunxi.yundt.module.customer.biz.util.CommonUtil;
import com.dtyunxi.yundt.module.customer.biz.util.EasyPoiExportUtil;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class B2bEmployeeExpandServiceImpl
implements IB2bEmployeeExpandService {
    private static final Logger logger = LoggerFactory.getLogger(B2bEmployeeExpandServiceImpl.class);
    @Resource
    private IEmployeeExpand2Service employeeExpand2Service;
    @Resource
    private NacosPropertiesOrgEntity nacosPropertiesOrgEntity;
    @Resource
    private HttpServletRequest request;
    @Resource
    private IContext context;

    public String headerOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    public Long tenantId() {
        Long tenantId = this.context.tenantId();
        logger.info("tenantId >>> {}", (Object)tenantId);
        return tenantId;
    }

    public RestResponse<ImportBaseResponse> importB2bExcelEmployee(EmployeeImportReqDto importReqDto) {
        logger.info("importB2bExcelEmployee==>{}", (Object)JSON.toJSONString((Object)importReqDto));
        String fileUrl = importReqDto.getFileUrl();
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        Long instanceId = importReqDto.getInstanceId();
        AssertUtil.assertNotNull((Object)instanceId, (String)"\u5bfc\u5165\u7684\u5b9e\u4f8bID\u4e3a\u7a7a");
        String orgIdStr = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
        if (StringUtils.isBlank((CharSequence)orgIdStr)) {
            orgIdStr = this.nacosPropertiesOrgEntity.orgId();
            logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
        }
        AssertUtil.assertNotBlank((String)orgIdStr, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        Long orgId = Long.valueOf(orgIdStr);
        ImportBaseResponse response = new ImportBaseResponse();
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        importParams.setKeyIndex(null);
        List<B2bEmployeeExcelVo> importDataList = new ArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)EasyPoiExportUtil.getInputStream(fileUrl), B2bEmployeeExcelVo.class, (ImportParams)importParams);
            if (ObjectUtils.isNotEmpty((Object)result)) {
                importDataList = result.getList();
                importDataList = BeanPropertyNullUtil.getAllFieldNullList(importDataList);
            }
            if (CollectionUtils.isEmpty(importDataList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            e.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        if (CollectionUtils.isEmpty(importDataList)) {
            response.setTotalNum(0);
            response.setSuccessNum(0);
            response.setErrorNum(0);
            return new RestResponse((Object)response);
        }
        logger.info("\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(importDataList));
        response.setTotalNum(importDataList.size());
        List roleNameList = importDataList.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)data.getRoleName())).map(B2bEmployeeExcelVo::getRoleName).distinct().collect(Collectors.toList());
        Map roleMap = this.employeeExpand2Service.getRoleMap(roleNameList, orgId);
        List accountList = importDataList.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)data.getAccount())).map(B2bEmployeeExcelVo::getAccount).distinct().collect(Collectors.toList());
        logger.info("\u83b7\u53d6\u8d26\u6237\u4fe1\u606f\u83b7\u53d6\u8d26\u53f7\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(accountList));
        Map userOrgMap = this.employeeExpand2Service.getAccoutMap(accountList);
        importDataList = this.verifyData(importDataList, roleMap, userOrgMap, orgId);
        List<B2bEmployeeExcelVo> successList = importDataList.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorMsg())).collect(Collectors.toList());
        List<B2bEmployeeExcelVo> employeeExcelVoList = this.mergeData(successList);
        Map employeeInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(employeeExcelVoList)) {
            List userIdList = employeeExcelVoList.stream().map(B2bEmployeeExcelVo::getUserId).collect(Collectors.toList());
            employeeInfoMap = this.employeeExpand2Service.getEmployeeMap(userIdList, Collections.singletonList(employeeExcelVoList.get(0).getOrgId()));
        }
        for (B2bEmployeeExcelVo data2 : employeeExcelVoList) {
            EmployeeExpandReqDto employeeExtReqDto = new EmployeeExpandReqDto();
            employeeExtReqDto.setOrganizationId(data2.getOrgId());
            employeeExtReqDto.setOrgId(data2.getOrgId());
            employeeExtReqDto.setOrganizationStatus(YesOrNoEnum.NO.getStatus());
            employeeExtReqDto.setName(data2.getUserName());
            employeeExtReqDto.setPosition(data2.getPosition());
            employeeExtReqDto.setSex(data2.getSex());
            employeeExtReqDto.setStation(data2.getDepartment());
            employeeExtReqDto.setEmployeeNo(data2.getJobNumber());
            employeeExtReqDto.setPhoneNum(data2.getPhoneNumber());
            employeeExtReqDto.setEmployeeRoleDtoList(data2.getRoleList());
            employeeExtReqDto.setUserId(data2.getUserId());
            employeeExtReqDto.setStartTime(new Date());
            employeeExtReqDto.setStatus(Integer.valueOf(1));
            employeeExtReqDto.setType(Integer.valueOf(0));
            String key = data2.getOrgId() + "_" + data2.getUserId();
            try {
                if (!employeeInfoMap.isEmpty() && employeeInfoMap.containsKey(key)) {
                    Long id = (Long)employeeInfoMap.get(key);
                    employeeExtReqDto.setId(id);
                    logger.info("\u4fee\u6539b2b\u4eba\u5458\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)employeeExtReqDto));
                    this.employeeExpand2Service.modifyEmployee(instanceId, employeeExtReqDto);
                    continue;
                }
                logger.info("\u65b0\u589eb2b\u4eba\u5458\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)employeeExtReqDto));
                this.employeeExpand2Service.addEmployee(instanceId, employeeExtReqDto);
            }
            catch (Exception e) {
                logger.info("\u54c1\u724c\u7aef\u4eba\u5458\u6267\u884c\u5931\u8d25:{}", (Throwable)e);
                this.setErrorsMsg(importDataList, data2.getAccount(), "\u6267\u884c\u5931\u8d25\uff01" + e.getMessage());
            }
        }
        List errorList = importDataList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(errorList)) {
            response.setErrorNum(errorList.size());
            String excelName = "\u54c1\u724c\u7aef\u4eba\u5458\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, B2bEmployeeExcelVo.class, null, excelName, "xls");
                response.setErrorFileUrl(exportUrl);
            }
            catch (Exception e) {
                logger.info("\u54c1\u724c\u7aef\u4eba\u5458\u5bfc\u5165\u5931\u8d25\u4fe1\u606f\u6587\u4ef6\u751f\u6210\u5931\u8d25");
                logger.info(e.getMessage(), (Throwable)e);
            }
        }
        response.setSuccessNum(response.getTotalNum() - response.getErrorNum());
        return new RestResponse((Object)response);
    }

    public List<B2bEmployeeExcelVo> setErrorsMsg(List<B2bEmployeeExcelVo> list, String account, String errorMsg) {
        list.forEach(vo -> {
            if (StringUtils.isBlank((CharSequence)vo.getErrorMsg()) && vo.getAccount().equals(account)) {
                vo.setErrorMsg(errorMsg);
            }
        });
        return list;
    }

    public List<B2bEmployeeExcelVo> verifyData(List<B2bEmployeeExcelVo> list, Map<String, List<RoleExpandRespDto>> roleMap, Map<String, List<UserOrgizationRespDto>> userOrgMap, Long orgId) {
        for (B2bEmployeeExcelVo vo : list) {
            if (StringUtils.isBlank((CharSequence)vo.getAccount())) {
                vo.setErrorMsg("\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (userOrgMap.isEmpty() || !userOrgMap.containsKey(vo.getAccount())) {
                vo.setErrorMsg("\u767b\u5f55\u8d26\u53f7\u9519\u8bef");
                continue;
            }
            List<UserOrgizationRespDto> userOrgizationVos = userOrgMap.get(vo.getAccount());
            List userOrgList = userOrgizationVos.stream().filter(e -> orgId.compareTo(e.getOrgId()) == 0).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(userOrgList)) {
                vo.setErrorMsg("\u767b\u5f55\u8d26\u53f7\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                continue;
            }
            vo.setUserId(((UserOrgizationRespDto)userOrgList.get(0)).getUserId());
            vo.setOrgId(orgId);
            if (StringUtils.isBlank((CharSequence)vo.getUserName())) {
                vo.setErrorMsg("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)vo.getPosition())) {
                vo.setErrorMsg("\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getRoleName()})) {
                if (roleMap.isEmpty() || !roleMap.containsKey(vo.getRoleName())) {
                    vo.setErrorMsg("\u89d2\u8272\u9519\u8bef");
                    continue;
                }
                List<RoleExpandRespDto> roleExpandEos = roleMap.get(vo.getRoleName());
                List orgRoleList = roleExpandEos.stream().filter(e -> Objects.nonNull(e.getBelongOrgId()) && e.getBelongOrgId().compareTo(vo.getOrgId()) == 0 || e.getRoleType() == 1).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(orgRoleList)) {
                    vo.setErrorMsg("\u89d2\u8272\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                    continue;
                }
                EmployeeRoleReqDto employeeRoleReqDto = new EmployeeRoleReqDto();
                employeeRoleReqDto.setRoleId(((RoleExpandRespDto)orgRoleList.get(0)).getId());
                employeeRoleReqDto.setRoleCode(((RoleExpandRespDto)orgRoleList.get(0)).getCode());
                vo.setRole(employeeRoleReqDto);
            }
            if (!StringUtils.isNotEmpty((CharSequence)vo.getPhoneNumber()) || CommonUtil.checkPhoneNum(vo.getPhoneNumber())) continue;
            vo.setErrorMsg("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e;");
        }
        return list;
    }

    private List<B2bEmployeeExcelVo> mergeData(List<B2bEmployeeExcelVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        Map<String, List<B2bEmployeeExcelVo>> employeeGroupMap = list.stream().collect(Collectors.groupingBy(B2bEmployeeExcelVo::getAccount));
        ArrayList resultVoList = Lists.newArrayList();
        for (String account : employeeGroupMap.keySet()) {
            List<B2bEmployeeExcelVo> employeeExcelVos = employeeGroupMap.get(account);
            B2bEmployeeExcelVo vo = new B2bEmployeeExcelVo();
            CubeBeanUtils.copyProperties((Object)vo, (Object)employeeExcelVos.get(0), (String[])new String[0]);
            List roleList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getRole())).map(B2bEmployeeExcelVo::getRole).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EmployeeRoleReqDto>(Comparator.comparing(EmployeeRoleReqDto::getRoleId))), ArrayList::new));
            if (CollectionUtils.isNotEmpty((Collection)roleList)) {
                vo.setRoleList(roleList);
            }
            resultVoList.add(vo);
        }
        return resultVoList;
    }
}

