/*
 * *
 *  @(#)MqUtils.java 1.0 19-7-13 下午5:08
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * /
 */

package com.dtyunxi.yundt.module.customer.biz.mq.producer;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.yundt.cube.center.user.api.dto.CustomerOrgInfoDto;
import com.dtyunxi.yundt.module.customer.biz.mq.constants.MessageTag;
import com.dtyunxi.yundt.module.customer.biz.mq.constants.MessageTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;


/**
 * 客户新增或修改通用消息发送/生产
 * @author sumo on 2021/4/13
 */
@Component
public class CustomerChangeProducer {
    private static Logger logger = LoggerFactory.getLogger(CustomerChangeProducer.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private Environment environment;


    /**
     * 客户新增或修改
     */
    public void sendCustomerChangeMq(CustomerOrgInfoDto orgInfoDto) {
        logger.info("发送客户新增或修改信息: {}", JSON.toJSONString(orgInfoDto));
        commonsMqService.sendSingleMessage(environment.resolvePlaceholders(MessageTopic.CUSTOMER_CHANGE_TOPIC),MessageTag.CUSTOMER_CHANGE_TAG, JSON.toJSONString(orgInfoDto));

    }

}
