package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerAreaListExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeRegionQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleExpandRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserOrgizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserOrgExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.SellerEmployeeImportDto;
import com.dtyunxi.yundt.module.customer.api.user.IEmployeeExpand2Service;
import com.dtyunxi.yundt.module.customer.api.user.ISellerEmployeeExtService;
import com.dtyunxi.yundt.module.customer.biz.util.CommonUtil;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.CustomerExtReqDto;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * @Description 商家人员处理
 * @date 2022-01-14 14:06
 * @since 1.0.0
 */
@Service
public class SellerEmployeeExtServiceImpl implements ISellerEmployeeExtService {

    private static final Logger logger = LoggerFactory.getLogger(SellerEmployeeExtServiceImpl.class);
    @Resource
    private IAccessQueryApi accessQueryApi;
    @Resource
    private IEmployeeRegionQueryApi employeeRegionQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;

    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;
    @Resource
    private IEmployeeExpand2Service employeeExpand2Service;
    @Resource
    private IUserOrgExpandQueryApi userOrgExpandQueryApi;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;
    /**
     * 商家人员导入-数据传输的时候已经校验必填字段
     * @return
     */
    @Override
    //@Transactional
    public RestResponse<List<SellerEmployeeImportDto>> doSellerEmployeeImport(List<SellerEmployeeImportDto> importDataList){
        logger.info("商家人员导入数据大小:{}",JSON.toJSONString(importDataList.size()));

        List<SellerEmployeeImportDto> successList = importDataList.stream().filter(dto -> StringUtils.isEmpty(dto.getErrorReason())).collect(Collectors.toList());
        //获取账户信息
        List<String> accountList = successList.stream().map(SellerEmployeeImportDto::getAccount).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        Map<String, List<UserOrgizationRespDto>> userOrgMap = employeeExpand2Service.getAccoutMap(accountList);
        /* 校验数据 */
        importDataList = this.verifyData(importDataList,userOrgMap);
        /* 获取角色列表数据 */
        List<String> roleNameList = importDataList.stream().map(SellerEmployeeImportDto::getRoleName).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        Map<String, List<RoleExpandRespDto>> roleMap =employeeExpand2Service.getRoleMap(roleNameList,null);
        logger.info("roleMap:{}",JSON.toJSONString(importDataList.size()));

        //获取客户区域
        Map<String, List<CustomerAreaRespDto>> customerAreasMap = new HashMap<>();
        List<String> governAreaList = successList.stream().map(SellerEmployeeImportDto::getGovernArea).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(governAreaList)) {
            CustomerAreaListExtReqDto areaListReqDto = new CustomerAreaListExtReqDto();
            areaListReqDto.setNameList(governAreaList);
            RestResponse<List<CustomerAreaRespDto>> areaRest = employeeRegionQueryApi.queryCustomerAreaByNames(areaListReqDto);
            if (null != areaRest && CollectionUtils.isNotEmpty(areaRest.getData())) {
                List<CustomerAreaRespDto> customerAreaList = areaRest.getData();
                if (CollectionUtils.isNotEmpty(customerAreaList)) {
                    customerAreasMap = customerAreaList.stream().collect(Collectors.groupingBy(CustomerAreaRespDto::getName));
                }
            }
        }
        List<String> customerCodeList = successList.stream().map(SellerEmployeeImportDto::getGovernCustomer).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        List<String> blackCustomerCodelist = successList.stream().map(SellerEmployeeImportDto::getBlacklist).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        List<String> customerOrgIdList = Lists.newArrayList(customerCodeList);
        customerOrgIdList.addAll(blackCustomerCodelist);
        //根据客户组织id和商家id获取客户信息
        CustomerExtReqDto  customerExtReqDto = new CustomerExtReqDto();
        Long orgId = successList.get(0).getOrgId();
        customerExtReqDto.setMerchantIdList(Lists.newArrayList(orgId));
        customerExtReqDto.setCodes(customerOrgIdList);
        List<CustomerRespDto> customerRespDtos = RestResponseHelper.extractData(employeeCustomerQueryApi.queryCustomerByDto(customerExtReqDto));
        Map<String, CustomerRespDto> customerMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(customerRespDtos)){
            customerMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        }
        /* 校验数据 */
        importDataList = this.verifyOrgData(importDataList,roleMap,customerAreasMap,customerMap,userOrgMap);
        successList = importDataList.stream().filter(dto -> StringUtils.isEmpty(dto.getErrorReason())).collect(Collectors.toList());
        logger.info("校验数据后成功集合大小:{}",successList.size());
        /* 合并数据 */
        successList = this.mergeOrgData(successList);
//        Map<String,Long> employeeInfoMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(successList)){
            List<Long> userIdList = successList.stream().map(SellerEmployeeImportDto::getUserId).distinct().collect(Collectors.toList());
            List<Long> orgIdList = successList.stream().map(SellerEmployeeImportDto::getOrgId).distinct().collect(Collectors.toList());
//            employeeInfoMap = employeeExpand2Service.getEmployeeMap(userIdList,orgIdList);
        }

        /* 处理数据 */
        for (SellerEmployeeImportDto data : successList){
            //构建人员对象
            EmployeeExpandReqDto employeeExtReqDto = new EmployeeExpandReqDto();
            employeeExtReqDto.setOrganizationId(data.getOrgId());
            employeeExtReqDto.setOrgId(data.getOrgId());
            employeeExtReqDto.setOrganizationStatus(YesOrNoEnum.NO.getStatus());
            employeeExtReqDto.setName(data.getUserName());//姓名
            employeeExtReqDto.setPosition(data.getPosition());//职位
            employeeExtReqDto.setSex(data.getSex());//性别
            employeeExtReqDto.setStation(data.getDepartment());//部门
            // 设置人员类型，内部为0，外部为1
            employeeExtReqDto.setPersonType("内部".equals(data.getEmployeeType()) ? "Internal" : "External");
//            employeeExtReqDto.setEmployeeNo(data.getJobNumber());//工号
            employeeExtReqDto.setPhoneNum(data.getPhoneNumber());//手机号码
            employeeExtReqDto.setEmployeeRoleDtoList(data.getRoleList());//角色
            employeeExtReqDto.setUserId(data.getUserId());//账号
            employeeExtReqDto.setType(0);
            employeeExtReqDto.setStatus(1);
            employeeExtReqDto.setStartTime(new Date());
            employeeExtReqDto.setCustomerInfoList(data.getCustomerInfoList());
            employeeExtReqDto.setCustomerBlackList(data.getCustomerBlackList());
            employeeExtReqDto.setRegionInfoList(data.getAreaList());
            //查询该账号是否已被绑定，若已绑定，则修改，没有则新增
            //查询该账号在组织下是否已被绑定，若已绑定，则修改，没有则新增
//            String key = data.getOrgId() + "_" + data.getUserId();
            try {
//                if(!employeeInfoMap.isEmpty() && employeeInfoMap.containsKey(key)){
//                    Long id = employeeInfoMap.get(key);
//                    //修改
//                    employeeExtReqDto.setId(id);
//                    logger.info("导入商家人员修改:{}",JSON.toJSONString(employeeExtReqDto));
//                    employeeExpand2Service.modifyEmployee(data.getInstanceId(),employeeExtReqDto);
//                }else {
                    //新增 只处理新增，修改暂时不做了
                    logger.info("导入商家人员新增:{}",JSON.toJSONString(employeeExtReqDto));
                    employeeExpand2Service.addEmployee(data.getInstanceId(),employeeExtReqDto);
//                }
            }catch (Exception e){
                logger.info("导入商家人员根据人员失败:"+e.getMessage());
                setErrorsMsg(importDataList,data.getAccount(),"执行失败！"+e.getMessage());
            }
        }
        logger.info("商家人员导入结束");

        return new RestResponse<>(importDataList);
    }
    public  Map<String, List<UserOrgizationRespDto>> getAccoutMap(List<String> accountList){
        if(CollectionUtils.isEmpty(accountList)){
            return new HashMap<>();
        }
        Map<String, List<UserOrgizationRespDto>> userOrgMap = new HashMap<>(accountList.size() *4/3+2);
        List<UserOrgizationRespDto> userOrgInfoList = RestResponseHelper.extractData(userOrgExpandQueryApi.queryUserOrgByUserName(accountList));
        if(CollectionUtils.isEmpty(userOrgInfoList)){
            return userOrgMap;
        }
        userOrgMap = userOrgInfoList.stream().collect(Collectors.groupingBy(UserOrgizationRespDto::getUserName));
        return userOrgMap;
    }

    private List<SellerEmployeeImportDto> verifyData(List<SellerEmployeeImportDto> importDataList, Map<String, List<UserOrgizationRespDto>> userOrgMap) {

        for (SellerEmployeeImportDto vo : importDataList) {
            if (StringUtils.isBlank(vo.getAccount())){
                vo.setErrorReason("登录账号不能为空");
                continue;
            }

            if(userOrgMap.isEmpty() || !userOrgMap.containsKey(vo.getAccount())){
                vo.setErrorReason("登录账号错误");
                continue;
            }

            if (StringUtils.isBlank(vo.getUserName())){
                vo.setErrorReason("姓名不能为空");
                continue;
            }
            if (StringUtils.isBlank(vo.getPosition())){
                vo.setErrorReason("职位不能为空");
                continue;
            }
            if (StringUtils.isBlank(vo.getEmployeeType())){
                vo.setErrorReason("人员类型不能为空");
                continue;
            }
            if(StringUtils.isBlank(vo.getPhoneNumber())){
                vo.setErrorReason("手机号不能为空");
                continue;
            }
            if (!("内部".equals(vo.getEmployeeType()) || "外部".equals(vo.getEmployeeType()))){
                vo.setErrorReason("人员类型只能为'内部'或'外部'");
                continue;
            }
            if(StringUtils.isNotEmpty(vo.getPhoneNumber())){
                if(!CommonUtil.checkPhoneNum(vo.getPhoneNumber())){
                    vo.setErrorReason("手机号格式不正确;");
                    continue;
                }

            }
            // 校验手机号和姓名在当前租户下唯一 todo 后面优化为批量的
            String userName = vo.getUserName();
            String phoneNumber = vo.getPhoneNumber();
            EmployeeExtQueryReqDto expandReqDto =  new EmployeeExtQueryReqDto();
            expandReqDto.setName(userName);
            expandReqDto.setPhoneNum(phoneNumber);
            expandReqDto.setOrganizationId(vo.getOrgId());
            List<EmployeeExtRespDto> employeeExtRespDtos = checkNameAndPhoneNum(expandReqDto);
            if (CollectionUtils.isNotEmpty(employeeExtRespDtos) && !Objects.isNull(employeeExtRespDtos.get(0).getId())) {
                vo.setErrorReason("手机号为:"+phoneNumber+",或者姓名:"+userName+"已经存在");
                continue;
            }
        }
        return importDataList;
    }

    private List<EmployeeExtRespDto> checkNameAndPhoneNum(EmployeeExtQueryReqDto employeeDto) {
        return employeeExpandQueryApi.queryEmployeeByPhoneNumOrg(employeeDto).getData();
//        AssertUtil.isTrue(CollectionUtils.isNotEmpty(employeeExtRespDtos) && !Objects.isNull(employeeExtRespDtos.get(0).getId()) , "手机号为:"+employeeDto.getPhoneNum()+",或者姓名:"+employeeDto.getName()+"已经存在");
    }

    /**
     *
     * @param list 原数据
     * @param account 账号
     * @param errorMsg 错误信息
     * @return
     */
    public List<SellerEmployeeImportDto> setErrorsMsg(List<SellerEmployeeImportDto> list, String account, String errorMsg){
        list.forEach(vo->{
            if(StringUtils.isBlank(vo.getErrorReason()) && vo.getAccount().equals(account)){
                vo.setErrorReason(errorMsg);
            }
        });
        return list;
    }

    /**
     * 校验数据
     * @param list 原数据
     * @return
     */
    private List<SellerEmployeeImportDto> verifyOrgData(List<SellerEmployeeImportDto> list,  Map<String,List<RoleExpandRespDto>>  roleMap, Map<String,
            List<CustomerAreaRespDto>> areasMap, Map<String, CustomerRespDto> customerMap ,   Map<String, List<UserOrgizationRespDto>> userOrgMap ){
        for (SellerEmployeeImportDto dto : list) {
            if(StringUtils.isNotEmpty(dto.getErrorReason())){
                continue;
            }
            Long orgId = dto.getOrgId();
            if(userOrgMap.isEmpty() || !userOrgMap.containsKey(dto.getAccount())){
                dto.setErrorReason("登录账号错误;");
                continue;
            }

            List<UserOrgizationRespDto> userOrgizationVos = userOrgMap.get(dto.getAccount());

            List<UserOrgizationRespDto> userOrgList = userOrgizationVos.stream().filter(e -> orgId.compareTo(e.getOrgId()) == 0).collect(Collectors.toList());
            if(CollectionUtils.isEmpty(userOrgList)){
                dto.setErrorReason("登录账号所属组织错误");
                continue;
            }
            dto.setUserId(userOrgList.get(0).getUserId());
            if (StringUtils.isNoneBlank(dto.getRoleName())){
                if(roleMap.isEmpty() || !roleMap.containsKey(dto.getRoleName())){
                    dto.setErrorReason("角色错误");
                    continue;
                }
                List<RoleExpandRespDto> roleExpandEos = roleMap.get(dto.getRoleName());
                List<RoleExpandRespDto> orgRoleList = roleExpandEos.stream()
                        .filter(e -> (Objects.nonNull(e.getBelongOrgId()) && e.getBelongOrgId().compareTo(dto.getOrgId()) == 0)|| e.getRoleType() == 1)
                        .collect(Collectors.toList());
                if(CollectionUtils.isEmpty(orgRoleList)){
                    dto.setErrorReason("角色所属组织错误");
                    continue;
                }
                EmployeeRoleReqDto employeeRoleReqDto = new EmployeeRoleReqDto();
                employeeRoleReqDto.setRoleId(orgRoleList.get(0).getId());
                employeeRoleReqDto.setRoleCode(orgRoleList.get(0).getCode());
                dto.setRole(employeeRoleReqDto);

            }
            if (StringUtils.isNoneBlank(dto.getGovernArea())){
                List<CustomerAreaRespDto> customerAreaRespDtos = areasMap.get(dto.getGovernArea());
                if(areasMap.isEmpty() || !areasMap.containsKey(dto.getGovernArea())){
                    dto.setErrorReason("管理区域错误");
                    continue;
                }
                List<CustomerAreaRespDto> orgAreaList = customerAreaRespDtos.stream().filter(e -> Objects.equals(e.getOrgInfoId(),dto.getOrgId())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(orgAreaList)){
                    dto.setErrorReason("管理区域所属组织错误");
                    continue;
                }
                EmployeeRegionReqDto employeeRegionReqDto = new EmployeeRegionReqDto();
                employeeRegionReqDto.setRegionCode(orgAreaList.get(0).getCode());
                employeeRegionReqDto.setStartTime(new Date());
                dto.setArea(employeeRegionReqDto);
            }
            if (StringUtils.isNoneBlank(dto.getGovernCustomer())){
                CustomerRespDto customerRespDto = customerMap.get(dto.getGovernCustomer());
                if (Objects.isNull(customerRespDto)){
                    dto.setErrorReason("管理客户（组织ID）错误;");
                    continue;
                }
                EmployeeCustomerReqDto employeeCustomerReqDto = new EmployeeCustomerReqDto();
                employeeCustomerReqDto.setCustomerId(customerRespDto.getId());
                employeeCustomerReqDto.setStartTime(new Date());
                dto.setCustomerDto(employeeCustomerReqDto);
            }
            if (StringUtils.isNoneBlank(dto.getBlacklist())){
                CustomerRespDto customerRespDto = customerMap.get(dto.getBlacklist());
                if (Objects.isNull(customerRespDto)){
                    dto.setErrorReason("管理黑名单（组织ID）错误;");
                    continue;
                }
                EmployeeCustomerBlacklistReqDto customerBlacklistReqDto = new EmployeeCustomerBlacklistReqDto();
                customerBlacklistReqDto.setCustomerId(customerRespDto.getId());
                customerBlacklistReqDto.setStartTime(new Date());
                dto.setCustomerBlackDto(customerBlacklistReqDto);
            }

        }
        return list;
    }

    /**
     * 合并数据（合并重复的数据）
     * @param list 原数据
     * @return
     */
    private List<SellerEmployeeImportDto> mergeOrgData(List<SellerEmployeeImportDto> list) {
        if(CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        //根据账户进行分组
        Map<String, List<SellerEmployeeImportDto>> employeeGroupMap = list.stream().collect(Collectors.groupingBy(dto ->dto.getOrgId()+"_"+dto.getAccount()));
        List<SellerEmployeeImportDto> resultVoList = Lists.newArrayList();
        for (String account : employeeGroupMap.keySet()) {
            List<SellerEmployeeImportDto> employeeExcelVos = employeeGroupMap.get(account);
            SellerEmployeeImportDto vo = new SellerEmployeeImportDto();
            CubeBeanUtils.copyProperties(vo,employeeExcelVos.get(0));
            //合并多个角色
            List<EmployeeRoleReqDto> roleList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getRole())).map(SellerEmployeeImportDto::getRole)
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(EmployeeRoleReqDto:: getRoleId))), ArrayList::new));
            if(CollectionUtils.isNotEmpty(roleList)){
                vo.setRoleList(roleList);
            }
            //合并多个区域
            List<EmployeeRegionReqDto> areaList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getArea())).map(SellerEmployeeImportDto::getArea)
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(EmployeeRegionReqDto :: getRegionCode))), ArrayList::new));
            if(CollectionUtils.isNotEmpty(areaList)){
                vo.setAreaList(areaList);
            }
            //合并多个管理客户
            List<EmployeeCustomerReqDto> customerInfoList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getCustomerDto())).map(SellerEmployeeImportDto::getCustomerDto)
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(EmployeeCustomerReqDto :: getCustomerId))), ArrayList::new));
            if(CollectionUtils.isNotEmpty(customerInfoList)){
                vo.setCustomerInfoList(customerInfoList);
            }
            //合并多个黑名单客户
            List<EmployeeCustomerBlacklistReqDto> customerBlackList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getCustomerBlackDto())).map(SellerEmployeeImportDto::getCustomerBlackDto)
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(EmployeeCustomerBlacklistReqDto :: getCustomerId))), ArrayList::new));
            if(CollectionUtils.isNotEmpty(customerBlackList)){
                vo.setCustomerBlackList(customerBlackList);
            }
            resultVoList.add(vo);
        }
        return resultVoList;
    }


}
