/*
 * @(#) IRoleService.java 1.1.0 2019-06-24
 * Copyright (c)  2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.module.customer.biz.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserAccessRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserAccessVo;

/**
 * 角色相关
 *
 * @author sumo on 2020/10/21 0021
 */
public interface IRoleService {

    /**
     * 查询用户实例的角色列表与权限
     *
     * @param appInstanceId
     * @param userId
     * @return
     */
    RestResponse<UserAccessVo> queryUserAccess(Long appInstanceId, Long userId);


    /**
     * 查询用户实例的角色列表与权限
     *
     * @param userId
     * @return
     */
    RestResponse<UserAccessRespDto> queryUserAccessResources(Long userId);

}
