/**
 * @(#)IOauth2LoginImpl.java 1.0 2019年7月17日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.yundt.cube.center.identity.api.IThirdLoginApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdUserInfoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.user.IOauth2Login;
import com.dtyunxi.yundt.module.customer.api.user.IWeixinService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 第三方登录服务实现
 *
 * @author wu.sheng
 * @time 2019年7月17日 下午2:29:25
 */
@Component
public class Oauth2LoginImpl implements IOauth2Login {

    private static final Logger logger = LoggerFactory.getLogger(Oauth2LoginImpl.class);

    @Resource
    private IThirdLoginApi thirdLoginApi;

    @Resource
    private IContext context;

    @Resource
    private ICacheService cacheService;

    @Resource
    private IWeixinService weixinService;

    /**
     * 接受微信code地址
     */
    @Value("${systemCodeUri:}")
    private String systemCodeUri;


    @Override
    public String getAuthUri(AuthLoginReqDto authLoginReqDto) {

        // 将前端回调地址暂时缓存起来
        String uriKey = MD5Util.getMd5ByString(authLoginReqDto.getRedirectUri());
        cacheService.add(uriKey, authLoginReqDto.getRedirectUri());

        String redirectUri = systemCodeUri + "?uriKey=" + uriKey;

        // 设置第三方登录参数，返回第三方登录入口
        if(authLoginReqDto.getConfigLevel() == null) {
            authLoginReqDto.setConfigLevel(1);
        }
        authLoginReqDto.setInstanceId(context.instanceId());
        authLoginReqDto.setTenantId(context.tenantId());
        authLoginReqDto.setLoginSource(2);

        // 重定向地址替换为后端服务地址
        authLoginReqDto.setRedirectUri(redirectUri);
        RestResponse<ThirdUserInfoRespDto> restResponse = thirdLoginApi.thirdAuth(authLoginReqDto);

        ThirdUserInfoRespDto thirdUserInfoRespDto = RestResponseHelper.extractData(restResponse);

        return thirdUserInfoRespDto == null ? null : thirdUserInfoRespDto.getResultUrl();
    }

    @Override
    public ThirdLoginRespDto getAuthToken(AuthLoginTokenReqDto authLoginTokenReqDto) {
        if(authLoginTokenReqDto.getConfigLevel() == null) {
            authLoginTokenReqDto.setConfigLevel(1);
        }
        authLoginTokenReqDto.setInstanceId(context.instanceId());
        authLoginTokenReqDto.setTenantId(context.tenantId());
        RestResponse<ThirdLoginRespDto> restResponse = thirdLoginApi.tokenAuth(authLoginTokenReqDto);

        ThirdLoginRespDto thirdLoginRespDto = RestResponseHelper.extractData(restResponse);

        return thirdLoginRespDto;
    }

    @Override
    public TokenRespDto bind(UserBindLoginThirdDto userBindLoginThirdDto) {
        userBindLoginThirdDto.setInstanceId(context.instanceId());
        userBindLoginThirdDto.setTenantId(context.tenantId());
        RestResponse<TokenRespDto> restResponse = thirdLoginApi.bindLogin(userBindLoginThirdDto);
        TokenRespDto tokenRespDto = RestResponseHelper.extractData(restResponse);

        return tokenRespDto;
    }
}
