package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerQueryV3Api;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeRoleApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IRoleQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.RoleQueryReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.IEmployeeRoleService;
import com.github.pagehelper.PageInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author liangfa
 * @Description 人员角色信息接口
 * @date 2022-01-14 17:38
 * @since 1.0.0
 */
@Service
public class EmployeeRoleServiceImpl implements IEmployeeRoleService {

    private static final Logger log = LoggerFactory.getLogger(EmployeeRoleServiceImpl.class);

    @Resource
    private IEmployeeRoleApi employeeRoleApi;


    @Resource
    private ICustomerQueryV3Api customerQueryV3Api;
    @Resource
    private IRoleQueryApi roleQueryApi;
    
    @Resource
    private IContext context;

    @Override
    public RestResponse<Long> addEmployeeRole(Long instanceId, EmployeeRoleReqDto reqDto) {
        log.info("新增人员角色信息入参：reqDto={}", JSON.toJSONString(reqDto));
        return employeeRoleApi.addEmployeeRole(instanceId, reqDto);
    }

    @Override
    public RestResponse<Void> modifyEmployeeRole(Long instanceId, EmployeeRoleReqDto reqDto) {
        log.info("修改人员角色信息入参：reqDto={}", JSON.toJSONString(reqDto));
        return employeeRoleApi.modifyEmployeeRole(instanceId, reqDto);
    }

    @Override
    public RestResponse<Long> setSuperAdmin(Long instanceId, EmployeeRoleReqDto reqDto) {
        log.info("设置超级管理员入参：reqDto={}", JSON.toJSONString(reqDto));
        return employeeRoleApi.setSuperAdmin(instanceId, reqDto);
    }

    @Override
    public RestResponse<PageInfo<RoleDto>> queryPageRoleInfo(RoleQueryReqDto reqDto) {
        log.info("分页查询角色列表入参：reqDto={}", JSON.toJSONString(reqDto));
        
        // 构建查询条件
        Map<String, Object> filterMap = new HashMap<>();
        
        // 添加角色代码和名称过滤
        if (StringUtils.isNotBlank(reqDto.getCode())) {
            filterMap.put("code", reqDto.getCode());
        }
        if (StringUtils.isNotBlank(reqDto.getName())) {
            filterMap.put("name", reqDto.getName());
        }
        
        // 添加组织ID过滤
        if (CollectionUtils.isNotEmpty(reqDto.getOrgIds())) {
            filterMap.put("orgIds", reqDto.getOrgIds());
        } else {
            // 获取当前用户所属组织ID
            Long userOrgId = null;
            
            Object orgIdObj = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationId");
            if (orgIdObj != null) {
                userOrgId = Long.valueOf(orgIdObj.toString());
            }

            if (userOrgId != null) {
                List<CustomerRespDto> customerRespDtos = Optional.ofNullable(getCustomerRespDtos(userOrgId)).orElse(new ArrayList<>(0));
                List<Long> orgIdList = customerRespDtos.stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
                orgIdList.add(userOrgId);
                filterMap.put("orgIds", orgIdList);
            }
        }
        
        // 是否计算关联数量
        if (reqDto.getCountRelationUserAndGroupNum() != null && reqDto.getCountRelationUserAndGroupNum()) {
            filterMap.put("countRelationUserAndGroupNum", true);
        }
        
        // 调用角色查询API
        String filter = JSON.toJSONString(filterMap);
        log.info("查询角色列表过滤条件：filter={}", filter);
        
        RestResponse<PageInfo<RoleDto>> response = roleQueryApi.queryPageRoleInfo(null, filter, 
                reqDto.getPageNum(), reqDto.getPageSize());
        RestResponseHelper.checkOrThrow(response);
        return response;
    }

    @Nullable
    private List<CustomerRespDto> getCustomerRespDtos(Long orgId) {
        //客户人员查询
        CustomerSearchExtReqDto customerExtQuery = new CustomerSearchExtReqDto();
        customerExtQuery.setMerchantId(orgId);

        return RestResponseHelper.extractData(customerQueryV3Api.queryCustomerByExtDtoList(customerExtQuery));
    }
}
