package com.dtyunxi.yundt.module.customer.biz.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.CustomerStoreResponseDto;
import com.dtyunxi.tcbj.api.dto.response.StoreSalesmanRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternConfigReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternConfigRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckRelationRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.BizImportRespDto;
import com.github.pagehelper.PageInfo;
import org.springframework.web.multipart.MultipartFile;

/**
 * @author ghosn
 * @create 2023/4/6 14:27
 */
public interface IStoreCheckService {

    /**
     * 查询客户门店信息
     * @param filter
     * @param pageNum
     * @param pageSize
     * @return
     */
    PageInfo<CustomerStoreResponseDto> queryCustomerStorePage(String filter, Integer pageNum, Integer pageSize);


    /**
     * 查询经销商业务员关系
     * @param pageNum
     * @param pageSize
     * @return
     */
    PageInfo<StoreSalesmanRelationRespDto> queryPersonPartnerPage(String filter, Integer pageNum, Integer pageSize);

    /**
     * 绑定门店与业务考核关系
     * @param customerCheckRelationReqDto
     */
    void bindStoreAndSalesmanRelation(CustomerCheckRelationReqDto customerCheckRelationReqDto);

    /**
     * 人店考核关系数据导入
     *
     * @param file file
     * @return RestResponse<BizImportRespDto>
     */
    RestResponse<BizImportRespDto> exportCustomerCheckRelationByExcel(MultipartFile file) throws Exception;

    /**
     *  人店考核关系历史绑定列表查询
     * @param filter  filter
     * @param pageNum pageNum
     * @param pageSize pageSize
     * @return PageInfo<CustomerCheckRelationRespDto>
     */
    PageInfo<CustomerCheckRelationRespDto> queryStoreAndSalesmanRelationBindHistoryPage(String filter, Integer pageNum, Integer pageSize);

    /**
     * 门店考核合并白名单配置新增修改
     * @param addReqDto
     */
    void saveOrUpdateCustomerCheckPatternConfig(CustomerCheckPatternConfigReqDto addReqDto);

    /**
     *
     * @param filter
     * @param pageNum
     * @param pageSize
     * @return
     */
    PageInfo<CustomerCheckPatternConfigRespDto> queryPatternConfigByPage(String filter, Integer pageNum, Integer pageSize);


    /**
     *
     * @param file
     * @return
     * @throws Exception
     */
    BizImportRespDto exportPatternConfig(String customerCode, MultipartFile file) throws Exception;
}
