/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl.user;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerAreaListExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeRegionQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.entity.ImportBaseResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeImportReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleExpandRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserOrgizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.EmployeeOrgExcelRespDto;
import com.dtyunxi.yundt.module.customer.api.user.IEmployeeExpand2Service;
import com.dtyunxi.yundt.module.customer.api.user.IOrgEmployeeExpandService;
import com.dtyunxi.yundt.module.customer.biz.util.CommonUtil;
import com.dtyunxi.yundt.module.customer.biz.util.EasyPoiExportUtil;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgEmployeeExpandServiceImpl
implements IOrgEmployeeExpandService {
    private static final Logger logger = LoggerFactory.getLogger(OrgEmployeeExpandServiceImpl.class);
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;
    @Resource
    private IEmployeeRegionQueryApi employeeRegionQueryApi;
    @Resource
    private IEmployeeExpand2Service employeeExpand2Service;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private HttpServletRequest request;

    public RestResponse<ImportBaseResponse> importOrgExcelEmployee(EmployeeImportReqDto importReqDto) {
        logger.info("importOrgExcelEmployee==>{}", (Object)JSON.toJSONString((Object)importReqDto));
        String fileUrl = importReqDto.getFileUrl();
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        Long instanceId = importReqDto.getInstanceId();
        ImportBaseResponse response = new ImportBaseResponse();
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        List<EmployeeOrgExcelRespDto> importDataList = new ArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)EasyPoiExportUtil.getInputStream(fileUrl), EmployeeOrgExcelRespDto.class, (ImportParams)importParams);
            if (ObjectUtils.isNotEmpty((Object)result)) {
                importDataList = result.getList();
                importDataList = BeanPropertyNullUtil.getAllFieldNullList(importDataList);
            }
            if (CollectionUtils.isEmpty(importDataList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        response.setTotalNum(importDataList.size());
        List roleNameList = importDataList.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)data.getRoleName())).map(EmployeeOrgExcelRespDto::getRoleName).distinct().collect(Collectors.toList());
        Map roleMap = this.employeeExpand2Service.getRoleMap(roleNameList, null);
        List orgNameList = importDataList.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)data.getOrganizationName())).map(EmployeeOrgExcelRespDto::getOrganizationName).distinct().collect(Collectors.toList());
        Map orgInfoMap = this.employeeExpand2Service.getOrgByNameMap(orgNameList);
        List dealerCodeList = importDataList.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)data.getDealerCode())).map(EmployeeOrgExcelRespDto::getDealerCode).distinct().collect(Collectors.toList());
        Map orgCustomerMap = this.employeeExpand2Service.getOrgCustomerMap(dealerCodeList);
        List accountList = importDataList.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)data.getAccount())).map(EmployeeOrgExcelRespDto::getAccount).distinct().collect(Collectors.toList());
        logger.info("\u83b7\u53d6\u8d26\u6237\u4fe1\u606f\u83b7\u53d6\u8d26\u53f7\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(accountList));
        Map userOrgMap = this.employeeExpand2Service.getAccoutMap(accountList);
        Map<String, List<CustomerAreaRespDto>> customerAreasMap = new HashMap<String, List<CustomerAreaRespDto>>();
        List governAreaList = importDataList.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)data.getGovernArea())).map(EmployeeOrgExcelRespDto::getGovernArea).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(governAreaList)) {
            List customerAreaList;
            CustomerAreaListExtReqDto areaListReqDto = new CustomerAreaListExtReqDto();
            areaListReqDto.setNameList(governAreaList);
            RestResponse areaRest = this.employeeRegionQueryApi.queryCustomerAreaByNames(areaListReqDto);
            if (null != areaRest && CollectionUtils.isNotEmpty((Collection)((Collection)areaRest.getData())) && CollectionUtils.isNotEmpty((Collection)(customerAreaList = (List)areaRest.getData()))) {
                customerAreasMap = customerAreaList.stream().collect(Collectors.groupingBy(CustomerAreaRespDto::getName));
            }
        }
        importDataList = this.verifyOrgData(importDataList, roleMap, customerAreasMap, orgInfoMap, orgCustomerMap, userOrgMap);
        List<EmployeeOrgExcelRespDto> successList = importDataList.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorMsg())).collect(Collectors.toList());
        List<EmployeeOrgExcelRespDto> orgExcelDtoList = this.mergeOrgData(successList);
        Map employeeInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(orgExcelDtoList)) {
            List userIdList = orgExcelDtoList.stream().map(EmployeeOrgExcelRespDto::getUserId).distinct().collect(Collectors.toList());
            List orgIdList = orgExcelDtoList.stream().map(EmployeeOrgExcelRespDto::getOrgId).distinct().collect(Collectors.toList());
            employeeInfoMap = this.employeeExpand2Service.getEmployeeMap(userIdList, orgIdList);
        }
        for (EmployeeOrgExcelRespDto data2 : orgExcelDtoList) {
            EmployeeExpandReqDto employeeExtReqDto = new EmployeeExpandReqDto();
            employeeExtReqDto.setOrganizationId(data2.getOrgId());
            employeeExtReqDto.setOrgId(data2.getOrgId());
            employeeExtReqDto.setOrganizationCode(data2.getOrgCode());
            employeeExtReqDto.setOrganizationStatus(YesOrNoEnum.YES.getStatus());
            employeeExtReqDto.setName(data2.getUserName());
            employeeExtReqDto.setPosition(data2.getPosition());
            employeeExtReqDto.setSex(data2.getSex());
            employeeExtReqDto.setStation(data2.getDepartment());
            employeeExtReqDto.setEmployeeNo(data2.getJobNumber());
            employeeExtReqDto.setPhoneNum(data2.getPhoneNumber());
            employeeExtReqDto.setEmployeeRoleDtoList(data2.getRoleList());
            employeeExtReqDto.setUserId(data2.getUserId());
            employeeExtReqDto.setStartTime(new Date());
            employeeExtReqDto.setCustomerInfoList(data2.getCustomerInfoList());
            employeeExtReqDto.setCustomerBlackList(data2.getCustomerBlackList());
            employeeExtReqDto.setRegionInfoList(data2.getAreaList());
            employeeExtReqDto.setStatus(Integer.valueOf(1));
            employeeExtReqDto.setType(Integer.valueOf(0));
            String key = data2.getOrgId() + "_" + data2.getUserId() + "_" + data2.getPhoneNumber();
            try {
                if (!employeeInfoMap.isEmpty() && employeeInfoMap.containsKey(key)) {
                    Long id = (Long)employeeInfoMap.get(key);
                    employeeExtReqDto.setId(id);
                    logger.info("\u4fee\u6539\u7ec4\u7ec7\u4eba\u5458\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)employeeExtReqDto));
                    this.employeeExpand2Service.modifyEmployee(instanceId, employeeExtReqDto);
                    continue;
                }
                logger.info("\u65b0\u589e\u7ec4\u7ec7\u4eba\u5458\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)employeeExtReqDto));
                this.employeeExpand2Service.addEmployee(instanceId, employeeExtReqDto);
            }
            catch (Exception e) {
                logger.info("\u5bfc\u5165\u7ec4\u7ec7\u4eba\u5458\u5931\u8d25:{}", (Throwable)e);
                this.setErrorsOrgMsg(importDataList, data2.getAccount(), data2.getOrgId(), "\u6267\u884c\u5931\u8d25\uff01" + e.getMessage());
            }
        }
        List errorList = importDataList.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(errorList)) {
            response.setErrorNum(errorList.size());
            String excelName = "\u7ec4\u7ec7\u4eba\u5458\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, EmployeeOrgExcelRespDto.class, null, excelName, "xls");
                response.setErrorFileUrl(exportUrl);
            }
            catch (Exception e) {
                logger.error("\u7ec4\u7ec7\u4eba\u5458\u5bfc\u5165\u5931\u8d25\u4fe1\u606f\u6587\u4ef6\u751f\u6210\u5931\u8d25");
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        response.setSuccessNum(response.getTotalNum() - response.getErrorNum());
        return new RestResponse((Object)response);
    }

    public Boolean headerBigB() {
        String bigB = this.request.getHeader("big-b-request-flag");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\uff0c\u5224\u65ad\u662f\u5426\u4e3a\u54c1\u724c\u65b9\uff1a{}", (Object)bigB);
        if (ObjectUtils.isNotEmpty((Object)bigB)) {
            return Boolean.valueOf(bigB);
        }
        return false;
    }

    public List<EmployeeOrgExcelRespDto> verifyOrgData(List<EmployeeOrgExcelRespDto> list, Map<String, List<RoleExpandRespDto>> roleMap, Map<String, List<CustomerAreaRespDto>> areasMap, Map<String, OrganizationDto> orgInfoMap, Map<String, CustomerRespDto> orgCustomerMap, Map<String, List<UserOrgizationRespDto>> userOrgMap) {
        CustomerRespDto customerRespDto;
        List<Object> codes = new ArrayList();
        Boolean ifPPF = this.headerBigB();
        for (EmployeeOrgExcelRespDto vo : list) {
            if (StringUtils.isBlank((CharSequence)vo.getOrganizationName()) && StringUtils.isBlank((CharSequence)vo.getDealerCode())) {
                vo.setErrorMsg("\u7ec4\u7ec7\u540d\u79f0\u6216\u5ba2\u6237/\u7ecf\u9500\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            Long orgId = 0L;
            String orgCode = "";
            if (StringUtils.isNotEmpty((CharSequence)vo.getDealerCode())) {
                if (orgCustomerMap.isEmpty() || !orgCustomerMap.containsKey(vo.getDealerCode())) {
                    vo.setErrorMsg("\u5ba2\u6237/\u7ecf\u9500\u5546\u7f16\u53f7\u6570\u636e\u9519\u8bef");
                    continue;
                }
                customerRespDto = orgCustomerMap.get(vo.getDealerCode());
                orgId = customerRespDto.getOrgInfoId();
                OrganizationDto organizationDto = (OrganizationDto)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryById(orgId, ""));
                if (Objects.isNull(organizationDto)) {
                    vo.setErrorMsg("\u5ba2\u6237/\u7ecf\u9500\u5546\u7f16\u53f7\u6240\u5c5e\u7ec4\u7ec7\u6570\u636e\u9519\u8bef");
                    continue;
                }
                orgCode = organizationDto.getCode();
            }
            if (null == orgId && StringUtils.isNotEmpty((CharSequence)vo.getOrganizationName())) {
                if (orgInfoMap.isEmpty() || !orgInfoMap.containsKey(vo.getOrganizationName())) {
                    vo.setErrorMsg("\u7ec4\u7ec7\u540d\u79f0\u6570\u636e\u9519\u8bef");
                    continue;
                }
                OrganizationDto organizationEo = orgInfoMap.get(vo.getOrganizationName());
                orgId = organizationEo.getId();
                orgCode = organizationEo.getCode();
            }
            vo.setOrgCode(orgCode);
            vo.setOrgId(orgId);
            if (StringUtils.isBlank((CharSequence)vo.getAccount())) {
                vo.setErrorMsg("\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (userOrgMap.isEmpty() || !userOrgMap.containsKey(vo.getAccount())) {
                vo.setErrorMsg("\u767b\u5f55\u8d26\u53f7\u9519\u8bef");
                continue;
            }
            List<UserOrgizationRespDto> userOrgizationVos = userOrgMap.get(vo.getAccount());
            List userOrgList = userOrgizationVos.stream().filter(e -> vo.getOrgId().compareTo(e.getOrgId()) == 0).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(userOrgList) && !ifPPF.booleanValue()) {
                vo.setErrorMsg("\u767b\u5f55\u8d26\u53f7\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                continue;
            }
            if (CollectionUtils.isNotEmpty(userOrgList)) {
                vo.setUserId(((UserOrgizationRespDto)userOrgList.get(0)).getUserId());
            } else {
                vo.setUserId(userOrgizationVos.get(0).getUserId());
            }
            if (StringUtils.isBlank((CharSequence)vo.getUserName())) {
                vo.setErrorMsg("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)vo.getPosition())) {
                vo.setErrorMsg("\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getRoleName()})) {
                if (roleMap.isEmpty() || !roleMap.containsKey(vo.getRoleName())) {
                    vo.setErrorMsg("\u89d2\u8272\u9519\u8bef");
                    continue;
                }
                List<RoleExpandRespDto> roleExpandEos = roleMap.get(vo.getRoleName());
                List orgRoleList = roleExpandEos.stream().filter(e -> Objects.nonNull(e.getBelongOrgId()) && e.getBelongOrgId().compareTo(vo.getOrgId()) == 0 || e.getRoleType() == 1).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(orgRoleList)) {
                    vo.setErrorMsg("\u89d2\u8272\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                    continue;
                }
                EmployeeRoleReqDto employeeRoleReqDto = new EmployeeRoleReqDto();
                employeeRoleReqDto.setRoleId(((RoleExpandRespDto)orgRoleList.get(0)).getId());
                employeeRoleReqDto.setRoleCode(((RoleExpandRespDto)orgRoleList.get(0)).getCode());
                vo.setRole(employeeRoleReqDto);
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getPhoneNumber()) && !CommonUtil.checkPhoneNum(vo.getPhoneNumber())) {
                vo.setErrorMsg("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e;");
                continue;
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getGovernArea()})) {
                List<CustomerAreaRespDto> customerAreaRespDtos = areasMap.get(vo.getGovernArea());
                if (areasMap.isEmpty() || !areasMap.containsKey(vo.getGovernArea())) {
                    vo.setErrorMsg("\u7ba1\u7406\u533a\u57df\u9519\u8bef");
                    continue;
                }
                List orgAreaList = customerAreaRespDtos.stream().filter(e -> e.getOrgInfoId().compareTo(vo.getOrgId()) == 0).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(orgAreaList)) {
                    vo.setErrorMsg("\u7ba1\u7406\u533a\u57df\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                    continue;
                }
                EmployeeRegionReqDto employeeRegionReqDto = new EmployeeRegionReqDto();
                employeeRegionReqDto.setRegionCode(((CustomerAreaRespDto)orgAreaList.get(0)).getCode());
                employeeRegionReqDto.setStartTime(new Date());
                vo.setArea(employeeRegionReqDto);
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getGovernCustomer())) {
                codes.add(vo.getGovernCustomer());
            }
            if (!StringUtils.isNotEmpty((CharSequence)vo.getBlacklist())) continue;
            codes.add(vo.getBlacklist());
        }
        if (CollectionUtils.isNotEmpty(codes)) {
            codes = codes.stream().distinct().collect(Collectors.toList());
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.employeeCustomerQueryApi.queryCustomerListByCodes(codes));
            Map<Object, Object> customersMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
                customersMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (key1, key2) -> key2));
            }
            for (EmployeeOrgExcelRespDto vo : list) {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getErrorMsg()})) continue;
                if (StringUtils.isNotEmpty((CharSequence)vo.getGovernCustomer())) {
                    if (customersMap.isEmpty() || !customersMap.containsKey(vo.getGovernCustomer())) {
                        vo.setErrorMsg("\u7ba1\u7406\u5ba2\u6237\uff08\u5ba2\u6237\u7f16\u53f7\uff09\u9519\u8bef");
                        continue;
                    }
                    customerRespDto = (CustomerRespDto)customersMap.get(vo.getGovernCustomer());
                    if (null == customerRespDto.getOrgInfoId() || customerRespDto.getMerchantId().compareTo(vo.getOrgId()) != 0) {
                        vo.setErrorMsg("\u7ba1\u7406\u5ba2\u6237\uff08\u5ba2\u6237\u7f16\u53f7\uff09\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                        continue;
                    }
                    EmployeeCustomerReqDto employeeCustomerReqDto = new EmployeeCustomerReqDto();
                    employeeCustomerReqDto.setCustomerId(customerRespDto.getId());
                    employeeCustomerReqDto.setStartTime(new Date());
                    vo.setCustomerDto(employeeCustomerReqDto);
                }
                if (!StringUtils.isNotEmpty((CharSequence)vo.getBlacklist())) continue;
                if (customersMap.isEmpty() || !customersMap.containsKey(vo.getBlacklist())) {
                    vo.setErrorMsg("\u7ba1\u7406\u9ed1\u540d\u5355\uff08\u5ba2\u6237\u7f16\u53f7\uff09\u9519\u8bef");
                    continue;
                }
                CustomerRespDto customerBlacklistRespDto = (CustomerRespDto)customersMap.get(vo.getBlacklist());
                if (null == customerBlacklistRespDto.getOrgInfoId() || customerBlacklistRespDto.getMerchantId().compareTo(vo.getOrgId()) != 0) {
                    vo.setErrorMsg("\u7ba1\u7406\u9ed1\u540d\u5355\uff08\u5ba2\u6237\u7f16\u53f7\uff09\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                    continue;
                }
                EmployeeCustomerBlacklistReqDto customerBlacklistReqDto = new EmployeeCustomerBlacklistReqDto();
                customerBlacklistReqDto.setCustomerId(customerBlacklistRespDto.getId());
                customerBlacklistReqDto.setStartTime(new Date());
                vo.setCustomerBlackDto(customerBlacklistReqDto);
            }
        }
        return list;
    }

    private List<EmployeeOrgExcelRespDto> mergeOrgData(List<EmployeeOrgExcelRespDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        Map<String, List<EmployeeOrgExcelRespDto>> employeeGroupMap = list.stream().collect(Collectors.groupingBy(dto -> dto.getOrgId() + "_" + dto.getAccount()));
        ArrayList resultVoList = Lists.newArrayList();
        for (String account : employeeGroupMap.keySet()) {
            List customerBlackList;
            List customerInfoList;
            List areaList;
            List<EmployeeOrgExcelRespDto> employeeExcelVos = employeeGroupMap.get(account);
            EmployeeOrgExcelRespDto vo = new EmployeeOrgExcelRespDto();
            CubeBeanUtils.copyProperties((Object)vo, (Object)employeeExcelVos.get(0), (String[])new String[0]);
            List roleList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getRole())).map(EmployeeOrgExcelRespDto::getRole).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EmployeeRoleReqDto>(Comparator.comparing(EmployeeRoleReqDto::getRoleId))), ArrayList::new));
            if (CollectionUtils.isNotEmpty((Collection)roleList)) {
                vo.setRoleList(roleList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(areaList = (List)employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getArea())).map(EmployeeOrgExcelRespDto::getArea).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EmployeeRegionReqDto>(Comparator.comparing(EmployeeRegionReqDto::getRegionCode))), ArrayList::new))))) {
                vo.setAreaList(areaList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(customerInfoList = (List)employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getCustomerDto())).map(EmployeeOrgExcelRespDto::getCustomerDto).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EmployeeCustomerReqDto>(Comparator.comparing(EmployeeCustomerReqDto::getCustomerId))), ArrayList::new))))) {
                vo.setCustomerInfoList(customerInfoList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(customerBlackList = (List)employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getCustomerBlackDto())).map(EmployeeOrgExcelRespDto::getCustomerBlackDto).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EmployeeCustomerBlacklistReqDto>(Comparator.comparing(EmployeeCustomerBlacklistReqDto::getCustomerId))), ArrayList::new))))) {
                vo.setCustomerBlackList(customerBlackList);
            }
            resultVoList.add(vo);
        }
        return resultVoList;
    }

    public List<EmployeeOrgExcelRespDto> setErrorsOrgMsg(List<EmployeeOrgExcelRespDto> list, String account, Long orgId, String errorMsg) {
        list.forEach(vo -> {
            if (StringUtils.isBlank((CharSequence)vo.getErrorMsg()) && vo.getAccount().equals(account) && vo.getOrgId().equals(orgId)) {
                vo.setErrorMsg(errorMsg);
            }
        });
        return list;
    }

    private boolean checkPhoneNum(String str) {
        String patent = "^(13[0-9]|14[5|7]|15[0|1|2|3|5|6|7|8|9]|18[0|1|2|3|5|6|7|8|9])\\d{8}$";
        return Pattern.matches(patent, str);
    }
}

