/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl.user;

import cn.hutool.core.bean.BeanUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ParentAreCodeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerAreaListExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeRegionQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleExpandRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserOrgizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeRoleQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserOrgExpandQueryApi;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.SellerEmployeeImportDto;
import com.dtyunxi.yundt.module.customer.api.enums.EmpGovernTypeEnum;
import com.dtyunxi.yundt.module.customer.api.user.IEmployeeExpand2Service;
import com.dtyunxi.yundt.module.customer.api.user.ISellerEmployeeExtService;
import com.dtyunxi.yundt.module.customer.api.vo.EmployeeExcelExtVo;
import com.dtyunxi.yundt.module.customer.biz.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SellerEmployeeExtServiceImpl
implements ISellerEmployeeExtService {
    private static final Logger logger = LoggerFactory.getLogger(SellerEmployeeExtServiceImpl.class);
    @Resource
    private IAccessQueryApi accessQueryApi;
    @Resource
    private IEmployeeRegionQueryApi employeeRegionQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;
    @Resource
    private IEmployeeExpand2Service employeeExpand2Service;
    @Resource
    private IUserOrgExpandQueryApi userOrgExpandQueryApi;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;
    @Resource
    private IEmployeeRoleQueryApi employeeRoleQueryApi;

    public RestResponse<List<SellerEmployeeImportDto>> doSellerEmployeeImport(List<SellerEmployeeImportDto> importDataList) {
        boolean isModifyMode = false;
        return this.doSellerEmployeeImportInner(importDataList, isModifyMode);
    }

    @NotNull
    private RestResponse<List<SellerEmployeeImportDto>> doSellerEmployeeImportInner(List<SellerEmployeeImportDto> importDataList, boolean isModifyMode) {
        if (CollectionUtils.isEmpty(importDataList)) {
            logger.warn("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u7ee7\u7eed\u5904\u7406");
            return new RestResponse(importDataList);
        }
        Long orgId1 = importDataList.get(0).getOrgId();
        List employeeExcelExtVos = importDataList.stream().map(r -> (EmployeeExcelExtVo)BeanUtil.copyProperties((Object)r, EmployeeExcelExtVo.class, (String[])new String[0])).collect(Collectors.toList());
        Long instanceId = importDataList.get(0).getOrgId();
        HashSet successfulImportRows = new HashSet();
        List employeeExcelExtVos1 = this.employeeExpand2Service.processImportEmployeeExcelExtVos(employeeExcelExtVos, orgId1, isModifyMode, instanceId, successfulImportRows);
        return new RestResponse(employeeExcelExtVos1.stream().map(r -> (SellerEmployeeImportDto)BeanUtil.copyProperties((Object)r, SellerEmployeeImportDto.class, (String[])new String[0])).collect(Collectors.toList()));
    }

    public RestResponse<List<SellerEmployeeImportDto>> doSellerEmployeeImport(List<SellerEmployeeImportDto> importDataList, Integer module) {
        return this.doSellerEmployeeImportInner(importDataList, Objects.equals(module, 1));
    }

    public Map<String, List<CustomerAreaRespDto>> getCustomerAreaMap(List<String> governAreaList, Long orgId) {
        Map<String, List<CustomerAreaRespDto>> customerAreasMap = new HashMap<String, List<CustomerAreaRespDto>>(governAreaList.size() * 4 / 3 + 2);
        if (CollectionUtils.isEmpty(governAreaList)) {
            return customerAreasMap;
        }
        CustomerAreaListExtReqDto areaListReqDto = new CustomerAreaListExtReqDto();
        areaListReqDto.setNameList(governAreaList);
        areaListReqDto.setOrgInfoId(orgId);
        RestResponse areaRest = this.employeeRegionQueryApi.queryCustomerAreaByNames(areaListReqDto);
        if (null == areaRest || CollectionUtils.isEmpty((Collection)((Collection)areaRest.getData()))) {
            return customerAreasMap;
        }
        List customerAreaList = (List)areaRest.getData();
        List areaCodes = customerAreaList.stream().map(CustomerAreaRespDto::getCode).distinct().collect(Collectors.toList());
        CustomerAreaListReqDto subTreeReqDto = new CustomerAreaListReqDto();
        subTreeReqDto.setCodes(areaCodes);
        subTreeReqDto.setOrgInfoId(orgId);
        try {
            RestResponse subCodesResp = this.customerAreaQueryApi.querySubCodeAll(subTreeReqDto);
            if (subCodesResp != null && CollectionUtils.isNotEmpty((Collection)((Collection)subCodesResp.getData()))) {
                List allSubCodes = (List)subCodesResp.getData();
                HashSet allAreaCodes = new HashSet();
                allAreaCodes.addAll(areaCodes);
                allAreaCodes.addAll(allSubCodes);
                ParentAreCodeReqDto parentReqDto = new ParentAreCodeReqDto();
                parentReqDto.setCodes(new ArrayList(allAreaCodes));
                RestResponse parentCodesResp = this.customerAreaQueryApi.queryAllParentCode(parentReqDto);
                if (parentCodesResp != null && CollectionUtils.isNotEmpty((Collection)((Collection)parentCodesResp.getData()))) {
                    allAreaCodes.addAll((Collection)parentCodesResp.getData());
                    RestResponse completeAreasResp = this.employeeRegionQueryApi.queryCustomerAreaByCodes(new ArrayList(allAreaCodes));
                    if (completeAreasResp != null && CollectionUtils.isNotEmpty((Collection)((Collection)completeAreasResp.getData()))) {
                        customerAreaList = (List)completeAreasResp.getData();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u533a\u57df\u5c42\u7ea7\u5173\u7cfb\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
        }
        customerAreasMap = customerAreaList.stream().collect(Collectors.groupingBy(CustomerAreaRespDto::getName));
        Map<String, List<CustomerAreaRespDto>> areaCodeMap = customerAreaList.stream().collect(Collectors.groupingBy(CustomerAreaRespDto::getCode));
        for (Map.Entry<String, List<CustomerAreaRespDto>> entry : areaCodeMap.entrySet()) {
            String areaName;
            List<CustomerAreaRespDto> areas = entry.getValue();
            if (areas.isEmpty() || customerAreasMap.containsKey(areaName = areas.get(0).getName())) continue;
            customerAreasMap.put(areaName, areas);
        }
        logger.info("\u5df2\u83b7\u53d6\u533a\u57df\u4fe1\u606f\u603b\u6570: {}, \u5305\u542b\u9500\u552e\u533a\u57df\u3001\u5927\u533a\u548c\u533a\u57df", (Object)customerAreaList.size());
        return customerAreasMap;
    }

    private List<SellerEmployeeImportDto> verifyData(List<SellerEmployeeImportDto> importDataList, Map<String, List<UserOrgizationRespDto>> userOrgMap, Map<String, EmployeeExtRespDto> existingEmployeeMap, boolean isModifyMode) {
        for (SellerEmployeeImportDto vo : importDataList) {
            if (StringUtils.isNotBlank((CharSequence)vo.getErrorReason())) continue;
            ArrayList<String> errorList = new ArrayList<String>();
            if (StringUtils.isNotEmpty((CharSequence)vo.getType()) && !"\u65b0\u589e".equals(vo.getType()) && !"\u4fee\u6539".equals(vo.getType())) {
                errorList.add("\u64cd\u4f5c\u7c7b\u578b\u53ea\u80fd\u4e3a'\u65b0\u589e'\u6216'\u4fee\u6539'");
            }
            boolean recordModifyMode = isModifyMode;
            if (StringUtils.isNotEmpty((CharSequence)vo.getType())) {
                recordModifyMode = "\u4fee\u6539".equals(vo.getType());
            }
            if (recordModifyMode && StringUtils.isBlank((CharSequence)vo.getEmployeeCode())) {
                errorList.add("\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (recordModifyMode && StringUtils.isNotBlank((CharSequence)vo.getEmployeeCode()) && (existingEmployeeMap == null || !existingEmployeeMap.containsKey(vo.getEmployeeCode()))) {
                errorList.add("\u5de5\u53f7\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539");
            }
            if (StringUtils.isBlank((CharSequence)vo.getAccount())) {
                errorList.add("\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)vo.getUserName())) {
                errorList.add("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)vo.getPosition())) {
                errorList.add("\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)vo.getEmployeeType())) {
                errorList.add("\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)vo.getPhoneNumber())) {
                errorList.add("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)vo.getGovernType())) {
                errorList.add("\u7ba1\u7406\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)vo.getRoleName())) {
                errorList.add("\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getAccount()) && (userOrgMap.isEmpty() || !userOrgMap.containsKey(vo.getAccount()))) {
                errorList.add("\u767b\u5f55\u8d26\u53f7\u9519\u8bef");
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getEmployeeType()) && !"\u5185\u90e8".equals(vo.getEmployeeType()) && !"\u5916\u90e8".equals(vo.getEmployeeType())) {
                errorList.add("\u4eba\u5458\u7c7b\u578b\u53ea\u80fd\u4e3a'\u5185\u90e8'\u6216'\u5916\u90e8'");
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getPhoneNumber()) && !CommonUtil.checkPhoneNum(vo.getPhoneNumber())) {
                errorList.add("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            if (vo.getStartDate() == null) {
                errorList.add("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getAccount()) && !userOrgMap.isEmpty() && userOrgMap.containsKey(vo.getAccount())) {
                EmployeeExtQueryReqDto expandReqDto;
                List<UserOrgizationRespDto> userOrgizationVos = userOrgMap.get(vo.getAccount());
                List userOrgList = userOrgizationVos.stream().filter(e -> vo.getOrgId() != null && vo.getOrgId().compareTo(e.getOrgId()) == 0).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(userOrgList)) {
                    errorList.add("\u767b\u5f55\u8d26\u53f7\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                } else {
                    vo.setUserId(((UserOrgizationRespDto)userOrgList.get(0)).getUserId());
                }
                if (!recordModifyMode && vo.getOrgId() != null && StringUtils.isNotEmpty((CharSequence)vo.getUserName()) && StringUtils.isNotEmpty((CharSequence)vo.getPhoneNumber())) {
                    expandReqDto = new EmployeeExtQueryReqDto();
                    expandReqDto.setName(vo.getUserName());
                    expandReqDto.setPhoneNum(vo.getPhoneNumber());
                    expandReqDto.setOrganizationId(vo.getOrgId());
                    List<EmployeeExtRespDto> employeeExtRespDtos = this.checkNameAndPhoneNum(expandReqDto);
                    if (CollectionUtils.isNotEmpty(employeeExtRespDtos) && !Objects.isNull(employeeExtRespDtos.get(0).getId())) {
                        errorList.add("\u59d3\u540d\u4e3a:" + expandReqDto.getName() + "\u4e14\u624b\u673a\u53f7\u4e3a:" + expandReqDto.getPhoneNum() + "\u7684\u5458\u5de5\u5df2\u7ecf\u5b58\u5728");
                    }
                }
                if (recordModifyMode && StringUtils.isNotEmpty((CharSequence)vo.getEmployeeCode()) && existingEmployeeMap != null && existingEmployeeMap.containsKey(vo.getEmployeeCode()) && StringUtils.isNotEmpty((CharSequence)vo.getUserName()) && StringUtils.isNotEmpty((CharSequence)vo.getPhoneNumber())) {
                    expandReqDto = new EmployeeExtQueryReqDto();
                    expandReqDto.setName(vo.getUserName());
                    expandReqDto.setPhoneNum(vo.getPhoneNumber());
                    expandReqDto.setOrganizationId(vo.getOrgId());
                    List<EmployeeExtRespDto> existingByNamePhone = this.checkNameAndPhoneNum(expandReqDto);
                    if (CollectionUtils.isNotEmpty(existingByNamePhone)) {
                        EmployeeExtRespDto currentEmployee = existingEmployeeMap.get(vo.getEmployeeCode());
                        boolean otherEmployeeExists = existingByNamePhone.stream().anyMatch(emp -> !emp.getId().equals(currentEmployee.getId()));
                        if (otherEmployeeExists) {
                            errorList.add("\u59d3\u540d\u4e3a:" + vo.getUserName() + "\u4e14\u624b\u673a\u53f7\u4e3a:" + vo.getPhoneNumber() + "\u7684\u5176\u4ed6\u5458\u5de5\u5df2\u7ecf\u5b58\u5728");
                        }
                    }
                }
            }
            if (errorList.isEmpty()) continue;
            vo.setErrorReason(String.join((CharSequence)"\uff1b", errorList));
        }
        return importDataList;
    }

    public Map<String, List<UserOrgizationRespDto>> getAccoutMap(List<String> accountList) {
        if (CollectionUtils.isEmpty(accountList)) {
            return new HashMap<String, List<UserOrgizationRespDto>>();
        }
        Map<String, List<UserOrgizationRespDto>> userOrgMap = new HashMap<String, List<UserOrgizationRespDto>>(accountList.size() * 4 / 3 + 2);
        List userOrgInfoList = (List)RestResponseHelper.extractData((RestResponse)this.userOrgExpandQueryApi.queryUserOrgByUserName(accountList));
        if (CollectionUtils.isEmpty((Collection)userOrgInfoList)) {
            return userOrgMap;
        }
        userOrgMap = userOrgInfoList.stream().collect(Collectors.groupingBy(UserOrgizationRespDto::getUserName));
        return userOrgMap;
    }

    private List<EmployeeExtRespDto> checkNameAndPhoneNum(EmployeeExtQueryReqDto employeeDto) {
        return (List)this.employeeExpandQueryApi.queryEmployeeByPhoneNumOrg(employeeDto).getData();
    }

    private List<SellerEmployeeImportDto> verifyOrgData(List<SellerEmployeeImportDto> list, Map<String, List<RoleExpandRespDto>> roleMap, Map<String, List<CustomerAreaRespDto>> areasMap, Map<String, CustomerRespDto> customerMap, Map<String, List<UserOrgizationRespDto>> userOrgMap) {
        for (SellerEmployeeImportDto dto : list) {
            if (StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())) continue;
            ArrayList<String> errorList = new ArrayList<String>();
            Long orgId = dto.getOrgId();
            if (ObjectUtils.isEmpty((Object)dto.getStartDate())) {
                errorList.add("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (userOrgMap.isEmpty() || !userOrgMap.containsKey(dto.getAccount())) {
                errorList.add("\u767b\u5f55\u8d26\u53f7\u9519\u8bef");
            }
            boolean canContinueUserCheck = false;
            if (!userOrgMap.isEmpty() && userOrgMap.containsKey(dto.getAccount())) {
                List<UserOrgizationRespDto> userOrgizationVos = userOrgMap.get(dto.getAccount());
                List userOrgList = userOrgizationVos.stream().filter(e -> orgId != null && orgId.compareTo(e.getOrgId()) == 0).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(userOrgList)) {
                    errorList.add("\u767b\u5f55\u8d26\u53f7\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                } else {
                    dto.setUserId(((UserOrgizationRespDto)userOrgList.get(0)).getUserId());
                    canContinueUserCheck = true;
                }
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getRoleName()})) {
                if (roleMap.isEmpty() || !roleMap.containsKey(dto.getRoleName())) {
                    errorList.add("\u89d2\u8272\u9519\u8bef");
                } else {
                    List<RoleExpandRespDto> roleExpandEos = roleMap.get(dto.getRoleName());
                    List orgRoleList = roleExpandEos.stream().filter(e -> Objects.nonNull(e.getBelongOrgId()) && orgId != null && e.getBelongOrgId().compareTo(orgId) == 0 || e.getRoleType() == 1).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(orgRoleList)) {
                        errorList.add("\u89d2\u8272\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                    } else {
                        EmployeeRoleReqDto employeeRoleReqDto = new EmployeeRoleReqDto();
                        employeeRoleReqDto.setRoleId(((RoleExpandRespDto)orgRoleList.get(0)).getId());
                        employeeRoleReqDto.setRoleCode(((RoleExpandRespDto)orgRoleList.get(0)).getCode());
                        dto.setRole(employeeRoleReqDto);
                    }
                }
            } else {
                errorList.add("\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a");
            }
            EmpGovernTypeEnum empGovernTypeEnum = EmpGovernTypeEnum.fromName((String)dto.getGovernType());
            if (ObjectUtils.isEmpty((Object)empGovernTypeEnum)) {
                errorList.add("\u7ba1\u7406\u7c7b\u578b\u586b\u5199\u6709\u8bef");
            } else {
                if ("\u5916\u90e8".equals(dto.getEmployeeType()) && !EmpGovernTypeEnum.CUS.getName().equals(empGovernTypeEnum.getName())) {
                    errorList.add("\u5916\u90e8\u4eba\u5458\u53ea\u80fd\u9009\u62e9\u7ba1\u7406\u5ba2\u6237\u7c7b\u578b");
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getGovernCustomer()) && StringUtils.isNotBlank((CharSequence)dto.getBlacklist()) && dto.getGovernCustomer().equals(dto.getBlacklist())) {
                    errorList.add("\u540c\u4e00\u4e2a\u5ba2\u6237\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u7ba1\u7406\u9ed1\u540d\u5355\u548c\u7ba1\u7406\u5ba2\u6237");
                }
                if (canContinueUserCheck) {
                    switch (empGovernTypeEnum) {
                        case AREA: {
                            this.validateAreaManagement(dto, areasMap, errorList);
                            break;
                        }
                        case CUS: {
                            this.validateCustomerManagement(dto, customerMap, errorList);
                            break;
                        }
                        case BLA: {
                            this.validateBlacklistManagement(dto, customerMap, errorList);
                            break;
                        }
                        default: {
                            errorList.add("\u672a\u77e5\u7684\u7ba1\u7406\u7c7b\u578b");
                        }
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getRoleName())) {
                this.processRoles(dto, roleMap, errorList);
            }
            if (errorList.isEmpty()) continue;
            dto.setErrorReason(String.join((CharSequence)"\uff1b", errorList));
        }
        return list;
    }

    private void validateAreaManagement(SellerEmployeeImportDto dto, Map<String, List<CustomerAreaRespDto>> areasMap, List<String> errorList) {
        boolean hasSaleArea = StringUtils.isNotBlank((CharSequence)dto.getSaleArea());
        boolean hasBigArea = StringUtils.isNotBlank((CharSequence)dto.getBigArea());
        boolean hasDistrict = StringUtils.isNotBlank((CharSequence)dto.getDistrict());
        if (!(hasSaleArea || hasBigArea || hasDistrict)) {
            errorList.add("\u9500\u552e\u533a\u57df\u3001\u5927\u533a\u3001\u533a\u57df\u81f3\u5c11\u586b\u5199\u4e00\u9879");
            return;
        }
        if (hasSaleArea && !hasBigArea && !hasDistrict) {
            List<Object> saleAreaList = areasMap.get(dto.getSaleArea());
            if (CollectionUtils.isEmpty(saleAreaList)) {
                errorList.add("\u627e\u4e0d\u5230\u9500\u552e\u533a\u57df");
                return;
            }
            if (CollectionUtils.isEmpty(saleAreaList = saleAreaList.stream().filter(e -> Objects.equals(e.getOrgInfoId(), dto.getOrgId())).collect(Collectors.toList()))) {
                errorList.add("\u627e\u4e0d\u5230\u9500\u552e\u533a\u57df");
                return;
            }
            String saleAreaCode = ((CustomerAreaRespDto)saleAreaList.get(0)).getCode();
            EmployeeRegionReqDto employeeRegionReqDto = new EmployeeRegionReqDto();
            employeeRegionReqDto.setRegionCode(saleAreaCode);
            employeeRegionReqDto.setStartTime(dto.getStartDate());
            employeeRegionReqDto.setEndTime(dto.getEndDate());
            dto.setArea(employeeRegionReqDto);
            logger.info("\u53ea\u63d0\u4f9b\u9500\u552e\u533a\u57df: {}, \u81ea\u52a8\u7ed1\u5b9a\u8be5\u9500\u552e\u533a\u57df\u53ca\u5176\u4e0b\u6240\u6709\u5927\u533a\u548c\u533a\u57df", (Object)dto.getSaleArea());
        } else if (!hasSaleArea && hasBigArea && !hasDistrict) {
            List<Object> bigAreaList = areasMap.get(dto.getBigArea());
            if (CollectionUtils.isEmpty(bigAreaList)) {
                errorList.add("\u627e\u4e0d\u5230\u5927\u533a");
                return;
            }
            if (CollectionUtils.isEmpty(bigAreaList = bigAreaList.stream().filter(e -> Objects.equals(e.getOrgInfoId(), dto.getOrgId())).collect(Collectors.toList()))) {
                errorList.add("\u627e\u4e0d\u5230\u5927\u533a");
                return;
            }
            String bigAreaCode = ((CustomerAreaRespDto)bigAreaList.get(0)).getCode();
            EmployeeRegionReqDto employeeRegionReqDto = new EmployeeRegionReqDto();
            employeeRegionReqDto.setRegionCode(bigAreaCode);
            employeeRegionReqDto.setStartTime(dto.getStartDate());
            employeeRegionReqDto.setEndTime(dto.getEndDate());
            dto.setArea(employeeRegionReqDto);
            String parentCode = ((CustomerAreaRespDto)bigAreaList.get(0)).getParentCode();
            for (Map.Entry<String, List<CustomerAreaRespDto>> entry : areasMap.entrySet()) {
                for (CustomerAreaRespDto area : entry.getValue()) {
                    if (!parentCode.equals(area.getCode())) continue;
                    dto.setSaleArea(area.getName());
                    break;
                }
                if (!StringUtils.isNotEmpty((CharSequence)dto.getSaleArea())) continue;
                break;
            }
            logger.info("\u53ea\u63d0\u4f9b\u5927\u533a: {}, \u81ea\u52a8\u5339\u914d\u9500\u552e\u533a\u57df: {}, \u5e76\u7ed1\u5b9a\u8be5\u5927\u533a\u53ca\u5176\u4e0b\u6240\u6709\u533a\u57df", (Object)dto.getBigArea(), (Object)dto.getSaleArea());
        } else if (!hasSaleArea && !hasBigArea && hasDistrict) {
            List<Object> districtList = areasMap.get(dto.getDistrict());
            if (CollectionUtils.isEmpty(districtList)) {
                errorList.add("\u627e\u4e0d\u5230\u533a\u57df");
                return;
            }
            if (CollectionUtils.isEmpty(districtList = districtList.stream().filter(e -> Objects.equals(e.getOrgInfoId(), dto.getOrgId())).collect(Collectors.toList()))) {
                errorList.add("\u627e\u4e0d\u5230\u533a\u57df");
                return;
            }
            String districtCode = ((CustomerAreaRespDto)districtList.get(0)).getCode();
            EmployeeRegionReqDto employeeRegionReqDto = new EmployeeRegionReqDto();
            employeeRegionReqDto.setRegionCode(districtCode);
            employeeRegionReqDto.setStartTime(dto.getStartDate());
            employeeRegionReqDto.setEndTime(dto.getEndDate());
            dto.setArea(employeeRegionReqDto);
            String parentCode = ((CustomerAreaRespDto)districtList.get(0)).getParentCode();
            for (Map.Entry<String, List<CustomerAreaRespDto>> entry : areasMap.entrySet()) {
                block3: for (CustomerAreaRespDto area : entry.getValue()) {
                    if (!parentCode.equals(area.getCode())) continue;
                    dto.setBigArea(area.getName());
                    String bigAreaParentCode = area.getParentCode();
                    for (Map.Entry<String, List<CustomerAreaRespDto>> entry2 : areasMap.entrySet()) {
                        for (CustomerAreaRespDto area2 : entry2.getValue()) {
                            if (!bigAreaParentCode.equals(area2.getCode())) continue;
                            dto.setSaleArea(area2.getName());
                            break;
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)dto.getSaleArea())) continue;
                        break block3;
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)dto.getBigArea())) continue;
                break;
            }
            logger.info("\u53ea\u63d0\u4f9b\u533a\u57df: {}, \u53ea\u7ed1\u5b9a\u8be5\u533a\u57df", (Object)dto.getDistrict());
        } else if (hasSaleArea && hasBigArea && hasDistrict) {
            this.validateCompleteAreaHierarchy(dto, areasMap, errorList);
        }
        if (!(errorList.contains("\u627e\u4e0d\u5230\u9500\u552e\u533a\u57df") || errorList.contains("\u627e\u4e0d\u5230\u5927\u533a") || errorList.contains("\u627e\u4e0d\u5230\u533a\u57df") || errorList.contains("\u9500\u552e\u533a\u57df\u4e0b\u4e0d\u5b58\u5728\u8be5\u5927\u533a") || errorList.contains("\u5927\u533a\u4e0b\u4e0d\u5b58\u5728\u8be5\u533a\u57df"))) {
            ArrayList<EmployeeRegionReqDto> areaList = new ArrayList<EmployeeRegionReqDto>();
            if (dto.getArea() != null) {
                areaList.add(dto.getArea());
            }
            dto.setAreaList(areaList);
        }
    }

    private void validateCompleteAreaHierarchy(SellerEmployeeImportDto dto, Map<String, List<CustomerAreaRespDto>> areasMap, List<String> errorList) {
        List<Object> saleAreaList = areasMap.get(dto.getSaleArea());
        if (CollectionUtils.isEmpty(saleAreaList)) {
            errorList.add("\u627e\u4e0d\u5230\u9500\u552e\u533a\u57df");
            return;
        }
        if (CollectionUtils.isEmpty(saleAreaList = saleAreaList.stream().filter(e -> Objects.equals(e.getOrgInfoId(), dto.getOrgId())).collect(Collectors.toList()))) {
            errorList.add("\u627e\u4e0d\u5230\u9500\u552e\u533a\u57df");
            return;
        }
        List<Object> bigAreaList = areasMap.get(dto.getBigArea());
        if (CollectionUtils.isEmpty(bigAreaList)) {
            errorList.add("\u627e\u4e0d\u5230\u5927\u533a");
            return;
        }
        if (CollectionUtils.isEmpty(bigAreaList = bigAreaList.stream().filter(e -> Objects.equals(e.getOrgInfoId(), dto.getOrgId())).collect(Collectors.toList()))) {
            errorList.add("\u627e\u4e0d\u5230\u5927\u533a");
            return;
        }
        if (!((CustomerAreaRespDto)bigAreaList.get(0)).getParentCode().equals(((CustomerAreaRespDto)saleAreaList.get(0)).getCode())) {
            errorList.add("\u9500\u552e\u533a\u57df\u4e0b\u4e0d\u5b58\u5728\u8be5\u5927\u533a");
            return;
        }
        List<Object> districtList = areasMap.get(dto.getDistrict());
        if (CollectionUtils.isEmpty(districtList)) {
            errorList.add("\u627e\u4e0d\u5230\u533a\u57df");
            return;
        }
        if (CollectionUtils.isEmpty(districtList = districtList.stream().filter(e -> Objects.equals(e.getOrgInfoId(), dto.getOrgId())).collect(Collectors.toList()))) {
            errorList.add("\u627e\u4e0d\u5230\u533a\u57df");
            return;
        }
        if (!((CustomerAreaRespDto)districtList.get(0)).getParentCode().equals(((CustomerAreaRespDto)bigAreaList.get(0)).getCode())) {
            errorList.add("\u5927\u533a\u4e0b\u4e0d\u5b58\u5728\u8be5\u533a\u57df");
            return;
        }
        EmployeeRegionReqDto employeeRegionReqDto = new EmployeeRegionReqDto();
        employeeRegionReqDto.setRegionCode(((CustomerAreaRespDto)districtList.get(0)).getCode());
        employeeRegionReqDto.setStartTime(dto.getStartDate());
        employeeRegionReqDto.setEndTime(dto.getEndDate());
        dto.setArea(employeeRegionReqDto);
    }

    private void validateCustomerManagement(SellerEmployeeImportDto dto, Map<String, CustomerRespDto> customerMap, List<String> errorList) {
        if (StringUtils.isBlank((CharSequence)dto.getGovernCustomer())) {
            errorList.add("\u7ba1\u7406\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        CustomerRespDto customerRespDto = customerMap.get(dto.getGovernCustomer());
        if (Objects.isNull(customerRespDto)) {
            errorList.add("\u7ba1\u7406\u5ba2\u6237\uff08\u5ba2\u6237\u7f16\u53f7\uff09\u9519\u8bef");
            return;
        }
        EmployeeCustomerReqDto employeeCustomerReqDto = new EmployeeCustomerReqDto();
        employeeCustomerReqDto.setCustomerId(customerRespDto.getId());
        employeeCustomerReqDto.setStartTime(dto.getStartDate());
        dto.setCustomerDto(employeeCustomerReqDto);
        ArrayList<EmployeeCustomerReqDto> customerInfoList = new ArrayList<EmployeeCustomerReqDto>();
        customerInfoList.add(employeeCustomerReqDto);
        dto.setCustomerInfoList(customerInfoList);
    }

    private void validateBlacklistManagement(SellerEmployeeImportDto dto, Map<String, CustomerRespDto> customerMap, List<String> errorList) {
        if ("\u5916\u90e8".equals(dto.getEmployeeType())) {
            errorList.add("\u5916\u90e8\u4eba\u5458\u4e0d\u80fd\u9009\u62e9\u7ba1\u7406\u9ed1\u540d\u5355\u7c7b\u578b");
            return;
        }
        if (StringUtils.isBlank((CharSequence)dto.getBlacklist())) {
            errorList.add("\u7ba1\u7406\u9ed1\u540d\u5355\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        CustomerRespDto customerBlackRespDto = customerMap.get(dto.getBlacklist());
        if (Objects.isNull(customerBlackRespDto)) {
            errorList.add("\u7ba1\u7406\u9ed1\u540d\u5355\uff08\u5ba2\u6237\u7f16\u53f7\uff09\u9519\u8bef");
            return;
        }
        EmployeeCustomerBlacklistReqDto customerBlacklistReqDto = new EmployeeCustomerBlacklistReqDto();
        customerBlacklistReqDto.setCustomerId(customerBlackRespDto.getId());
        customerBlacklistReqDto.setStartTime(dto.getStartDate());
        dto.setCustomerBlackDto(customerBlacklistReqDto);
        ArrayList<EmployeeCustomerBlacklistReqDto> blackList = new ArrayList<EmployeeCustomerBlacklistReqDto>();
        blackList.add(customerBlacklistReqDto);
        dto.setCustomerBlackList(blackList);
    }

    private void processRoles(SellerEmployeeImportDto dto, Map<String, List<RoleExpandRespDto>> roleMap, List<String> errorList) {
        String[] roleNames = dto.getRoleName().split(";");
        ArrayList<EmployeeRoleReqDto> roleList = new ArrayList<EmployeeRoleReqDto>();
        for (String roleName : roleNames) {
            if (!StringUtils.isNotEmpty((CharSequence)(roleName = roleName.trim()))) continue;
            if (roleMap.containsKey(roleName)) {
                List<RoleExpandRespDto> roleExpands = roleMap.get(roleName);
                if (!CollectionUtils.isNotEmpty(roleExpands)) continue;
                EmployeeRoleReqDto roleReqDto = new EmployeeRoleReqDto();
                roleReqDto.setRoleId(roleExpands.get(0).getId());
                roleReqDto.setRoleCode(roleExpands.get(0).getCode());
                roleList.add(roleReqDto);
                continue;
            }
            errorList.add("\u89d2\u8272\uff1a" + roleName + " \u4e0d\u5b58\u5728");
        }
        if (CollectionUtils.isNotEmpty(roleList)) {
            dto.setRoleList(roleList);
        }
    }

    private List<SellerEmployeeImportDto> mergeOrgData(List<SellerEmployeeImportDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        Map<String, List<SellerEmployeeImportDto>> namePhoneMap = list.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getUserName()) && StringUtils.isNotEmpty((CharSequence)vo.getPhoneNumber())).collect(Collectors.groupingBy(vo -> vo.getUserName() + "_" + vo.getPhoneNumber()));
        ArrayList<SellerEmployeeImportDto> mergedList = new ArrayList<SellerEmployeeImportDto>();
        for (Map.Entry<String, List<SellerEmployeeImportDto>> entry : namePhoneMap.entrySet()) {
            List<SellerEmployeeImportDto> duplicates = entry.getValue();
            if (duplicates.size() == 1) {
                mergedList.add(duplicates.get(0));
                continue;
            }
            logger.info("\u5408\u5e76\u76f8\u540c\u59d3\u540d\u548c\u624b\u673a\u53f7\u7684\u8bb0\u5f55: {}, \u8bb0\u5f55\u6570: {}", (Object)entry.getKey(), (Object)duplicates.size());
            SellerEmployeeImportDto mergedVo = new SellerEmployeeImportDto();
            SellerEmployeeImportDto firstVo = duplicates.get(0);
            mergedVo.setUserName(firstVo.getUserName());
            mergedVo.setPhoneNumber(firstVo.getPhoneNumber());
            String employeeCode = duplicates.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getEmployeeCode())).map(SellerEmployeeImportDto::getEmployeeCode).findFirst().orElse(null);
            mergedVo.setEmployeeCode(employeeCode);
            String account = duplicates.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getAccount())).map(SellerEmployeeImportDto::getAccount).findFirst().orElse(null);
            mergedVo.setAccount(account);
            String position = duplicates.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getPosition())).map(SellerEmployeeImportDto::getPosition).findFirst().orElse(null);
            mergedVo.setPosition(position);
            Long userId = duplicates.stream().filter(vo -> vo.getUserId() != null).map(SellerEmployeeImportDto::getUserId).findFirst().orElse(null);
            mergedVo.setUserId(userId);
            Long orgId = duplicates.stream().filter(vo -> vo.getOrgId() != null).map(SellerEmployeeImportDto::getOrgId).findFirst().orElse(null);
            mergedVo.setOrgId(orgId);
            String employeeType = duplicates.stream().filter(vo -> "\u5185\u90e8".equals(vo.getEmployeeType())).map(SellerEmployeeImportDto::getEmployeeType).findFirst().orElse(duplicates.get(0).getEmployeeType());
            mergedVo.setEmployeeType(employeeType);
            String governType = duplicates.stream().filter(vo -> EmpGovernTypeEnum.AREA.getName().equals(vo.getGovernType())).map(SellerEmployeeImportDto::getGovernType).findFirst().orElse(duplicates.stream().filter(vo -> EmpGovernTypeEnum.BLA.getName().equals(vo.getGovernType())).map(SellerEmployeeImportDto::getGovernType).findFirst().orElse(duplicates.stream().filter(vo -> EmpGovernTypeEnum.CUS.getName().equals(vo.getGovernType())).map(SellerEmployeeImportDto::getGovernType).findFirst().orElse(null)));
            mergedVo.setGovernType(governType);
            HashSet<String> roleSet = new HashSet<String>();
            for (SellerEmployeeImportDto vo2 : duplicates) {
                if (!StringUtils.isNotEmpty((CharSequence)vo2.getRoleName())) continue;
                roleSet.add(vo2.getRoleName());
            }
            if (CollectionUtils.isNotEmpty(roleSet)) {
                mergedVo.setRoleName(String.join((CharSequence)";", roleSet));
            }
            Date startDate = duplicates.stream().filter(vo -> vo.getStartDate() != null).map(SellerEmployeeImportDto::getStartDate).max(Date::compareTo).orElse(null);
            mergedVo.setStartDate(startDate);
            Date endDate = duplicates.stream().filter(vo -> vo.getEndDate() != null).map(SellerEmployeeImportDto::getEndDate).max(Date::compareTo).orElse(null);
            mergedVo.setEndDate(endDate);
            String saleArea = duplicates.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getSaleArea())).map(SellerEmployeeImportDto::getSaleArea).findFirst().orElse(null);
            mergedVo.setSaleArea(saleArea);
            String bigArea = duplicates.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getBigArea())).map(SellerEmployeeImportDto::getBigArea).findFirst().orElse(null);
            mergedVo.setBigArea(bigArea);
            String district = duplicates.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getDistrict())).map(SellerEmployeeImportDto::getDistrict).findFirst().orElse(null);
            mergedVo.setDistrict(district);
            String governCustomer = duplicates.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getGovernCustomer())).map(SellerEmployeeImportDto::getGovernCustomer).findFirst().orElse(null);
            mergedVo.setGovernCustomer(governCustomer);
            String blacklist = duplicates.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getBlacklist())).map(SellerEmployeeImportDto::getBlacklist).findFirst().orElse(null);
            mergedVo.setBlacklist(blacklist);
            mergedVo.setArea(firstVo.getArea());
            mergedVo.setCustomerDto(firstVo.getCustomerDto());
            mergedVo.setCustomerBlackDto(firstVo.getCustomerBlackDto());
            mergedVo.setRoleList(firstVo.getRoleList());
            mergedList.add(mergedVo);
        }
        return mergedList;
    }

    public List<SellerEmployeeImportDto> setErrorsMsg(List<SellerEmployeeImportDto> list, String account, String errorMsg) {
        list.forEach(vo -> {
            if (vo.getAccount() != null && vo.getAccount().equals(account)) {
                if (StringUtils.isBlank((CharSequence)vo.getErrorReason())) {
                    vo.setErrorReason(errorMsg);
                } else {
                    vo.setErrorReason(vo.getErrorReason() + "\uff1b" + errorMsg);
                }
            }
        });
        return list;
    }
}

