/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.IMapApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.MapTextRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsCustomerEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreAreaQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.response.BizImportRespDto;
import com.dtyunxi.yundt.module.customer.api.enums.BizChannelEnum;
import com.dtyunxi.yundt.module.customer.api.enums.DefaultSettingEnum;
import com.dtyunxi.yundt.module.customer.biz.constant.StoreConstant;
import com.dtyunxi.yundt.module.customer.biz.service.IStoreService;
import com.dtyunxi.yundt.module.customer.biz.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.module.customer.biz.vo.StoreExportVo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.IStoreApi;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.query.IStoreQueryApi;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class StoreServiceImpl
implements IStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IStoreApi storeApi;
    @Resource
    private IStoreQueryApi storeQueryApi;
    @Resource
    private IStoreAreaQueryApi storeAreaQueryApi;
    @Resource
    private IMapApi mapApi;
    @Resource
    private IContext context;
    AtomicInteger counter = new AtomicInteger(1);
    private final ThreadPoolExecutor importExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 4, 120L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(3, true), r -> new Thread(r, "Thread-import[" + this.counter.addAndGet(1) + "]"), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public RestResponse<Void> saveOrUpdateStore(StoreReqDto reqDto) {
        if (StringUtils.isNotBlank((CharSequence)reqDto.getParentSocialCreditNum())) {
            RestResponse storeRespDtoRestResponse = this.storeQueryApi.queryStoreRespDtoByCreditNum(reqDto.getParentSocialCreditNum());
            StoreRespDto storeRespDto = (StoreRespDto)RestResponseHelper.extractData((RestResponse)storeRespDtoRestResponse);
            Assert.isTrue((!ObjectUtils.isEmpty((Object)storeRespDto) ? 1 : 0) != 0, (String)"0001", (String)"\u5f53\u524d\u4e0a\u7ea7\u95e8\u5e97\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            this.logger.info("\u5f53\u524d\u95e8\u5e97{}\u4e0a\u7ea7\u95e8\u5e97\u8be6\u7ec6\u4fe1\u606f\uff1a{}", (Object)StringUtils.defaultString((String)reqDto.getStoreName(), (String)""), (Object)JSON.toJSONString((Object)storeRespDto));
            if (StoreConstant.IS_CUSTOMER.equals(storeRespDto.getIsCustomer())) {
                Assert.isTrue((boolean)storeRespDto.getIsCustomer().equals(reqDto.getIsCustomer()), (String)"0002", (String)"\u4e0e\u5f53\u524d\u4e0a\u7ea7\u662f\u5426\u5927\u5ba2\u6237\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u53d8\u66f4\u5f53\u524d\u95e8\u5e97\u662f\u5426\u5927\u5ba2\u6237\u7c7b\u578b");
            }
        }
        StoreExportVo storeExportVo = new StoreExportVo();
        CubeBeanUtils.copyProperties((Object)storeExportVo, (Object)reqDto, (String[])new String[0]);
        this.extractedAddress(storeExportVo);
        reqDto.setLog(storeExportVo.getLog());
        reqDto.setLat(storeExportVo.getLat());
        if (ObjectUtils.isNotEmpty((Object)reqDto.getIsReplenish())) {
            reqDto.setIsReplenish(reqDto.getIsReplenish());
        }
        reqDto.setSocialCreditNum(reqDto.getSocialCreditNum().trim().toUpperCase(Locale.ROOT));
        if (!ObjectUtils.isEmpty((Object)reqDto.getId())) {
            RestResponse voidRestResponse = this.storeApi.updateStoreBatch((List)Lists.newArrayList((Object[])new StoreReqDto[]{reqDto}));
            RestResponseHelper.extractData((RestResponse)voidRestResponse);
        } else {
            RestResponse storeRespDtoResp = this.storeQueryApi.queryStoreRespDtoByCreditNum(reqDto.getSocialCreditNum());
            StoreRespDto respDto = (StoreRespDto)RestResponseHelper.extractData((RestResponse)storeRespDtoResp);
            Assert.isTrue((!reqDto.getSocialCreditNum().equals(respDto.getSocialCreditNum()) ? 1 : 0) != 0, (String)"0003", (String)"\u5df2\u5b58\u5728\u76f8\u540c\u4fe1\u7528\u4ee3\u7801\u836f\u5e97\uff01\uff01\uff01");
            RestResponse voidRestResponse = this.storeApi.addStore(reqDto);
            RestResponseHelper.extractData((RestResponse)voidRestResponse);
        }
        StoreReqDto storeReq = new StoreReqDto();
        storeReq.setParentSocialCreditNum(reqDto.getSocialCreditNum());
        storeReq.setIsCustomer(reqDto.getIsCustomer());
        storeReq.setCustomerSystem(reqDto.getCustomerSystem());
        storeReq.setBizChannel(reqDto.getBizChannel());
        storeReq.setUpdatePerson(this.context.userName());
        RestResponseHelper.extractData((RestResponse)this.storeApi.updateStore(storeReq));
        return RestResponse.VOID;
    }

    private void extractedAddress(StoreExportVo reqDto) {
        StringBuffer storeParesAddress = new StringBuffer(StringUtils.defaultString((String)reqDto.getProvince(), (String)""));
        storeParesAddress.append(StringUtils.defaultString((String)reqDto.getCity(), (String)"")).append(StringUtils.defaultString((String)reqDto.getDistrict(), (String)"")).append(StringUtils.defaultString((String)reqDto.getStoreAddr(), (String)""));
        RestResponse mapRespDtoRestResponse = this.mapApi.parserText(storeParesAddress.toString());
        MapTextRespDto mapTextRespDto = (MapTextRespDto)RestResponseHelper.extractData((RestResponse)mapRespDtoRestResponse);
        if (ObjectUtils.isNotEmpty((Object)mapTextRespDto)) {
            this.logger.info("\u3010\u9ad8\u5fb7\u5730\u56fe\u3011\u83b7\u53d6\u95e8\u5e97\u8be6\u7ec6\u5730\u5740\u7ecf\u7eac\u5ea6 response : {}", (Object)JSON.toJSONString((Object)mapTextRespDto));
            if (CollectionUtils.isNotEmpty((Collection)mapTextRespDto.getPois())) {
                MapTextRespDto.Pois pois = (MapTextRespDto.Pois)mapTextRespDto.getPois().stream().findFirst().get();
                List<String> location = Arrays.asList(pois.getLocation().split(","));
                reqDto.setLog((String)location.stream().findFirst().get());
                reqDto.setLat((String)location.stream().skip(location.size() - 1).findFirst().get());
            }
        }
    }

    private void extractedArea(StoreExportVo reqDto, List<StoreAreaRespDto> storeAreaRespDtos) {
        StoreAreaRespDto city;
        StoreAreaRespDto province;
        StoreAreaRespDto storeAreaRespDto = province = !StringUtils.isNotBlank((CharSequence)reqDto.getProvince()) ? null : this.getStoreAreaRespDtos(reqDto.getProvince(), storeAreaRespDtos);
        StoreAreaRespDto storeAreaRespDto2 = !StringUtils.isNotBlank((CharSequence)reqDto.getCity()) ? null : (city = this.getStoreAreaRespDtos(reqDto.getCity(), ObjectUtils.isEmpty((Object)province) ? Lists.newArrayList() : province.getChildren()));
        StoreAreaRespDto district = !StringUtils.isNotBlank((CharSequence)reqDto.getDistrict()) ? null : this.getStoreAreaRespDtos(reqDto.getDistrict(), ObjectUtils.isEmpty((Object)city) ? Lists.newArrayList() : city.getChildren());
        reqDto.setProvinceCode(ObjectUtils.isEmpty((Object)province) ? "" : province.getCode());
        reqDto.setProvince(ObjectUtils.isEmpty((Object)province) ? reqDto.getProvince() : province.getName());
        reqDto.setCityCode(ObjectUtils.isEmpty((Object)city) ? "" : city.getCode());
        reqDto.setCity(ObjectUtils.isEmpty((Object)city) ? reqDto.getCity() : city.getName());
        if (!ObjectUtils.isEmpty((Object)city) && CollectionUtils.isEmpty((Collection)city.getChildren())) {
            reqDto.setDistrictCode("-");
            reqDto.setDistrict("-");
        } else {
            reqDto.setDistrictCode(ObjectUtils.isEmpty((Object)district) ? "" : district.getCode());
            reqDto.setDistrict(ObjectUtils.isEmpty((Object)district) ? reqDto.getDistrict() : district.getName());
        }
    }

    private StoreAreaRespDto getStoreAreaRespDtos(String name, List<StoreAreaRespDto> storeAreaRespDtos) {
        List collect;
        if (CollectionUtils.isNotEmpty(storeAreaRespDtos) && CollectionUtils.isNotEmpty(collect = storeAreaRespDtos.stream().filter(c -> name.indexOf(c.getName()) != -1).collect(Collectors.toList()))) {
            return (StoreAreaRespDto)collect.stream().findFirst().get();
        }
        return null;
    }

    private void getParentStore(List<StoreExportVo> storeExportVos, Map<String, StoreExportVo> parentStoreExportList) {
        if (CollectionUtils.isNotEmpty(storeExportVos)) {
            for (StoreExportVo storeExportVo : storeExportVos) {
                List<StoreExportVo> children = storeExportVo.getChildren();
                StoreExportVo orDefault = parentStoreExportList.getOrDefault(storeExportVo.getSocialCreditNum(), null);
                if (null == orDefault) continue;
                parentStoreExportList.remove(storeExportVo.getSocialCreditNum());
                children.add(orDefault);
                this.getParentStore(storeExportVo.getChildren(), parentStoreExportList);
                storeExportVo.setChildren(children);
            }
        }
    }

    public void returnStore(List<StoreExportVo> parentStoreExportVo, List<StoreExportVo> storeExportList) {
        if (CollectionUtils.isNotEmpty(parentStoreExportVo)) {
            for (StoreExportVo storeExportVo : parentStoreExportVo) {
                storeExportList.addAll(storeExportVo.getChildren());
                this.returnStore(storeExportVo.getChildren(), storeExportList);
            }
        }
    }

    @Override
    public RestResponse<BizImportRespDto> saveOrUpdateStoreByExcel(MultipartFile file) {
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), StoreExportVo.class, (ImportParams)importParams);
            this.logger.info("\u836f\u5e97\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)result.getList()));
            List list = BeanPropertyNullUtil.getAllFieldNullList(result.getList());
            if (!CollectionUtils.isNotEmpty(list)) {
                return new RestResponse((Object)new BizImportRespDto());
            }
            RestResponse storeAreaResp = this.storeAreaQueryApi.queryTree();
            List storeAreaRespDtos = (List)RestResponseHelper.extractData((RestResponse)storeAreaResp);
            ArrayList notLegalList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(list)) {
                ArrayList storeExportList = Lists.newArrayList(list);
                Map<String, StoreExportVo> storeExportMap = storeExportList.stream().collect(Collectors.toMap(StoreExportVo::getSocialCreditNum, val -> val, (v1, v2) -> v1));
                List<StoreExportVo> storeExportVoResult = this.verifyStoreExport(Lists.newArrayList(storeExportMap.values()), storeAreaRespDtos);
                List<StoreExportVo> legalList = storeExportVoResult.stream().filter(storeExportVo -> !StringUtils.isNotBlank((CharSequence)storeExportVo.getReason())).collect(Collectors.toList());
                notLegalList.addAll(storeExportVoResult.stream().filter(storeExportVo -> StringUtils.isNotBlank((CharSequence)storeExportVo.getReason())).collect(Collectors.toList()));
                String userName = this.context.userName();
                this.getStoreRespDtos(legalList, userName);
            }
            this.logger.info("\u3010\u5bfc\u5165\u836f\u5e97\u6570\u636e\u9884\u671f\u7ed3\u679c\u3011 \u603b\u6761\u6570\uff1a{}\uff0c\u5bfc\u5165\u5931\u8d25{}\u6761\uff0c\u5bfc\u5165\u6210\u529f{}\u6761", new Object[]{list.size(), notLegalList.size(), list.size() - notLegalList.size()});
            Integer importFailTotal = notLegalList.size();
            Integer importSuccessTotal = list.size() - notLegalList.size();
            Integer total = list.size();
            String url = "";
            this.logger.info("\u6821\u9a8c\u5f02\u5e38\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)notLegalList));
            if (!ObjectUtils.isEmpty((Object)notLegalList)) {
                String excelName = "cube/\u5bfc\u5165\u836f\u5e97\u6570\u636e\u5931\u8d25\u6587\u4ef6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
                url = EasyPoiExportUtil.getExportUrl((List)notLegalList, StoreExportVo.class, (String)null, (String)excelName, (String)"xls");
            }
            return new RestResponse((Object)new BizImportRespDto(total, importSuccessTotal, importFailTotal, url));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void getStoreRespDtos(List<StoreExportVo> list, String userName) {
        this.logger.info("\u3010{}\u3011\u89e6\u53d1\u5206\u6279\u5904\u7406\u836f\u5e97\u6570\u636e\u5bfc\u5165 count:{},content:{}", new Object[]{userName, list.size(), JSON.toJSONString(list)});
        List<StoreReqDto> storeReqDtoList = list.stream().map(c -> {
            StoreReqDto storeReqDto = new StoreReqDto();
            CubeBeanUtils.copyProperties((Object)storeReqDto, (Object)c, (String[])new String[0]);
            return storeReqDto;
        }).collect(Collectors.toList());
        Map<String, StoreReqDto> storeExportMap = storeReqDtoList.stream().collect(Collectors.toMap(StoreReqDto::getSocialCreditNum, c -> c, (k1, k2) -> k1));
        ArrayList creditNumLists = Lists.newArrayList(storeExportMap.keySet());
        RestResponse listRestResponse = this.storeQueryApi.querySocialCreditNums((List)creditNumLists);
        List storeRespDtoList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        Map<String, StoreRespDto> storeRespDtoMap = storeRespDtoList.stream().collect(Collectors.toMap(k -> k.getSocialCreditNum().toUpperCase(Locale.ROOT), val -> val, (k1, k2) -> k2));
        List creditNumExit = storeRespDtoList.stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
        creditNumLists.removeAll(creditNumExit);
        this.logger.info("\u5206\u6279\u5bfc\u5165\u836f\u5e97\u65b0\u589e\u836f\u5e97\u4fe1\u7528\u4ee3\u7801\uff1a{}", (Object)JSON.toJSONString((Object)creditNumLists));
        if (CollectionUtils.isNotEmpty((Collection)creditNumLists)) {
            List notExitList = creditNumLists.stream().map(c -> {
                StoreReqDto storeReqDto = (StoreReqDto)storeExportMap.get(c);
                storeReqDto.setCreatePerson(userName);
                storeReqDto.setSocialCreditNum(storeReqDto.getSocialCreditNum().toUpperCase(Locale.ROOT));
                storeReqDto.setIsReplenish(DefaultSettingEnum.YES.getCode());
                return storeReqDto;
            }).collect(Collectors.toList());
            this.logger.info("\u95e8\u5e97\u65b0\u589e\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(notExitList));
            if (CollectionUtils.isNotEmpty(notExitList)) {
                this.storeApi.addStoreBatch(notExitList);
            }
        }
        if (CollectionUtils.isNotEmpty(creditNumExit)) {
            List isExitList = creditNumExit.stream().map(c -> {
                StoreReqDto storeReqDto = (StoreReqDto)storeExportMap.get(c);
                storeReqDto.setUpdatePerson(userName);
                String socialCreditNum = storeReqDto.getSocialCreditNum().toUpperCase(Locale.ROOT);
                storeReqDto.setSocialCreditNum(socialCreditNum);
                StoreRespDto orDefault = storeRespDtoMap.getOrDefault(socialCreditNum, null);
                storeReqDto.setStoreId(ObjectUtils.isNotEmpty((Object)orDefault) ? orDefault.getStoreId() : "");
                storeReqDto.setIsReplenish(DefaultSettingEnum.YES.getCode());
                return storeReqDto;
            }).collect(Collectors.toList());
            this.logger.info("\u95e8\u5e97\u66f4\u65b0\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(isExitList));
            if (CollectionUtils.isNotEmpty(isExitList)) {
                this.storeApi.updateStoreBatch(isExitList);
            }
        }
        List<StoreReqDto> collect = storeReqDtoList.stream().filter(c -> StoreConstant.IS_CUSTOMER.equals(c.getIsCustomer())).collect(Collectors.toList());
        collect.forEach(c -> {
            StoreReqDto storeReq = new StoreReqDto();
            storeReq.setParentSocialCreditNum(c.getSocialCreditNum());
            storeReq.setIsCustomer(StoreConstant.IS_CUSTOMER);
            storeReq.setUpdatePerson(userName);
            storeReq.setIsReplenish(DefaultSettingEnum.YES.getCode());
            this.storeApi.updateStore(storeReq);
        });
        storeReqDtoList.forEach(c -> {
            StoreReqDto storeReq = new StoreReqDto();
            storeReq.setParentSocialCreditNum(c.getSocialCreditNum());
            storeReq.setCustomerSystem(c.getCustomerSystem());
            storeReq.setBizChannel(c.getBizChannel());
            storeReq.setUpdatePerson(userName);
            storeReq.setIsReplenish(DefaultSettingEnum.YES.getCode());
            this.storeApi.updateStore(storeReq);
        });
    }

    private List<StoreExportVo> verifyStoreExport(List<StoreExportVo> list, List<StoreAreaRespDto> storeAreaRespDtos) {
        Map<String, StoreExportVo> collect = list.stream().collect(Collectors.toMap(StoreExportVo::getSocialCreditNum, c -> c, (key1, key2) -> key2));
        for (StoreExportVo c2 : list) {
            List<String> bizChannel;
            StoreExportVo orDefault;
            if (StringUtils.isNotBlank((CharSequence)c2.getParentSocialCreditNum()) && null == (orDefault = (StoreExportVo)collect.getOrDefault(c2.getParentSocialCreditNum(), null))) {
                RestResponse storeRespDtoRestResponse = this.storeQueryApi.queryStoreRespDtoByCreditNum(c2.getParentSocialCreditNum());
                StoreRespDto storeRespDto = (StoreRespDto)RestResponseHelper.extractData((RestResponse)storeRespDtoRestResponse);
                this.logger.info("\u5f53\u524d\u7236\u7ea7\u95e8\u5e97\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)storeRespDto));
                if (BeanPropertyNullUtil.isAllFieldNull(storeRespDto)) {
                    c2.setReason("\u4e0d\u5b58\u5728\u5f53\u524d\u4e0a\u7ea7\u95e8\u5e97");
                    continue;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)c2.getProvince()) || StringUtils.isNotBlank((CharSequence)c2.getDistrict()) || StringUtils.isNotBlank((CharSequence)c2.getCity())) {
                this.extractedArea(c2, storeAreaRespDtos);
                if (!(StringUtils.isNotBlank((CharSequence)c2.getProvinceCode()) && StringUtils.isNotBlank((CharSequence)c2.getDistrictCode()) && StringUtils.isNotBlank((CharSequence)c2.getCityCode()))) {
                    c2.setReason("\u7701\u5e02\u533a\u89e3\u6790\u5f02\u5e38");
                    continue;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)c2.getStoreAddr()) && StringUtils.isAllBlank((CharSequence[])new CharSequence[]{c2.getLog()}) && StringUtils.isAllBlank((CharSequence[])new CharSequence[]{c2.getLat()})) {
                this.extractedAddress(c2);
                if (!StringUtils.isNotBlank((CharSequence)c2.getLog()) || !StringUtils.isNotBlank((CharSequence)c2.getLat())) {
                    c2.setReason("\u7ecf\u7eac\u5ea6\u89e3\u6790\u5f02\u5e38");
                    continue;
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)c2.getBizChannel()) || !c2.getIsCustomer().equals(IsCustomerEnum.IS_CUSTOMER.getCode()) || !ObjectUtils.isNotEmpty(bizChannel = Arrays.asList(c2.getBizChannel().split("\\+")))) continue;
            List bizChannelCodes = bizChannel.stream().map(biz -> BizChannelEnum.fromName((String)biz).getCode()).collect(Collectors.toList());
            c2.setBizChannel(StringUtils.join(bizChannelCodes, (String)","));
        }
        return list;
    }
}

