/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.yundt.cube.center.identity.api.IThirdLoginApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdUserInfoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.user.IOauth2Login;
import com.dtyunxi.yundt.module.customer.api.user.IWeixinService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class Oauth2LoginImpl
implements IOauth2Login {
    private static final Logger logger = LoggerFactory.getLogger(Oauth2LoginImpl.class);
    @Resource
    private IThirdLoginApi thirdLoginApi;
    @Resource
    private IContext context;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IWeixinService weixinService;
    @Value(value="${systemCodeUri:}")
    private String systemCodeUri;

    public String getAuthUri(AuthLoginReqDto authLoginReqDto) {
        String uriKey = MD5Util.getMd5ByString((String)authLoginReqDto.getRedirectUri());
        this.cacheService.add(uriKey, (Object)authLoginReqDto.getRedirectUri());
        String redirectUri = this.systemCodeUri + "?uriKey=" + uriKey;
        if (authLoginReqDto.getConfigLevel() == null) {
            authLoginReqDto.setConfigLevel(Integer.valueOf(1));
        }
        authLoginReqDto.setInstanceId(this.context.instanceId());
        authLoginReqDto.setTenantId(this.context.tenantId());
        authLoginReqDto.setLoginSource(Integer.valueOf(2));
        authLoginReqDto.setRedirectUri(redirectUri);
        RestResponse restResponse = this.thirdLoginApi.thirdAuth(authLoginReqDto);
        ThirdUserInfoRespDto thirdUserInfoRespDto = (ThirdUserInfoRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        return thirdUserInfoRespDto == null ? null : thirdUserInfoRespDto.getResultUrl();
    }

    public ThirdLoginRespDto getAuthToken(AuthLoginTokenReqDto authLoginTokenReqDto) {
        if (authLoginTokenReqDto.getConfigLevel() == null) {
            authLoginTokenReqDto.setConfigLevel(Integer.valueOf(1));
        }
        authLoginTokenReqDto.setInstanceId(this.context.instanceId());
        authLoginTokenReqDto.setTenantId(this.context.tenantId());
        RestResponse restResponse = this.thirdLoginApi.tokenAuth(authLoginTokenReqDto);
        ThirdLoginRespDto thirdLoginRespDto = (ThirdLoginRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        return thirdLoginRespDto;
    }

    public TokenRespDto bind(UserBindLoginThirdDto userBindLoginThirdDto) {
        userBindLoginThirdDto.setInstanceId(this.context.instanceId());
        userBindLoginThirdDto.setTenantId(this.context.tenantId());
        RestResponse restResponse = this.thirdLoginApi.bindLogin(userBindLoginThirdDto);
        TokenRespDto tokenRespDto = (TokenRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        return tokenRespDto;
    }
}

