package com.dtyunxi.yundt.module.customer.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.yundt.module.customer.api.IFileService;
import com.dtyunxi.yundt.module.customer.api.dto.request.UploadFileReqDto;
import com.dtyunxi.yundt.module.customer.api.exception.CustomerModuleExceptionCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.xml.bind.DatatypeConverter;
import java.io.ByteArrayInputStream;
import java.util.Date;

/**
 * 文件服务实现
 *
 * @author: xuhuaqiang
 */
@Service("fileService")
public class FileServiceImpl implements IFileService {

    private static Logger logger = LoggerFactory.getLogger(FileServiceImpl.class);

    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private OssRegistryVo ossRegistryVo;

    @Override
    public String uploadFile(UploadFileReqDto reqDto) {
        long startTime1 = new Date().getTime();
//        byte[] bytes = Base64.decodeBase64(reqDto.getFileData());
        byte [] bytes = DatatypeConverter.parseBase64Binary(reqDto.getFileData());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        //上传到oss
        logger.info("文件：{}开始上传到oss服务器...", ossRegistryVo.getEndpoint() + "/" + reqDto.getFileName());
        try {
            objectStorageService.put(ossRegistryVo.getBucketName(), reqDto.getFileName(), inputStream);
        } catch (Exception e) {
            logger.error("文件上传oss出现异常：", e);
            throw new BizException(CustomerModuleExceptionCode.CUSTOMER_UPLOAD_OSS_ERROR.getCode(),
                    CustomerModuleExceptionCode.CUSTOMER_UPLOAD_OSS_ERROR.getMsg());
        } finally {
            try {
                long startTime2 = new Date().getTime();
                logger.info("文件进行整理完毕,花费[{}]豪秒", (startTime2 - startTime1));
                inputStream.close();
            } catch (Exception e) {
                logger.error("关闭流出现异常");
            }
        }
        logger.info("文件上传到oss服务器完毕,下载链接：{},上传文件入参：{}", ossRegistryVo.getEndpoint() + "/" + reqDto.getFileName(), JSON.toJSONString(reqDto));
        //拼接下载链接
        String downloadUrl = ossRegistryVo.getEndpoint() + "/" + reqDto.getFileName();
        return downloadUrl;
    }
}
