/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.mq.producer;

import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerImportSaveReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.enmus.ImportTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class CustomerImportProducer {
    private static Logger logger = LoggerFactory.getLogger(CustomerImportProducer.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private Environment environment;

    public void sendCustomerImportMq(CustomerImportSaveReqDto customerImportSaveReqDto) {
        logger.info("Mq\u53d1\u9001\u8ba1\u7b97\u6279\u91cf\u5bfc\u5165\u5ba2\u6237\u4fe1\u606f\u4e8b\u4ef6:{},\u7c7b\u578b[{}]", (Object)customerImportSaveReqDto.getId(), (Object)ImportTypeEnum.toName((Integer)customerImportSaveReqDto.getImportType()));
        if (ImportTypeEnum.toName((Integer)customerImportSaveReqDto.getImportType()) == null) {
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS, new Object[]{customerImportSaveReqDto.getImportType()});
        }
        if (customerImportSaveReqDto.getId() == null) {
            logger.info("Mq\u53d1\u9001\u8ba1\u7b97\u6279\u91cf\u5bfc\u5165\u5ba2\u6237\u4fe1\u606f\u4e8b\u4ef6\u5931\u8d25\u539f\u56e0:id[{}]\u4e3a\u7a7a", (Object)customerImportSaveReqDto.getId());
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.SYS_OBJ_NOT_FOUND, new Object[]{"\u5bfc\u5165\u4efb\u52a1\u4e0d\u5b58\u5728"});
        }
        if (ImportTypeEnum.fromCode((Integer)customerImportSaveReqDto.getImportType()) == ImportTypeEnum.CUSTOMER) {
            this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${icomb.common.topic.customer.import:CUSTOMER_INFO_IMPORT_TOPIC}"), "CUSTOMER_INFO_IMPORT_TAG", (Object)customerImportSaveReqDto);
        } else if (ImportTypeEnum.fromCode((Integer)customerImportSaveReqDto.getImportType()) == ImportTypeEnum.SUPPLIER) {
            this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${icomb.common.topic.supplier.import:SUPPLIER_INFO_IMPORT_TOPIC}"), "SUPPLIER_INFO_IMPORT_TAG", (Object)customerImportSaveReqDto);
        }
    }
}

