/*
 * @(#) LoginServiceImpl.java 1.1.0 2019-06-20
 * Copyright (c)  2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.module.customer.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserAccessRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserAccessVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserVo;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.customer.api.dto.response.LoginDto;
import com.dtyunxi.yundt.module.customer.biz.service.ILoginService;
import com.dtyunxi.yundt.module.customer.biz.service.IRoleService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author 大颠
 * @since 1.0.0
 */
@Service
public class LoginServiceImpl implements ILoginService {

    private static final Logger logger = LoggerFactory.getLogger(LoginServiceImpl.class);

    @Resource
    IRoleService roleService;
    @Resource
    IUserQueryApi userQueryApi;

    @Override
    public RestResponse getAccessInfo() {

        Long userId = ServiceContext.getContext().getRequestUserId();
        Long instanceId = ServiceContext.getContext().getRequestInstanceId();

//        userId = 1255653569441794052L;
//        instanceId = 1254039287584232622L;

        logger.info("================获取资源时的应用实例ID：" + instanceId);

        // 获取权限
        UserAccessVo userAccessVo = roleService.queryUserAccess(instanceId, userId).getData();

        LoginDto loginDto = new LoginDto();
        loginDto.setUserAccessVo(userAccessVo);

        // 获取角色
        String[] exm = {"role"};
        RestResponse<UserVo> userRoleResp = userQueryApi.queryByIdAndResource(userId, exm, "{}");

        if (!userRoleResp.getResultCode().equals("0")) {

            throw new BusinessRuntimeException(userRoleResp.getResultMsg());
        }

        UserVo userVo = userRoleResp.getData();
        if (userVo != null && CollectionUtils.isNotEmpty(userVo.getRoleSet())) {

            for (RoleDto roleDto : userVo.getRoleSet()) {
                if ("tenant".equals(roleDto.getCode())) {

                    loginDto.setMenuType("tenant");
                    break;
                } else if ("system".equals(roleDto.getCode())) {

                    loginDto.setMenuType("system");
                    break;
                }

            }
        }

        RestResponse result = new RestResponse<>();
        result.setData(loginDto);

        return result;
    }

    @Override
    public UserAccessRespDto queryUserAccessResources() {
        Long userId = ServiceContext.getContext().getRequestUserId();
        // 获取权限
        UserAccessRespDto data = roleService.queryUserAccessResources(userId).getData();

        return data;
    }

}
