/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.rest;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.IAreaGroupApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.AreaGroupReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupDetailRespDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupRespDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupTreeRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerService;
import com.dtyunxi.yundt.module.customer.api.dto.request.RegionReqDto;
import com.dtyunxi.yundt.module.customer.api.exception.CustomerModuleExceptionCode;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"\u5ba2\u5546\u7ec4\u4ef6\uff1a\u533a\u57df\u5206\u7ec4\u4fe1\u606f\u670d\u52a1"})
public class AreaGroupRest {
    @Resource
    private IAreaGroupApi areaGroupApi;
    @Resource
    private IAreaGroupQueryApi areaGroupQueryApi;
    @Resource
    private ICustomerService customerService;
    @Resource
    private IContext context;

    @PostMapping(value={""}, produces={"application/json"})
    @ApiOperation(value="\u65b0\u589e\u533a\u57df\u5206\u7ec4", notes="\u65b0\u589e\u533a\u57df\u5206\u7ec4")
    RestResponse<Long> saveAreaGroup(@Validated @RequestBody AreaGroupReqDto areaGroupReqDto) {
        areaGroupReqDto.setCode(UUID.randomUUID().toString().replaceAll("-", ""));
        areaGroupReqDto.setInstanceId(this.context.instanceId());
        areaGroupReqDto.setTenantId(this.context.tenantId());
        this.checkAreaGroupParam(null, areaGroupReqDto);
        Long data = (Long)this.areaGroupApi.saveAreaGroup(areaGroupReqDto).getData();
        return new RestResponse((Object)data);
    }

    @DeleteMapping(value={"/{code}"}, produces={"application/json"})
    @ApiOperation(value="\u5220\u9664\u533a\u57df\u5206\u7ec4", notes="\u6839\u636e\u533a\u57df\u5206\u7ec4ID\u5220\u9664\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u533a\u57df\u5206\u7ec4CODE", dataType="String", paramType="path", required=true)})
    RestResponse<Void> removeByCode(@PathVariable(value="code") String code) {
        List respDtoList = (List)this.areaGroupQueryApi.queryByParentCode(code).getData();
        if (CollectionUtils.isNotEmpty((Collection)respDtoList)) {
            throw new BizException(CustomerModuleExceptionCode.REGION_EXISTS_CHILD.getCode(), CustomerModuleExceptionCode.REGION_EXISTS_CHILD.getMsg());
        }
        Boolean isExist = this.customerService.isExistByRegionCode(code);
        if (isExist.booleanValue()) {
            throw new BizException(CustomerModuleExceptionCode.REGION_EXISTS_CUSTOMER.getCode(), CustomerModuleExceptionCode.REGION_EXISTS_CUSTOMER.getMsg());
        }
        AreaGroupDetailRespDto respDto = (AreaGroupDetailRespDto)this.areaGroupQueryApi.queryByCode(code).getData();
        this.areaGroupApi.removeById(respDto.getId());
        return RestResponse.VOID;
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"})
    @ApiOperation(value="\u4fee\u6539\u533a\u57df\u5206\u7ec4", notes="\u4fee\u6539\u533a\u57df\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u533a\u57df\u5206\u7ec4ID", dataType="Long", paramType="path", required=true)})
    RestResponse<Void> modifyAreaGroup(@PathVariable(value="id") Long id, @Validated @RequestBody AreaGroupReqDto areaGroupReqDto) {
        areaGroupReqDto.setInstanceId(this.context.instanceId());
        areaGroupReqDto.setTenantId(this.context.tenantId());
        this.checkAreaGroupParam(id, areaGroupReqDto);
        this.areaGroupApi.modifyAreaGroup(id, areaGroupReqDto);
        return RestResponse.VOID;
    }

    @GetMapping(value={"/page"}, produces={"application/json"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u533a\u57df\u5206\u7ec4", notes="\u5206\u9875\u67e5\u8be2\u533a\u57df\u5206\u7ec4")
    RestResponse<PageInfo<AreaGroupRespDto>> queryByPage(@RequestParam(value="filter") String filter, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        PageInfo pageInfo = (PageInfo)this.areaGroupQueryApi.queryByPage(filter, pageNum, pageSize).getData();
        return new RestResponse((Object)pageInfo);
    }

    @GetMapping(value={"/code/{code}"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u533a\u57df\u5206\u7ec4\u7f16\u7801\u67e5\u8be2\u533a\u57df\u5206\u7ec4", notes="\u6839\u636e\u533a\u57df\u5206\u7ec4\u7f16\u7801\u67e5\u8be2\u533a\u57df\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u533a\u57df\u5206\u7ec4\u7f16\u7801", dataType="String", paramType="path", required=true)})
    RestResponse<AreaGroupDetailRespDto> queryByCode(@PathVariable(value="code") String code) {
        AreaGroupDetailRespDto respDto = (AreaGroupDetailRespDto)this.areaGroupQueryApi.queryByCode(code).getData();
        return new RestResponse((Object)respDto);
    }

    @GetMapping(value={"/parent-code/{parentCode}"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u533a\u57df\u5206\u7ec4\u7236\u7f16\u7801\u67e5\u8be2\u533a\u57df\u5206\u7ec4", notes="\u6839\u636e\u533a\u57df\u5206\u7ec4\u7236\u7f16\u7801\u67e5\u8be2\u533a\u57df\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="parentCode", value="\u533a\u57df\u5206\u7ec4\u7236\u7f16\u7801", dataType="String", paramType="path", required=true)})
    RestResponse<List<AreaGroupRespDto>> queryByParentCode(@PathVariable(value="parentCode") String parentCode) {
        List respDtoList = (List)this.areaGroupQueryApi.queryByParentCode(parentCode).getData();
        return new RestResponse((Object)respDtoList);
    }

    @GetMapping(value={"/tree"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u533a\u57df\u5206\u7ec4\u6811", notes="\u67e5\u8be2\u533a\u57df\u5206\u7ec4\u6811")
    RestResponse<List<AreaGroupTreeRespDto>> queryForTree() {
        List respDtoList = (List)this.areaGroupQueryApi.queryForTree().getData();
        if (CollectionUtils.isNotEmpty((Collection)respDtoList)) {
            Iterator it = respDtoList.iterator();
            while (it.hasNext()) {
                AreaGroupTreeRespDto respDto = (AreaGroupTreeRespDto)it.next();
                if (!"0".equals(respDto.getCode())) continue;
                it.remove();
            }
        }
        return new RestResponse((Object)respDtoList);
    }

    @GetMapping(value={"/list/level/{level}"}, produces={"application/json"})
    @ApiOperation(value="\u6309\u5c42\u7ea7\u67e5\u8be2\u533a\u57df\u5206\u7ec4", notes="\u6309\u5c42\u7ea7\u67e5\u8be2\u533a\u57df\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="level", value="\u67e5\u8be2\u5c42\u7ea7", dataType="Long", paramType="path", required=true)})
    RestResponse<List<AreaGroupRespDto>> queryByLevel(@PathVariable(value="level") Integer level) {
        List respDtoList = (List)this.areaGroupQueryApi.queryByLevel(level).getData();
        return new RestResponse((Object)respDtoList);
    }

    private void checkAreaGroupParam(Long id, AreaGroupReqDto areaGroupReqDto) {
        RegionReqDto regionReqDto = new RegionReqDto();
        regionReqDto.setTenantId(areaGroupReqDto.getTenantId());
        regionReqDto.setName(areaGroupReqDto.getName());
        PageInfo pageInfo = (PageInfo)this.areaGroupQueryApi.queryByPage(JSON.toJSONString((Object)regionReqDto), Integer.valueOf(1), Integer.valueOf(10)).getData();
        if (Objects.nonNull(pageInfo)) {
            if (id == null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                throw new BizException(CustomerModuleExceptionCode.REGION_NAME_EXISTS.getCode(), CustomerModuleExceptionCode.REGION_NAME_EXISTS.getMsg());
            }
            if (id != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList()) && !((AreaGroupRespDto)pageInfo.getList().get(0)).getId().equals(id)) {
                throw new BizException(CustomerModuleExceptionCode.REGION_NAME_EXISTS.getCode(), CustomerModuleExceptionCode.REGION_NAME_EXISTS.getMsg());
            }
        }
    }
}

