/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.rest.user;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.response.EmployeePagerRespDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.query.IPostQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerSalesmanQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.ICustomerOrgInfoApi;
import com.dtyunxi.yundt.cube.center.user.api.ICustomerUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.response.UserInfoRespDto;
import com.dtyunxi.yundt.module.customer.api.user.IUserService;
import com.dtyunxi.yundt.module.customer.api.user.dto.response.OrganizationPackageDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u7ec4\u4ef6\uff1a\u7528\u6237\u76f8\u5173\u670d\u52a1"})
@RestController(value="userRestV1")
@RequestMapping(value={"/v1/user"})
public class UserRest {
    @Autowired
    private IUserQueryApi iUserQueryApi;
    @Resource
    private ICustomerOrgInfoApi customerOrgInfoApi;
    @Resource
    private IContext context;
    @Resource
    private ICustomerUserApi customerUserApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Autowired
    private IUserService userService;
    @Resource
    private IPostQueryApi postQueryApi;
    @Resource
    private IEmployeeQueryApi employeeQueryApi;
    @Resource
    private ICustomerSalesmanQueryApi customerSalesmanQueryApi;
    @Value(value="${icommerceb.post.postCode}")
    private String sysPostCode;

    @GetMapping(value={"/page"}, produces={"application/json"})
    @ApiOperation(value="\u83b7\u53d6\u4e1a\u52a1\u5458\u5206\u9875", notes="\u83b7\u53d6\u4e1a\u52a1\u5458\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", value="\u8d77\u59cb\u9875", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="pageSize", value="\u6bcf\u4e00\u9875\u7684\u8bb0\u5f55\u6570", dataType="int", paramType="query", required=true)})
    RestResponse<PageInfo<UserDto>> pageUser(@RequestParam(value="account", required=false) String account, @RequestParam(value="userName", required=false) String userName, @RequestParam(value="phone", required=false) String phone, @RequestParam(value="email", required=false) String email, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        Long tenantId = this.context.tenantId();
        return new RestResponse(this.iUserQueryApi.queryUser(tenantId, account, userName, phone, email, pageNum, pageSize).getData());
    }

    @GetMapping(value={"/list"}, produces={"application/json"})
    @ApiOperation(value="\u83b7\u53d6\u4e1a\u52a1\u5458\u5168\u90e8\u5217\u8868", notes="\u83b7\u53d6\u4e1a\u52a1\u5458\u5168\u90e8\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="postCode", value="\u5c97\u4f4d\u7f16\u7801", dataType="String", paramType="query")})
    RestResponse<List<UserDto>> queryUser(@RequestParam(value="postCode", required=false) String postCode) {
        if (StringUtils.isEmpty((CharSequence)postCode)) {
            postCode = this.sysPostCode;
        }
        RestResponse listRestResponse = this.postQueryApi.employeeList(postCode);
        List employDtoList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        ArrayList userIdList = Lists.newArrayList();
        for (EmployeePagerRespDto employeePagerRespDto : employDtoList) {
            RestResponse employeeRestResp = this.employeeQueryApi.queryById(employeePagerRespDto.getId());
            EmployeeRespDto employeeRespDto = (EmployeeRespDto)RestResponseHelper.extractData((RestResponse)employeeRestResp);
            if (!Objects.nonNull(employeeRespDto.getUserId())) continue;
            userIdList.add(employeeRespDto.getUserId());
        }
        List list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)userIdList)) {
            RestResponse userRestResp = this.iUserQueryApi.queryByIdList(StringUtils.join((Iterable)userIdList, (String)","), "{}");
            list = (List)RestResponseHelper.extractData((RestResponse)userRestResp);
        }
        return new RestResponse((Object)list);
    }

    @GetMapping(value={"/salesman/list"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u4e1a\u52a1\u5458\u5217\u8868", notes="\u67e5\u8be2\u4e1a\u52a1\u5458\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="useType", value="\u4f7f\u7528\u7c7b\u578b\uff0c1-\u5ba2\u6237\u5217\u8868\u76f8\u5173(\u9ed8\u8ba4\u503c)\uff0c2-\u4e1a\u52a1\u5458\u5217\u8868", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="type", value="\u5ba2\u6237\u7c7b\u578b\uff082\uff1a\u7ecf\u9500\u5546\uff0c3\uff1a\u96f6\u552e\u5546\uff09", dataType="Long", paramType="query", required=true), @ApiImplicitParam(name="channel", value="\u6e20\u9053\u7c7b\u578b\uff081\uff1a\u54c1\u724c\u65b9\u8fd0\u8425\u7aef\uff0c2\uff1a\u5927B\u5356\u5bb6\u7aef\uff09", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="superiorOrgId", value="\u4e0a\u6e38\u7ec4\u7ec7ID", dataType="Long", paramType="query")})
    RestResponse<List<UserRespDto>> querySalesmanList(@RequestParam(value="type") Integer type, @RequestParam(name="useType", required=true, defaultValue="1") Integer useType, @RequestParam(value="channel") Integer channel, @RequestParam(name="superiorOrgId", required=false) Long superiorOrgId) {
        Assert.isTrue((null != type ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((null != channel ? 1 : 0) != 0, (String)"\u6e20\u9053\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CustomerTypeEnum.BRAND.getCode().equals(channel) && CustomerTypeEnum.RETAILER.getCode().equals(type)) {
            Assert.isTrue((null != superiorOrgId ? 1 : 0) != 0, (String)"\u4e0a\u6e38\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (Objects.isNull(superiorOrgId)) {
            superiorOrgId = this.userService.getCurrentUserOrgId(this.context.userId());
        }
        if (Objects.equals(1, useType)) {
            CustomerSalesmanReqDto customerSalesmanReqDto = new CustomerSalesmanReqDto();
            customerSalesmanReqDto.setOrgInfoId(superiorOrgId);
            PageInfo salesmanRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerSalesmanQueryApi.queryByPage(customerSalesmanReqDto, Integer.valueOf(1), Integer.valueOf(1000)));
            if (Objects.nonNull(salesmanRespDtoPageInfo) && CollUtil.isNotEmpty((Collection)salesmanRespDtoPageInfo.getList())) {
                List userRespList = salesmanRespDtoPageInfo.getList().stream().map(item -> {
                    UserRespDto userRespDto = new UserRespDto();
                    userRespDto.setAccount(item.getName());
                    userRespDto.setUserName(item.getName());
                    userRespDto.setId(item.getUserId());
                    userRespDto.setCreateTime(item.getCreateTime());
                    userRespDto.setPhone(item.getMobileNumber());
                    userRespDto.setEmail(item.getEmail());
                    return userRespDto;
                }).collect(Collectors.toList());
                return new RestResponse(userRespList);
            }
        }
        UserOrgRelationQueryReqDto relationQueryReqDto = new UserOrgRelationQueryReqDto();
        relationQueryReqDto.setOrgId(superiorOrgId);
        RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(relationQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        List list = Lists.newArrayList();
        if (Objects.nonNull(pageInfo) && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            list = pageInfo.getList();
        }
        return new RestResponse((Object)list);
    }

    @GetMapping(value={"/all/subordinate"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u672c\u8eab\u53ca\u4e0b\u7ea7\u7ec4\u7ec7\u5217\u8868")
    RestResponse<List<OrganizationDto>> queryAllSubordinateOrgIds() {
        ArrayList res;
        List orgIds = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryAllSubordinateOrgIds());
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            OrganizationDto organizationDto = new OrganizationDto();
            organizationDto.setId(Long.valueOf(0L));
            organizationDto.setName("\u9ed8\u8ba4\u7ec4\u7ec7");
            res = Lists.newArrayList((Object[])new OrganizationDto[]{organizationDto});
        } else {
            res = orgIds.stream().map(id -> (OrganizationDto)this.organizationQueryApi.queryById(id, "{}").getData()).collect(Collectors.toList());
        }
        return new RestResponse(res);
    }

    @GetMapping(value={"/all/self"})
    @ApiOperation(value="\u67e5\u8be2\u67e5\u8be2\u7528\u6237\u672c\u8eab\u7ec4\u7ec7\u5217\u8868")
    RestResponse<List<OrganizationDto>> queryUserOrgList() {
        List orgs = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryUserOrgList());
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            OrganizationDto organizationDto = new OrganizationDto();
            organizationDto.setId(Long.valueOf(0L));
            organizationDto.setName("\u9ed8\u8ba4\u7ec4\u7ec7");
            orgs = Lists.newArrayList((Object[])new OrganizationDto[]{organizationDto});
        }
        return new RestResponse((Object)orgs);
    }

    @GetMapping(value={"/all/superior"})
    @ApiOperation(value="\u67e5\u8be2\u67e5\u8be2\u7528\u6237\u672c\u8eab\u53ca\u4e0a\u7ea7\u7ec4\u7ec7\u5217\u8868")
    RestResponse<List<OrganizationDto>> queryAllSuperiorOrgIdList() {
        List orgIds = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryAllSuperiorOrgIdList());
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            OrganizationDto organizationDto = new OrganizationDto();
            organizationDto.setId(Long.valueOf(0L));
            organizationDto.setName("\u9ed8\u8ba4\u7ec4\u7ec7");
            ArrayList arrayList = Lists.newArrayList((Object[])new OrganizationDto[]{organizationDto});
        }
        List res = orgIds.stream().map(id -> (OrganizationDto)this.organizationQueryApi.queryById(id, "{}").getData()).collect(Collectors.toList());
        return new RestResponse(res);
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u7684\u4e2a\u4eba\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", dataType="Long", paramType="query", value="\u7528\u6237id\uff0c\u975e\u5fc5\u586b"), @ApiImplicitParam(name="srcType", dataType="Int", paramType="query", value="\u6765\u6e90\u7c7b\u578b\uff081:\u7ecf\u9500\u5546\u5c0f\u7a0b\u5e8f\u7aef\uff0c2:PC\u7ba1\u7406\u7aef\uff0c3:\u4e1a\u52a1\u5458\u5c0f\u7a0b\u5e8f\u7aef\uff09")})
    @GetMapping(value={"/user-info"})
    public RestResponse<UserInfoRespDto> queryUserInfo(@RequestParam(value="userId", required=false) Long userId, @RequestParam(value="srcType", required=false) Integer srcType) {
        return new RestResponse((Object)this.userService.queryUserInfo(userId, srcType));
    }

    @GetMapping(value={"/org/show"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u4e8e\u65b0\u589e\u548c\u56de\u663e\u7684\u7528\u6237\u7ec4\u7ec7id\u96c6\u5408")
    RestResponse<OrganizationPackageDto> showOrgs(@RequestParam(value="organizationId", required=false) Long orgId) {
        return new RestResponse((Object)this.userService.showOrgIds(orgId));
    }
}

