/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.rest;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.ICustomerUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BillInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ContactsInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.query.ICustomerUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.request.CustomerDetailReqDto;
import com.dtyunxi.yundt.module.customer.api.enums.DefaultSettingEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba2\u5546\u7ec4\u4ef6\uff1a\u5ba2\u6237\u7ba1\u7406\u5bf9\u5e94\u5730\u5740\u3001\u53d1\u7968\u4fe1\u606f\u3001\u8054\u7cfb\u4eba\u4fe1\u606f\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/customer-user"})
public class CustomerUserRest {
    @Resource
    private ICustomerUserApi customerUserApi;
    @Resource
    private ICustomerUserQueryApi customerUserQueryApi;
    @Resource
    private IContext context;

    @PostMapping(value={"/address"})
    @ApiOperation(value="\u521b\u5efa\u5ba2\u6237\u5730\u5740", notes="\u521b\u5efa\u5ba2\u6237\u5730\u5740")
    RestResponse<Long> addCustomerAddress(@RequestBody AddressDto addressDto) {
        addressDto.setInstanceId(this.context.instanceId());
        addressDto.setTenantId(this.context.tenantId());
        String addressType = addressDto.getAddressType();
        if (StrUtil.isNotBlank((CharSequence)addressType)) {
            String[] addressTypes;
            for (String type : addressTypes = addressType.split(",")) {
                addressDto.setAddressType(type);
                this.customerUserApi.addCustomerAddress(addressDto).getData();
            }
        }
        return new RestResponse((Object)0L);
    }

    @PutMapping(value={"/address"})
    @ApiOperation(value="\u66f4\u65b0\u5ba2\u6237\u5730\u5740", notes="\u66f4\u65b0\u5ba2\u6237\u5730\u5740")
    RestResponse<Void> updateCustomerAddress(@RequestBody AddressDto addressDto) {
        addressDto.setInstanceId(this.context.instanceId());
        addressDto.setTenantId(this.context.tenantId());
        this.customerUserApi.updateCustomerAddress(addressDto);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/bill-info"})
    @ApiOperation(value="\u521b\u5efa\u53d1\u7968\u4fe1\u606f", notes="\u521b\u5efa\u53d1\u7968\u4fe1\u606f")
    RestResponse<Long> addCustomerBillInfo(@RequestBody BillInfoDto billInfoDto) {
        billInfoDto.setInstanceId(this.context.instanceId());
        billInfoDto.setTenantId(this.context.tenantId());
        if (DefaultSettingEnum.YES.getCode().equals(billInfoDto.getInvoiceStatus())) {
            RestResponse billInfoRestResp = this.customerUserQueryApi.queryBillInfoListByOrgInfoId(billInfoDto.getOrgInfoId());
            List billInfoDtos = (List)RestResponseHelper.extractData((RestResponse)billInfoRestResp);
            for (BillInfoDto infoDto : billInfoDtos) {
                if (!DefaultSettingEnum.YES.getCode().equals(infoDto.getInvoiceStatus())) continue;
                infoDto.setInvoiceStatus(Integer.valueOf(0));
                this.customerUserApi.updateCustomerBillInfo(infoDto);
            }
        }
        Long data = (Long)this.customerUserApi.addCustomerBillInfo(billInfoDto).getData();
        return new RestResponse((Object)data);
    }

    @PostMapping(value={"/batch/bill-info"})
    @ApiOperation(value="\u6279\u91cf\u521b\u5efa\u53d1\u7968\u4fe1\u606f", notes="\u6279\u91cf\u521b\u5efa\u53d1\u7968\u4fe1\u606f")
    RestResponse<Void> addCustomerBillInfoBatch(@RequestBody CustomerDetailReqDto billReqDto) {
        if (CollectionUtils.isNotEmpty((Collection)billReqDto.getBillInfoList())) {
            for (BillInfoDto billInfoDto : billReqDto.getBillInfoList()) {
                billInfoDto.setInstanceId(this.context.instanceId());
                billInfoDto.setTenantId(this.context.tenantId());
                RestResponse addBillInfoRestResp = this.customerUserApi.addCustomerBillInfo(billInfoDto);
                RestResponseHelper.extractData((RestResponse)addBillInfoRestResp);
            }
        }
        return RestResponse.VOID;
    }

    @PutMapping(value={"/bill-info"})
    @ApiOperation(value="\u66f4\u65b0\u53d1\u7968\u4fe1\u606f", notes="\u66f4\u65b0\u53d1\u7968\u4fe1\u606f")
    RestResponse<Void> updateCustomerBillInfo(@RequestBody BillInfoDto billInfoDto) {
        billInfoDto.setInstanceId(this.context.instanceId());
        billInfoDto.setTenantId(this.context.tenantId());
        if (DefaultSettingEnum.YES.getCode().equals(billInfoDto.getInvoiceStatus())) {
            RestResponse billInfoRestResp = this.customerUserQueryApi.queryBillInfoListByOrgInfoId(billInfoDto.getOrgInfoId());
            List billInfoDtos = (List)RestResponseHelper.extractData((RestResponse)billInfoRestResp);
            for (BillInfoDto infoDto : billInfoDtos) {
                if (infoDto.getId().equals(billInfoDto.getId())) {
                    this.customerUserApi.updateCustomerBillInfo(billInfoDto);
                    continue;
                }
                if (!DefaultSettingEnum.YES.getCode().equals(infoDto.getInvoiceStatus())) continue;
                infoDto.setInvoiceStatus(Integer.valueOf(0));
                this.customerUserApi.updateCustomerBillInfo(infoDto);
            }
        } else {
            this.customerUserApi.updateCustomerBillInfo(billInfoDto);
        }
        return RestResponse.VOID;
    }

    @PostMapping(value={"/contacts"})
    @ApiOperation(value="\u521b\u5efa\u5ba2\u6237\u8054\u7cfb\u4eba", notes="\u521b\u5efa\u5ba2\u6237\u8054\u7cfb\u4eba")
    RestResponse<Long> addCustomerContactsInfo(@RequestBody ContactsInfoDto contactsInfoDto) {
        contactsInfoDto.setInstanceId(this.context.instanceId());
        contactsInfoDto.setTenantId(this.context.tenantId());
        if (DefaultSettingEnum.YES.getCode().equals(contactsInfoDto.getStatus())) {
            RestResponse contactsInfoRestResp = this.customerUserQueryApi.queryContactsInfoListByOrgInfoId(contactsInfoDto.getOrgInfoId());
            List contactsInfoDtos = (List)RestResponseHelper.extractData((RestResponse)contactsInfoRestResp);
            for (ContactsInfoDto infoDto : contactsInfoDtos) {
                if (!DefaultSettingEnum.YES.getCode().equals(infoDto.getStatus())) continue;
                infoDto.setStatus(Integer.valueOf(0));
                this.customerUserApi.updateCustomerContactsInfo(infoDto);
            }
        }
        Long data = (Long)this.customerUserApi.addCustomerContactsInfo(contactsInfoDto).getData();
        return new RestResponse((Object)data);
    }

    @PostMapping(value={"/batch/contacts"})
    @ApiOperation(value="\u6279\u91cf\u521b\u5efa\u5ba2\u6237\u8054\u7cfb\u4eba", notes="\u6279\u91cf\u521b\u5efa\u5ba2\u6237\u8054\u7cfb\u4eba")
    RestResponse<Void> addCustomerContactsInfoBatch(@RequestBody CustomerDetailReqDto contactsReqDto) {
        if (CollectionUtils.isNotEmpty((Collection)contactsReqDto.getContactsInfoList())) {
            for (ContactsInfoDto contactsInfoDto : contactsReqDto.getContactsInfoList()) {
                contactsInfoDto.setInstanceId(this.context.instanceId());
                contactsInfoDto.setTenantId(this.context.tenantId());
                RestResponse addContactsInfoRestResp = this.customerUserApi.addCustomerContactsInfo(contactsInfoDto);
                RestResponseHelper.extractData((RestResponse)addContactsInfoRestResp);
            }
        }
        return RestResponse.VOID;
    }

    @PutMapping(value={"/contacts"})
    @ApiOperation(value="\u66f4\u65b0\u5ba2\u6237\u8054\u7cfb\u4eba", notes="\u66f4\u65b0\u5ba2\u6237\u8054\u7cfb\u4eba")
    RestResponse<Void> updateCustomerContactsInfo(@RequestBody ContactsInfoDto contactsInfoDto) {
        contactsInfoDto.setInstanceId(this.context.instanceId());
        contactsInfoDto.setTenantId(this.context.tenantId());
        if (DefaultSettingEnum.YES.getCode().equals(contactsInfoDto.getStatus())) {
            RestResponse contactsInfoRestResp = this.customerUserQueryApi.queryContactsInfoListByOrgInfoId(contactsInfoDto.getOrgInfoId());
            List contactsInfoDtos = (List)RestResponseHelper.extractData((RestResponse)contactsInfoRestResp);
            for (ContactsInfoDto infoDto : contactsInfoDtos) {
                if (infoDto.getId().equals(contactsInfoDto.getId())) {
                    this.customerUserApi.updateCustomerContactsInfo(contactsInfoDto);
                    continue;
                }
                if (!DefaultSettingEnum.YES.getCode().equals(infoDto.getStatus())) continue;
                infoDto.setStatus(Integer.valueOf(0));
                this.customerUserApi.updateCustomerContactsInfo(infoDto);
            }
        } else {
            this.customerUserApi.updateCustomerContactsInfo(contactsInfoDto);
        }
        return RestResponse.VOID;
    }

    @DeleteMapping(value={"/bill-info/{id}"})
    @ApiOperation(value="\u5220\u9664\u53d1\u7968\u4fe1\u606f", notes="\u5220\u9664\u53d1\u7968\u4fe1\u606f")
    RestResponse<Void> deleteCustomerBillInfo(@PathVariable(value="id") Long id) {
        this.customerUserApi.deleteCustomerBillInfo(id);
        return RestResponse.VOID;
    }

    @DeleteMapping(value={"/contacts/{id}"})
    @ApiOperation(value="\u5220\u9664\u5ba2\u6237\u8054\u7cfb\u4eba", notes="\u5220\u9664\u5ba2\u6237\u8054\u7cfb\u4eba")
    RestResponse<Void> deleteCustomerContactsInfo(@PathVariable(value="id") Long id) {
        this.customerUserApi.deleteCustomerContactsInfo(id);
        return RestResponse.VOID;
    }

    @DeleteMapping(value={"/address/{id}"})
    @ApiOperation(value="\u5220\u9664\u5ba2\u6237\u5730\u5740", notes="\u5220\u9664\u5ba2\u6237\u5730\u5740")
    RestResponse<Void> deleteCustomerAddress(@PathVariable(value="id") Long id) {
        this.customerUserApi.deleteCustomerAddress(id);
        return RestResponse.VOID;
    }

    @GetMapping(value={"/address/by-org-id/{orgInfoId}"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u4fe1\u606fid,\u67e5\u8be2\u5ba2\u6237\u5730\u5740\u5217\u8868", notes="\u6839\u636e\u7ec4\u7ec7\u4fe1\u606fid,\u67e5\u8be2\u5ba2\u6237\u5730\u5740\u5217\u8868")
    @ApiImplicitParam(name="orgInfoId", value="\u7ec4\u7ec7\u4fe1\u606fid", dataType="Long", paramType="path", required=true)
    RestResponse<List<AddressDto>> queryAddressListByOrgInfoId(@PathVariable(value="orgInfoId") Long orgInfoId) {
        List addressDtoList = (List)this.customerUserQueryApi.queryAddressListByOrgInfoId(orgInfoId).getData();
        return new RestResponse((Object)addressDtoList);
    }
}

