package com.dtyunxi.yundt.module.customer.rest.user;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserAccessRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessExtQueryApi;
import com.dtyunxi.yundt.module.customer.api.user.IAccessExtService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author liangfa
 * @Description 权限查询服务接口
 * @date 2022-01-14 17:42
 * @since 1.0.0
 */
@Api(tags = {"用户组件：权限查询"})
@RestController
@RequestMapping("/v2/accessExt")
public class AccessExtRest  {

    @Resource
    private IAccessExtService accessExtService;

    @GetMapping({"/queryUserAccess/{instanceId}"})
    @ApiOperation(value = "查询用户权限信息", notes = "查询用户权限信息")
    public RestResponse<UserAccessRespDto> queryUserAccess(@RequestParam("userId") Long userId, @PathVariable("instanceId") Long instanceId) {
        return accessExtService.queryUserAccess(userId,instanceId);
    }
}
