package com.dtyunxi.yundt.module.customer.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeRegionRespDto;
import com.dtyunxi.yundt.module.customer.api.IEmployeeRegionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Author: xiuji
 * @Date: 2022/1/20 10:07 AM
 */
@Api(tags = {"客商组件：人员关联区域服务"})
@RestController
@RequestMapping("/v1/employeeRegion")
public class EmployeeRegionRest {

    @Autowired
    private IEmployeeRegionService employeeRegionService;

    @PostMapping("/list")
    @ApiOperation(value = "查询人员关联区域", notes = "查询人员关联区域")
    RestResponse<List<EmployeeRegionRespDto>> queryEmployeeRegionList(@RequestBody EmployeeRegionQueryReqDto queryReqDto){
        return employeeRegionService.queryEmployeeRegionList(queryReqDto);
    }

    @PostMapping("/queryCustomerAreaByCodes")
    @ApiOperation(value = "根据区域编码查询区域信息", notes = "根据区域编码查询区域信息")
    RestResponse<List<CustomerAreaRespDto>> queryCustomerAreaByCodes(@RequestBody List<String> codes){
        return employeeRegionService.queryCustomerAreaByCodes(codes);
    }


}
