/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.shop.rest;

import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.shop.api.IMerchant;
import com.dtyunxi.yundt.module.shop.api.IMerchantService;
import com.dtyunxi.yundt.module.shop.api.enums.MerchantServiceEventEnum;
import com.dtyunxi.yundt.module.shop.bo.ApplyFormAudit;
import com.dtyunxi.yundt.module.shop.bo.ApplyFormDto;
import com.dtyunxi.yundt.module.shop.bo.MerchantInfo;
import com.dtyunxi.yundt.module.shop.bo.dto.request.MerchantQueryReqDto;
import com.dtyunxi.yundt.module.shop.bo.dto.response.ApplyFormRespDto;
import com.dtyunxi.yundt.module.shop.bo.dto.response.MerchantInfoRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e97\u94fa\u7ec4\u4ef6\uff1a\u5546\u6237\u670d\u52a1"})
@Validated
@RestController
@RequestMapping(value={"/v1/merchant"})
public class MerchantRest {
    @Resource
    private IMerchant merchantImpl;
    @Autowired
    private IMerchantService merchantService;

    @PostMapping(value={"/applyForm"})
    @ApiOperation(value="\u7533\u8bf7\u5165\u9a7b")
    @ApiImplicitParam(paramType="body", name="applyFormDto", dataType="ApplyFormDto", required=true, value="\u7533\u8bf7\u5355")
    public RestResponse<Long> applyForm(@Valid @RequestBody ApplyFormDto applyFormDto) {
        ServiceEvent serviceEvent = new ServiceEvent(MerchantServiceEventEnum.APPLY_MECHANT.getCode(), MerchantServiceEventEnum.APPLY_MECHANT.getName(), (Object)applyFormDto);
        Long formId = (Long)this.merchantService.doService(serviceEvent);
        return new RestResponse((Object)formId);
    }

    @PutMapping(value={"/applyForm/{applyFormId}"})
    @ApiOperation(value="\u4fee\u6539\u7533\u8bf7\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", name="applyFormId", dataType="Long", required=true, value="\u7533\u8bf7\u5355id"), @ApiImplicitParam(paramType="body", name="applyFormDto", dataType="ApplyFormDto", required=true, value="\u7533\u8bf7\u5355")})
    public RestResponse<Void> modify(@PathVariable(value="applyFormId") Long applyFormId, @RequestBody ApplyFormDto applyFormDto) {
        applyFormDto.setId(applyFormId);
        ServiceEvent serviceEvent = new ServiceEvent(MerchantServiceEventEnum.MODIFY_FORM.getCode(), MerchantServiceEventEnum.MODIFY_FORM.getName(), (Object)applyFormDto);
        this.merchantService.doService(serviceEvent);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/applyForm/audit"})
    @ApiOperation(value="\u5ba1\u6838\u7533\u8bf7\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", name="applyFormAudit", dataType="ApplyFormAudit", required=true, value="\u5546\u6237\u5ba1\u6838bo")})
    public RestResponse auditApplyForm(@Valid @RequestBody ApplyFormAudit applyFormAudit) {
        ServiceEvent serviceEvent = new ServiceEvent(MerchantServiceEventEnum.AUDIT_FORM.getCode(), MerchantServiceEventEnum.AUDIT_FORM.getName(), (Object)applyFormAudit);
        this.merchantService.doService(serviceEvent);
        return RestResponse.VOID;
    }

    @GetMapping(value={"/applyForm/list"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7533\u8bf7\u5355\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", paramType="query", dataType="Int", defaultValue="1", required=true), @ApiImplicitParam(name="pageSize", paramType="query", dataType="Int", defaultValue="10", required=true)})
    public RestResponse<PageInfo<ApplyFormRespDto>> queryFormPage(MerchantQueryReqDto merchantQueryReqDto, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return new RestResponse((Object)this.merchantImpl.queryFormPage(merchantQueryReqDto, pageNum, pageSize));
    }

    @GetMapping(value={"/applyForm/{id}"})
    @ApiOperation(value="\u67e5\u770b\u7533\u8bf7\u5355\u4fe1\u606f\uff08\u540e\u53f0\uff09")
    @ApiImplicitParam(paramType="path", name="id", dataType="Long", required=true, value="\u7533\u8bf7\u5355id")
    public RestResponse<ApplyFormRespDto> getFormById(@PathVariable(value="id") Long id) {
        return new RestResponse((Object)this.merchantImpl.getFormById(id));
    }

    @GetMapping(value={"/applyForm"})
    @ApiOperation(value="\u67e5\u770b\u7533\u8bf7\u5355\u4fe1\u606f\uff08\u5546\u57ce\u7aef\uff09")
    public RestResponse<ApplyFormRespDto> getFormByContext() {
        return new RestResponse((Object)this.merchantImpl.getFormByContext());
    }

    @PostMapping(value={""})
    @ApiOperation(value="\u521b\u5efa\u5546\u6237")
    @ApiImplicitParam(paramType="body", name="merchantInfo", dataType="MerchantInfo", required=true, value="\u5546\u6237\u4fe1\u606f")
    public RestResponse<Long> createMerchant(@Valid @RequestBody MerchantInfo merchantInfo) {
        return new RestResponse((Object)this.merchantImpl.createMerchant(merchantInfo));
    }

    @PutMapping(value={"/{merchantId}"})
    @ApiOperation(value="\u4fee\u6539\u5546\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", name="merchantId", dataType="Long", required=true, value="\u5546\u6237id"), @ApiImplicitParam(paramType="body", name="merchantInfo", dataType="MerchantInfo", required=true, value="\u5546\u6237\u4fe1\u606f")})
    public RestResponse<Void> modify(@PathVariable(value="merchantId") Long merchantId, @RequestBody MerchantInfo merchantInfo) {
        this.merchantImpl.modify(merchantId, merchantInfo);
        return RestResponse.VOID;
    }

    @PutMapping(value={"/{merchantId}/enable"})
    @ApiOperation(value="\u542f\u7528\u5546\u6237")
    @ApiImplicitParam(paramType="path", name="merchantId", dataType="Long", required=true, value="\u5546\u6237id")
    public RestResponse<Void> enable(@PathVariable(value="merchantId") Long merchantId) {
        this.merchantImpl.updateStatus(merchantId, "NORMAL");
        return RestResponse.VOID;
    }

    @PutMapping(value={"/{merchantId}/disable"})
    @ApiOperation(value="\u7981\u7528\u5546\u6237")
    @ApiImplicitParam(paramType="path", name="merchantId", dataType="Long", required=true, value="\u5546\u6237id")
    public RestResponse<Void> disable(@PathVariable(value="merchantId") Long merchantId) {
        this.merchantImpl.updateStatus(merchantId, "BANNED");
        return RestResponse.VOID;
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u67e5\u770b\u5546\u6237\u4fe1\u606f")
    @ApiImplicitParam(paramType="path", name="id", dataType="Long", required=true, value="\u5546\u6237id")
    public RestResponse<MerchantInfoRespDto> getById(@PathVariable(value="id") Long id) {
        return new RestResponse((Object)this.merchantImpl.getById(id));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5546\u6237\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", paramType="query", dataType="Int", defaultValue="1", required=true), @ApiImplicitParam(name="pageSize", paramType="query", dataType="Int", defaultValue="10", required=true)})
    public RestResponse<PageInfo<MerchantInfoRespDto>> queryPage(MerchantQueryReqDto merchantQueryReqDto, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return new RestResponse((Object)this.merchantImpl.queryPage(merchantQueryReqDto, pageNum, pageSize));
    }

    @GetMapping(value={"/session"})
    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u767b\u5f55\u7528\u6237\u67e5\u770b\u5546\u6237\u4fe1\u606f")
    public RestResponse<MerchantInfoRespDto> getBySession() {
        Long sellerId = this.merchantImpl.getSellerIdByContext();
        return new RestResponse((Object)this.merchantImpl.getById(sellerId));
    }

    @GetMapping(value={""})
    @ApiOperation(value="\u67e5\u8be2\u5546\u6237\u4fe1\u606f\u5217\u8868")
    public RestResponse<List<MerchantInfoRespDto>> querySellers(MerchantQueryReqDto merchantQueryReqDto) {
        return new RestResponse((Object)this.merchantImpl.queryMerchantInfos(merchantQueryReqDto));
    }
}

