/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.shop.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopTransportPartnerDto;
import com.dtyunxi.yundt.module.domain.util.ConvertUtil;
import com.dtyunxi.yundt.module.shop.api.IShop;
import com.dtyunxi.yundt.module.shop.bo.Shop;
import com.dtyunxi.yundt.module.shop.bo.ShopAudit;
import com.dtyunxi.yundt.module.shop.dto.request.ShopQueryReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e97\u94fa\u7ec4\u4ef6\uff1a\u5e97\u94fa\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/shop"})
public class ShopRest {
    @Autowired
    private IShop shopImpl;

    @PostMapping(value={""})
    @ApiOperation(value="\u5f00\u901a\u5e97\u94fa")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", name="shop", dataType="Shop", required=true, value="\u5e97\u94fabo"), @ApiImplicitParam(paramType="query", name="needAudit", dataType="Boolean", required=true, value="\u662f\u5426\u9700\u8981\u5ba1\u6838")})
    public RestResponse<Long> create(@Valid @RequestBody Shop shop, @RequestParam(value="needAudit") Boolean needAudit) {
        return new RestResponse((Object)this.shopImpl.add(shop, needAudit));
    }

    @PutMapping(value={""})
    @ApiOperation(value="\u4fee\u6539\u5e97\u94fa\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", name="shop", dataType="Shop", required=true, value="\u5e97\u94fabo")})
    public RestResponse<Long> modify(@Valid @RequestBody Shop shop) {
        return new RestResponse((Object)this.shopImpl.update(shop));
    }

    @ApiOperation(value="\u542f\u7528\u5e97\u94fa")
    @ApiImplicitParam(name="shopId", paramType="path", dataType="Long", required=true, value="\u5e97\u94faid")
    @PutMapping(value={"/{shopId}/enable"})
    RestResponse<Void> enableShop(@PathVariable(value="shopId") Long shopId) {
        this.shopImpl.updateStatus(shopId, "NORMAL");
        return RestResponse.VOID;
    }

    @ApiOperation(value="\u7981\u7528\u5e97\u94fa")
    @ApiImplicitParam(name="shopId", paramType="path", dataType="Long", required=true, value="\u5e97\u94faid")
    @PutMapping(value={"/{shopId}/disable"})
    RestResponse<Void> disableShop(@PathVariable(value="shopId") Long shopId) {
        this.shopImpl.updateStatus(shopId, "BANNED");
        return RestResponse.VOID;
    }

    @PutMapping(value={"/audit"})
    @ApiOperation(value="\u5ba1\u6838\u5e97\u94fa")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", name="shopAudit", dataType="ShopAudit", required=true, value="\u5e97\u94fa\u5ba1\u6838bo")})
    public RestResponse audit(@RequestBody ShopAudit shopAudit) {
        this.shopImpl.audit(shopAudit);
        return RestResponse.VOID;
    }

    @GetMapping(value={"/{shopId}"})
    @ApiOperation(value="\u67e5\u770b\u5e97\u94fa\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", name="shopId", dataType="Long", required=true, value="\u5e97\u94faid")})
    public RestResponse<Shop> getById(@PathVariable(value="shopId") Long shopId) {
        return new RestResponse((Object)this.shopImpl.getById(shopId));
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5e97\u94fa\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", paramType="query", dataType="Int", defaultValue="1", required=true), @ApiImplicitParam(name="pageSize", paramType="query", dataType="Int", defaultValue="10", required=true)})
    public RestResponse<PageInfo<Shop>> queryShopByPage(ShopQueryReqDto shopQueryDto, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        Shop shop = (Shop)ConvertUtil.convert((Object)shopQueryDto, Shop.class);
        shop.setName(shopQueryDto.getShopName());
        return new RestResponse((Object)this.shopImpl.query(shop, pageNum, pageSize));
    }

    @GetMapping(value={"/list/byContext"})
    @ApiOperation(value="\u6839\u636e\u767b\u5f55\u65b9\u83b7\u53d6\u5e97\u94fa\u5217\u8868")
    public RestResponse<List<Shop>> queryShopListByContext() {
        PageInfo pageInfo = this.shopImpl.query(new Shop(), Integer.valueOf(1), Integer.valueOf(1000));
        return new RestResponse((Object)pageInfo.getList());
    }

    @GetMapping(value={"/shop/dir/compensate"})
    @ApiOperation(value="\u8865\u507f\u5e97\u94fa\u6839\u7c7b\u76ee\u6570\u636e")
    @ApiImplicitParam(paramType="query", name="instanceId", dataType="Long", required=true, value="\u5b9e\u4f8bid")
    public RestResponse compensate(@RequestParam(value="instanceId") Long instanceId) {
        return new RestResponse((Object)this.shopImpl.compensate(instanceId));
    }

    @GetMapping(value={"/storeShopList"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5e97\u94fa\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", paramType="query", dataType="Int", defaultValue="1", required=true), @ApiImplicitParam(name="pageSize", paramType="query", dataType="Int", defaultValue="10", required=true)})
    public RestResponse<PageInfo<Shop>> queryStoreShopList(ShopQueryDto shopQueryDto, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        return new RestResponse((Object)this.shopImpl.queryStoreShopList(shopQueryDto, pageNum, pageSize));
    }

    @GetMapping(value={"/isCheckAddress"})
    @ApiOperation(value="\u68c0\u67e5\u5730\u5740\u662f\u5426\u5728\u914d\u9001\u8303\u56f4\u5185(\u8fd4\u56de 1,\u8868\u793a\u4e0d\u662fo2o\u540c\u57ce\u914d\u9001\uff0c2\u8868\u793a\u662fo20\u4e14\u5728\u914d\u9001\u8303\u56f4\u5185, 3\u8868\u793a\u662fo20\u4e14\u4e0d\u5728\u914d\u9001\u8303\u56f4\u5185)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="locationX", paramType="query", dataType="String", value="\u7ecf\u5ea6"), @ApiImplicitParam(name="locationY", paramType="query", dataType="String", value="\u7eac\u5ea6"), @ApiImplicitParam(name="shopIds", paramType="query", dataType="String", required=true, value="\u5e97\u94faid,\u591a\u4e2a\u4ee5\u9017\u53f7\u9694\u5f00")})
    public RestResponse isCheckAddress(String locationX, String locationY, String shopIds) {
        return new RestResponse((Object)this.shopImpl.isCheckAddress(locationX, locationY, shopIds));
    }

    @GetMapping(value={"/rangeShopList"})
    @ApiOperation(value="\u5207\u6362\u5e97\u94fa\u65f6\uff0c\u6839\u636e\u5750\u6807\u6309\u7167\u8ddd\u79bb\u7531\u8fd1\u5230\u8fdc\u6392\u5e8f\u67e5\u8be2\u5e97\u94fa\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="lon", paramType="query", dataType="String", value="\u7ecf\u5ea6"), @ApiImplicitParam(name="lat", paramType="query", dataType="String", value="\u7eac\u5ea6"), @ApiImplicitParam(name="pageNum", paramType="query", dataType="Integer", value="\u5f53\u524d\u9875"), @ApiImplicitParam(name="pageSize", paramType="query", dataType="Integer", value="\u6bcf\u9875\u5927\u5c0f")})
    public RestResponse queryRangeShopListByGeo(@RequestParam(value="lat") String lat, @RequestParam(value="lon") String lon, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        return new RestResponse((Object)this.shopImpl.queryRangeShopListByGeo(lat, lon, pageNum, pageSize));
    }

    @GetMapping(value={"/{shopId}/partners"})
    @ApiOperation(value="\u67e5\u8be2\u5e97\u94fa\u652f\u6301\u7684\u914d\u9001\u65b9\u5217\u8868")
    RestResponse<List<ShopTransportPartnerDto>> queryShopTransportPartner(@PathVariable(value="shopId") Long shopId) {
        return new RestResponse((Object)this.shopImpl.queryShopTransportPartner(shopId));
    }
}

