/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.shop.rest;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.domain.util.ConvertUtil;
import com.dtyunxi.yundt.module.shop.api.ISubStationService;
import com.dtyunxi.yundt.module.shop.bo.SubStation;
import com.dtyunxi.yundt.module.shop.bo.constant.SubStationConstant;
import com.dtyunxi.yundt.module.shop.dto.request.SubStationQueryReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e97\u94fa\u7ec4\u4ef6\uff1a\u5b50\u7ad9\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/sub-station"})
public class SubStationRest {
    @Autowired
    private ISubStationService subStationImpl;

    @PostMapping(value={""})
    @ApiOperation(value="\u521b\u5efa\u5b50\u7ad9")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", name="subStation", dataType="SubStation", required=true, value="\u5b50\u7ad9bo")})
    public RestResponse<Long> create(@Valid @RequestBody SubStation subStation) {
        return new RestResponse((Object)this.subStationImpl.add(subStation));
    }

    @PutMapping(value={""})
    @ApiOperation(value="\u4fee\u6539\u5b50\u7ad9")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", name="subStation", dataType="SubStation", required=true, value="\u5b50\u7ad9bo")})
    public RestResponse<Long> modify(@Valid @RequestBody SubStation subStation) {
        if (subStation.getId() == null) {
            throw new BizException("\u5b50\u7ad9id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new RestResponse((Object)this.subStationImpl.update(subStation));
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u67e5\u770b\u5b50\u7ad9\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", name="id", dataType="Long", required=true, value="\u5b50\u7ad9id")})
    public RestResponse<SubStation> getById(@PathVariable(value="id") Long id) {
        return new RestResponse((Object)this.subStationImpl.getById(id));
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5b50\u7ad9\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", paramType="query", dataType="Int", defaultValue="1", required=true), @ApiImplicitParam(name="pageSize", paramType="query", dataType="Int", defaultValue="10", required=true)})
    public RestResponse<PageInfo<SubStation>> querySubStationByPage(SubStationQueryReqDto subStationQueryReqDto, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        SubStation subStation = (SubStation)ConvertUtil.convert((Object)subStationQueryReqDto, SubStation.class);
        return new RestResponse((Object)this.subStationImpl.query(subStation, pageNum, pageSize));
    }

    @ApiOperation(value="\u542f\u7528\u5b50\u7ad9")
    @ApiImplicitParam(name="id", paramType="path", dataType="Long", required=true, value="\u5b50\u7ad9id")
    @PutMapping(value={"/{id}/enable"})
    RestResponse<Void> enableShop(@PathVariable(value="id") Long id) {
        this.subStationImpl.updateStatus(id, SubStationConstant.STATUS_ENABLE);
        return RestResponse.VOID;
    }

    @ApiOperation(value="\u7981\u7528\u5b50\u7ad9")
    @ApiImplicitParam(name="id", paramType="path", dataType="Long", required=true, value="\u5b50\u7ad9id")
    @PutMapping(value={"/{id}/disable"})
    RestResponse<Void> disableShop(@PathVariable(value="id") Long id) {
        this.subStationImpl.updateStatus(id, SubStationConstant.STATUS_DISABLE);
        return RestResponse.VOID;
    }

    @GetMapping(value={"/match"})
    @ApiOperation(value="\u6839\u636e\u57ce\u5e02\u540d\u79f0\u5339\u914d\u533a\u57df\u5b50\u7ad9")
    public RestResponse matchSubStation(@RequestParam(value="city") String city) {
        return new RestResponse((Object)this.subStationImpl.getBySubStationName(city));
    }
}

