/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.pearlriver.utils.poi;

import com.dtyunxi.pearlriver.utils.poi.ExcelRSheetProcessor;
import com.dtyunxi.pearlriver.utils.poi.annotation.ColumnData;
import com.dtyunxi.pearlriver.utils.poi.annotation.RowData;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class ExcelReadUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExcelReadUtils.class);

    public static void read(InputStream inputStream, Map<String, Object> map, ExcelRSheetProcessor<?> ... sheetProcessors) throws Exception {
        StrBuilder errorMsg = new StrBuilder();
        Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
        for (int j = 0; j < sheetProcessors.length; ++j) {
            ExcelRSheetProcessor<?> sheetProcessor = sheetProcessors[j];
            Sheet sheet = workbook.getSheetAt(j);
            try {
                sheetProcessor.setSheet(sheet);
                int pageSize = sheetProcessor.getPageSize();
                int readRowIndex = sheetProcessor.getRowStartIndex();
                Class clazz = (Class)((ParameterizedTypeImpl)sheetProcessor.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
                int total = sheet.getLastRowNum() - readRowIndex + 1;
                RowData rowData = clazz.getAnnotation(RowData.class);
                if (rowData != null) {
                    total = new Double(Math.ceil(total / rowData.rowAcross())).intValue();
                }
                int size = total;
                ArrayList list = null;
                int count = 0;
                if (pageSize > 0) {
                    int part = total / pageSize;
                    size = pageSize;
                    list = new ArrayList(size);
                    for (int i = 0; i < part; ++i) {
                        readRowIndex = ExcelReadUtils.read(sheetProcessor, list, clazz, size, readRowIndex, map, errorMsg, count);
                        ++count;
                        sheetProcessor.process(list);
                        list.clear();
                    }
                    size = total % pageSize;
                }
                if (size > 0) {
                    list = new ArrayList(size);
                    readRowIndex = ExcelReadUtils.read(sheetProcessor, list, clazz, size, readRowIndex, map, errorMsg, count);
                    sheetProcessor.process(list);
                    list.clear();
                }
            }
            catch (Exception e) {
                logger.error("\u8bfb\u53d6\u8868\u683c\u6570\u636e\u65f6\u5f02\u5e38,msg:{}", (Object)e.getMessage());
                throw new RuntimeException("\u8bfb\u53d6\u8868\u683c\u6570\u636e\u65f6\u5f02\u5e38", e);
            }
            if (errorMsg.size() <= 0) continue;
            throw new RuntimeException(errorMsg.toString().substring(0, errorMsg.length() - 1));
        }
    }

    private static int read(ExcelRSheetProcessor<?> sheetProcessor, List listPage, Class<?> clazz, int size, int readRowIndex, Map<String, Object> map, StrBuilder errorMsg, int count) throws Exception {
        RowData rowData = clazz.getAnnotation(RowData.class);
        Sheet sheet = sheetProcessor.getSheet();
        for (int i = 0; i < size; ++i) {
            if (!ExcelReadUtils.needRead(sheet, rowData.rowAcross() * readRowIndex)) {
                if (rowData != null) {
                    readRowIndex += rowData.rowAcross();
                    continue;
                }
                ++readRowIndex;
                continue;
            }
            ArrayList<Row> rowList = new ArrayList<Row>();
            for (int j = 0; rowData != null && j < rowData.rowAcross() || j < 1; ++j) {
                Row row = sheet.getRow(readRowIndex + j);
                if (row == null) continue;
                rowList.add(row);
            }
            Field[] declaredFields = clazz.getDeclaredFields();
            Object obj = clazz.newInstance();
            for (Field field : declaredFields) {
                ColumnData column = null;
                PropertyDescriptor pd = null;
                try {
                    column = field.getAnnotation(ColumnData.class);
                    if (null == column) {
                        if (null == map || !map.containsKey(field.getName())) continue;
                        pd = BeanUtils.getPropertyDescriptor(clazz, (String)field.getName());
                        pd.getWriteMethod().invoke(obj, map.get(field.getName()));
                        continue;
                    }
                    Cell cell = ((Row)rowList.get(column.rowIndex())).getCell(column.colIndex());
                    Object fieldVal = ExcelReadUtils.getCell(cell, field.getType());
                    pd = BeanUtils.getPropertyDescriptor(clazz, (String)field.getName());
                    pd.getWriteMethod().invoke(obj, fieldVal);
                }
                catch (Exception e) {
                    if (column.dealType().equals((Object)ColumnData.dealType.CONTINUE_CELL)) {
                        errorMsg.append("\u884c:" + (sheetProcessor.getPageSize() * count + i + 1 + sheetProcessor.getRowStartIndex()) + "---\u5217:" + (column.colIndex() + 1) + "\u5b57\u6bb5\u548c\u5355\u5143\u683c\u4e0d\u5339\u914d,");
                        continue;
                    }
                    if (column.dealType().equals((Object)ColumnData.dealType.CONTINUE_ROW)) break;
                    logger.error("\u5b9e\u4f53\u5b57\u6bb5\u65f6\u5f02\u5e38,fieldName:{}", (Object)(field.getName() + i));
                    throw new RuntimeException("deal cell exception", e);
                }
            }
            listPage.add(obj);
            if (rowData != null) {
                readRowIndex += rowData.rowAcross();
                continue;
            }
            ++readRowIndex;
        }
        return readRowIndex;
    }

    private static Object getCell(Cell cell, Class<?> clazz) {
        String cellValue;
        block9: {
            try {
                cellValue = cell.getStringCellValue();
            }
            catch (Exception e) {
                DecimalFormat df;
                double numericCellValue = cell.getNumericCellValue();
                cellValue = String.valueOf(numericCellValue);
                if (cellValue.indexOf("E") > 0) {
                    df = new DecimalFormat("0");
                    cellValue = df.format(numericCellValue);
                }
                if (!cellValue.endsWith(".0")) break block9;
                df = new DecimalFormat("0");
                cellValue = df.format(numericCellValue);
            }
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return Double.valueOf(cellValue).shortValue();
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return Double.valueOf(cellValue).intValue();
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return Double.valueOf(cellValue).longValue();
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return Float.valueOf(cellValue);
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return Double.valueOf(cellValue);
        }
        if (clazz.equals(BigDecimal.class)) {
            return new BigDecimal(cellValue);
        }
        return cellValue;
    }

    public static boolean needRead(Sheet sheet, int row) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row == firstRow && row < lastRow) {
                return true;
            }
            if (row <= firstRow || row > lastRow) continue;
            return false;
        }
        return true;
    }
}

