/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.pearlriver.utils.poi;

import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.pearlriver.utils.poi.ExcelType;
import com.dtyunxi.pearlriver.utils.poi.ExcelWSheetProcessor;
import com.dtyunxi.pearlriver.utils.poi.ExcelWriteUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDownloadUtil {
    private static final Logger log = LoggerFactory.getLogger(FileDownloadUtil.class);
    public static String EXCEL = ".xlsx";
    private static FileDownloadUtil single = null;

    private FileDownloadUtil() {
    }

    public static FileDownloadUtil getSingle() {
        if (null == single) {
            single = new FileDownloadUtil();
        }
        return single;
    }

    public void downLoad(String fileName, ExcelWSheetProcessor sheetProcessor, HttpServletResponse response) {
        this.downLoad(fileName, sheetProcessor, response, EXCEL);
    }

    public void downLoad(String fileName, ExcelWSheetProcessor sheetProcessor, HttpServletResponse response, String fileType) {
        Long beginTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = beginTime + "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream inputStream = null;
        try {
            ExcelWriteUtils.write(ExcelType.XLSX, byteArrayOutputStream, sheetProcessor);
            log.info("============\u751f\u6210Excel\u8868\u683c\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - beginTime));
            beginTime = System.currentTimeMillis();
            inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            response.reset();
            response.setContentType("application/octet-stream;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String((fileName + ".xlsx").getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            out.write(byteArrayOutputStream.toByteArray());
            log.info("============\u4e0a\u4f20Excel\u8868\u683c\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - beginTime));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessRuntimeException("\u5bfc\u51fa\u5931\u8d25");
        }
        finally {
            try {
                byteArrayOutputStream.close();
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage());
                throw new BusinessRuntimeException("\u5bfc\u51fa\u5931\u8d25");
            }
        }
    }
}

