/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SwiftpassFinanceFileReqDto;
import com.dtyunxi.tcbj.api.dto.response.SwiftpassFinanceFileRespDto;
import com.dtyunxi.tcbj.api.enums.citic.PartnerConfigEnum;
import com.dtyunxi.tcbj.api.enums.citic.SwiftpassFileStatusEnum;
import com.dtyunxi.tcbj.biz.service.ISwiftpassFinanceFileService;
import com.dtyunxi.tcbj.dao.das.SwiftpassFinanceFileDas;
import com.dtyunxi.tcbj.dao.das.SwiftpassFinanceFileDetailDas;
import com.dtyunxi.tcbj.dao.eo.SwiftpassFinanceFileDetailEo;
import com.dtyunxi.tcbj.dao.eo.SwiftpassFinanceFileEo;
import com.dtyunxi.tcbj.dao.mapper.SwiftpassFinanceFileMapper;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.impl.SpGatewayServiceImpl;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.response.SpDownloadOrderResponse;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PartnerConfigDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.github.pagehelper.PageInfo;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwiftpassFinanceFileServiceImpl
implements ISwiftpassFinanceFileService {
    private static Logger logger = LoggerFactory.getLogger(SwiftpassFinanceFileServiceImpl.class);
    @Resource
    private SwiftpassFinanceFileDas swiftpassFinanceFileDas;
    @Resource
    private SpGatewayServiceImpl spGatewayService;
    @Resource
    private PartnerConfigDas payPartnerConfigDas;
    @Resource
    private SwiftpassFinanceFileDetailDas swiftpassFinanceFileDetailDas;
    @Resource
    private SwiftpassFinanceFileMapper swiftpassFinanceFileMapper;

    @Override
    public Long addSwiftpassFinanceFile(SwiftpassFinanceFileReqDto addReqDto) {
        SwiftpassFinanceFileEo swiftpassFinanceFileEo = new SwiftpassFinanceFileEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)swiftpassFinanceFileEo);
        this.swiftpassFinanceFileDas.insert((BaseEo)swiftpassFinanceFileEo);
        return swiftpassFinanceFileEo.getId();
    }

    @Override
    public void modifySwiftpassFinanceFile(SwiftpassFinanceFileReqDto modifyReqDto) {
        SwiftpassFinanceFileEo swiftpassFinanceFileEo = new SwiftpassFinanceFileEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)swiftpassFinanceFileEo);
        this.swiftpassFinanceFileDas.updateSelective((BaseEo)swiftpassFinanceFileEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSwiftpassFinanceFile(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.swiftpassFinanceFileDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SwiftpassFinanceFileRespDto queryById(Long id) {
        SwiftpassFinanceFileEo swiftpassFinanceFileEo = (SwiftpassFinanceFileEo)this.swiftpassFinanceFileDas.selectByPrimaryKey(id);
        SwiftpassFinanceFileRespDto swiftpassFinanceFileRespDto = new SwiftpassFinanceFileRespDto();
        DtoHelper.eo2Dto((BaseEo)swiftpassFinanceFileEo, (BaseVo)swiftpassFinanceFileRespDto);
        return swiftpassFinanceFileRespDto;
    }

    @Override
    public PageInfo<SwiftpassFinanceFileRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SwiftpassFinanceFileReqDto swiftpassFinanceFileReqDto = (SwiftpassFinanceFileReqDto)JSON.parseObject((String)filter, SwiftpassFinanceFileReqDto.class);
        SwiftpassFinanceFileEo swiftpassFinanceFileEo = new SwiftpassFinanceFileEo();
        DtoHelper.dto2Eo((BaseVo)swiftpassFinanceFileReqDto, (BaseEo)swiftpassFinanceFileEo);
        PageInfo eoPageInfo = this.swiftpassFinanceFileDas.selectPage((BaseEo)swiftpassFinanceFileEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SwiftpassFinanceFileRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void swiftpassFinanceFileParse(String verifyDate) {
        RestResponse<SwiftpassFinanceFileRespDto> fileResp;
        SwiftpassFinanceFileRespDto fileRespDto;
        SwiftpassFinanceFileEo seaSwFiEo = new SwiftpassFinanceFileEo();
        seaSwFiEo.setBillDate(verifyDate);
        seaSwFiEo.setCode(PartnerConfigEnum.WFT_MER_CODE.key);
        SwiftpassFinanceFileEo resSwFiEo = (SwiftpassFinanceFileEo)this.swiftpassFinanceFileDas.selectOne((BaseEo)seaSwFiEo);
        if (resSwFiEo == null && (fileRespDto = (SwiftpassFinanceFileRespDto)(fileResp = this.downloadFile(verifyDate)).getData()) != null && StringUtils.isNotEmpty((CharSequence)fileRespDto.getFileText())) {
            PartnerConfigEo config = (PartnerConfigEo)this.payPartnerConfigDas.selectByLogicKey((Object)seaSwFiEo.getCode());
            resSwFiEo = new SwiftpassFinanceFileEo();
            resSwFiEo.setCode(PartnerConfigEnum.WFT_MER_CODE.key);
            if (ObjectUtils.isNotEmpty((Object)config)) {
                resSwFiEo.setStoreCode(config.getStoreCode());
                resSwFiEo.setAppCode(config.getAppCode());
                resSwFiEo.setPartnerCode(config.getPartnerCode());
            }
            resSwFiEo.setBillDate(verifyDate);
            resSwFiEo.setFileStatus(SwiftpassFileStatusEnum.ACCEPT.key);
            resSwFiEo.setFileText(fileRespDto.getFileText());
            resSwFiEo.setFileUri(fileRespDto.getFileUri());
            this.swiftpassFinanceFileDas.insert((BaseEo)resSwFiEo);
        }
        if (resSwFiEo != null && !resSwFiEo.getFileStatus().equals(SwiftpassFileStatusEnum.SUCCESS.key)) {
            SwiftpassFinanceFileEo upEo = new SwiftpassFinanceFileEo();
            upEo.setId(resSwFiEo.getId());
            try {
                this.parseSwiftpassFileText(resSwFiEo, upEo);
                upEo.setFileStatus(SwiftpassFileStatusEnum.SUCCESS.key);
                this.swiftpassFinanceFileDas.updateSelective((BaseEo)upEo);
            }
            catch (Exception e) {
                upEo.setFileStatus(SwiftpassFileStatusEnum.FAIL.key);
                this.swiftpassFinanceFileDas.updateSelective((BaseEo)upEo);
                SwiftpassFinanceFileDetailEo delEo = new SwiftpassFinanceFileDetailEo();
                delEo.setFileId(resSwFiEo.getId());
                this.swiftpassFinanceFileDetailDas.delete((BaseEo)delEo);
            }
        }
    }

    @Override
    public synchronized void parseSwiftpassFileText(SwiftpassFinanceFileEo swFiEo, SwiftpassFinanceFileEo upEo) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(swFiEo.getFileText().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String line = br.readLine();
        Integer batchNum = 100;
        int dataNum = 0;
        ArrayList<SwiftpassFinanceFileDetailEo> detailEoList = new ArrayList<SwiftpassFinanceFileDetailEo>(batchNum);
        while ((line = br.readLine()) != null) {
            ++dataNum;
            String[] strArray = line.replace("`", "").split(",");
            SwiftpassFinanceFileDetailEo detailEo = new SwiftpassFinanceFileDetailEo();
            detailEo.setBillDate(swFiEo.getBillDate());
            detailEo.setFileId(swFiEo.getId());
            try {
                detailEo.setTradeTime(format.parse(strArray[0]));
            }
            catch (Exception e) {
                --dataNum;
                break;
            }
            detailEo.setPartnerAppId(strArray[1]);
            detailEo.setPartnerMerId(strArray[2]);
            detailEo.setMchId(strArray[3]);
            detailEo.setSubMchId(strArray[4]);
            detailEo.setDeviceInfo(strArray[5]);
            detailEo.setTransactionId(strArray[6]);
            detailEo.setOutTransactionId(strArray[7]);
            detailEo.setOutTradeNo(strArray[8]);
            detailEo.setSubOpenid(strArray[9]);
            detailEo.setService(strArray[10]);
            detailEo.setTradeStatus(strArray[11]);
            detailEo.setTradeBank(strArray[12]);
            detailEo.setCurrencyCategory(strArray[13]);
            detailEo.setTotalFee(StringUtils.isNotBlank((CharSequence)strArray[14]) ? new BigDecimal(strArray[14]) : new BigDecimal(0));
            detailEo.setCompanyRedFee(StringUtils.isNotBlank((CharSequence)strArray[15]) ? new BigDecimal(strArray[15]) : new BigDecimal(0));
            detailEo.setRefundId(strArray[16]);
            detailEo.setOutRefundNo(strArray[17]);
            detailEo.setRefundFee(strArray[18]);
            detailEo.setCompanyRefundRedFee(StringUtils.isNotBlank((CharSequence)strArray[19]) ? new BigDecimal(strArray[19]) : new BigDecimal(0));
            detailEo.setRefundType(strArray[20]);
            detailEo.setRefundStatus(strArray[21]);
            detailEo.setBody(strArray[22]);
            detailEo.setAttach(strArray[23]);
            detailEo.setPoundage(StringUtils.isNotBlank((CharSequence)strArray[24]) ? new BigDecimal(strArray[24]) : new BigDecimal(0));
            detailEo.setPoundageRate(StringUtils.isNotBlank((CharSequence)strArray[25]) ? new BigDecimal(strArray[25].replace("%", "")) : new BigDecimal(0));
            detailEo.setTerminalType(strArray[26]);
            detailEo.setFinanceFlag(strArray[27]);
            detailEo.setStoreNo(strArray[28]);
            detailEo.setMchName(strArray[29]);
            detailEo.setCashier(strArray[30]);
            detailEo.setSubSubMchId(strArray[31]);
            detailEo.setAvoidWithdrawFee(StringUtils.isNotBlank((CharSequence)strArray[32]) ? new BigDecimal(strArray[32]) : new BigDecimal(0));
            detailEo.setPaidFee(StringUtils.isNotBlank((CharSequence)strArray[33]) ? new BigDecimal(strArray[33]) : new BigDecimal(0));
            detailEo.setSettlementFee(StringUtils.isNotBlank((CharSequence)strArray[34]) ? new BigDecimal(strArray[34]) : new BigDecimal(0));
            detailEoList.add(detailEo);
            if (detailEoList.size() != batchNum.intValue()) continue;
            this.swiftpassFinanceFileDetailDas.insertBatch(detailEoList);
            detailEoList.clear();
        }
        if (detailEoList.size() > 0) {
            this.swiftpassFinanceFileDetailDas.insertBatch(detailEoList);
        }
        upEo.setDataNum(Integer.valueOf(dataNum));
    }

    @Override
    public RestResponse<SwiftpassFinanceFileRespDto> downloadFile(String date) {
        SwiftpassFinanceFileRespDto fileRespDto = new SwiftpassFinanceFileRespDto();
        SwiftpassFinanceFileEo swiftpassFinanceFileEo = new SwiftpassFinanceFileEo();
        swiftpassFinanceFileEo.setBillDate(date);
        swiftpassFinanceFileEo.setCode(PartnerConfigEnum.WFT_MER_CODE.key);
        try {
            SpDownloadOrderResponse spDownloadOrderResponse = this.spGatewayService.downloadSwiftpassOrderFile(swiftpassFinanceFileEo);
            fileRespDto.setFileText(spDownloadOrderResponse.getFileText());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return new RestResponse((Object)fileRespDto);
    }

    @Override
    public SwiftpassFinanceFileRespDto queryByBillDate(String billDate) {
        SwiftpassFinanceFileEo swiftpassFinanceFileEo = this.swiftpassFinanceFileMapper.queryByBillDate(billDate);
        SwiftpassFinanceFileRespDto swiftpassFinanceFileRespDto = new SwiftpassFinanceFileRespDto();
        DtoHelper.eo2Dto((BaseEo)swiftpassFinanceFileEo, (BaseVo)swiftpassFinanceFileRespDto);
        return swiftpassFinanceFileRespDto;
    }
}

