/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.tcbj.api.dto.response.SystemCalendarRespDto;
import com.dtyunxi.tcbj.api.enums.citic.SystemCalendarTypeEnum;
import com.dtyunxi.tcbj.biz.service.ISystemCalendarService;
import com.dtyunxi.tcbj.dao.das.SystemCalendarDas;
import com.dtyunxi.tcbj.dao.eo.SystemCalendarEo;
import com.dtyunxi.vo.BaseVo;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SystemCalendarServiceImpl
implements ISystemCalendarService {
    private static final Logger logger = LoggerFactory.getLogger(SystemCalendarServiceImpl.class);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    @Resource
    public SystemCalendarDas systemCalendarDas;

    @Override
    public SystemCalendarRespDto queryByDate(String date) {
        logger.info("\u6839\u636e\u65e5\u671f\u67e5\u8be2\u65e5\u5386\uff1a{}", (Object)date);
        Date queryDate = null;
        try {
            queryDate = this.dateFormat.parse(date);
        }
        catch (Exception e) {
            throw new BizException("-1", "\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u5e38\uff0c\u5e94\u4e3a yyyy-MM-dd");
        }
        SystemCalendarEo systemCalendarEo = new SystemCalendarEo();
        systemCalendarEo.setDate(queryDate);
        SystemCalendarEo selectOne = (SystemCalendarEo)this.systemCalendarDas.selectOne((BaseEo)systemCalendarEo);
        if (ObjectUtil.isNotEmpty((Object)selectOne)) {
            SystemCalendarRespDto respDto = new SystemCalendarRespDto();
            DtoHelper.eo2Dto((BaseEo)selectOne, (BaseVo)respDto);
            return respDto;
        }
        return null;
    }

    @Override
    public SystemCalendarRespDto queryBeforeHolidayByDate(String date) {
        logger.info("\u6839\u636e\u65e5\u671f\u67e5\u8be2\u8be5\u65e5\u671f\u8ddd\u524d\u4e00\u4e2a\u5de5\u4f5c\u65e5\u4e4b\u95f4\u7684\u8282\u5047\u65e5\u96c6\u5408\uff1a{}", (Object)date);
        SystemCalendarRespDto respDto = this.queryByDate(date);
        if (ObjectUtil.isEmpty((Object)respDto)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u8be5\u65e5\u671f\u65e5\u5386\u4fe1\u606f");
        }
        if (SystemCalendarTypeEnum.C02.getCode().equals(respDto.getType().toString())) {
            return respDto;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.ne(BaseEo::getId, (Object)respDto.getId());
        queryWrapper.eq(BaseEo::getDr, (Object)"0");
        queryWrapper.eq(SystemCalendarEo::getType, (Object)SystemCalendarTypeEnum.C01.getCode());
        queryWrapper.lt(SystemCalendarEo::getDate, (Object)respDto.getDate());
        queryWrapper.orderByDesc(SystemCalendarEo::getDate);
        queryWrapper.last("limit 1");
        SystemCalendarEo beforeDate = (SystemCalendarEo)this.systemCalendarDas.getOne((Wrapper)queryWrapper);
        if (ObjectUtil.isEmpty((Object)respDto)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u8be5\u65e5\u671f\u7684\u4e0a\u4e00\u4e2a\u5de5\u4f5c\u65e5");
        }
        respDto.setBeforeDate(beforeDate.getDate());
        respDto.setBeforeDateType(beforeDate.getType());
        LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
        queryWrapper2.eq(BaseEo::getDr, (Object)"0");
        queryWrapper2.eq(SystemCalendarEo::getType, (Object)SystemCalendarTypeEnum.C02.getCode());
        queryWrapper2.gt(SystemCalendarEo::getDate, (Object)beforeDate.getDate());
        queryWrapper2.lt(SystemCalendarEo::getDate, (Object)respDto.getDate());
        List eoList = this.systemCalendarDas.list((Wrapper)queryWrapper2);
        if (CollectionUtil.isNotEmpty((Collection)eoList)) {
            List dateList = eoList.stream().map(SystemCalendarEo::getDate).collect(Collectors.toList());
            respDto.setHolidayList(dateList);
        }
        return respDto;
    }
}

