/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.tcbj.biz.service.impl.RequestCheckService;
import com.dtyunxi.yundt.cube.center.payment.constant.ErrorCode;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.CheckStatus;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.NotifyStatus;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.VerifyException;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.PayResponse;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.GatewayFactory;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.GatewayServiceFactory;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.PartnerConfigManager;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderAttachInfoDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.GatewayEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.StoreEo;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="unionPayOrderCreateServiceImpl")
public class UnionPayOrderCreateServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(UnionPayOrderCreateServiceImpl.class);
    @Resource
    private StoreDas payStoreDas;
    @Resource
    private PayOrderDas payOrderDas;
    @Resource
    private GatewayServiceFactory gatewayServiceFactory;
    @Resource
    private GatewayFactory gatewayFactory;
    @Resource
    private PartnerConfigManager partnerConfigManager;
    @Resource
    private RequestCheckService requestCheckService;
    @Resource
    private PayOrderAttachInfoDas payOrderAttachInfoDas;

    public PayResponse execute(PayRequest request) throws ApiException, VerifyException {
        try {
            log.info("\u6536\u5230\u4e0a\u5c42\u5e94\u7528\u65b9API\u8bf7\u6c42:{}", (Object)request.toString());
            this._validate(request);
            PayResponse response = this._execute(request);
            StoreEo payStore = (StoreEo)this.payStoreDas.selectByLogicKey((Object)request.getStoreId());
            log.info("\u54cd\u5e94\u5546\u6237:{}", (Object)response.toString());
            return response;
        }
        catch (ApiException var4) {
            log.error("", (Throwable)var4);
            throw var4;
        }
        catch (VerifyException var5) {
            log.error(var5.getMessage(), (Throwable)var5);
            throw var5;
        }
        catch (Exception var6) {
            log.error("", (Throwable)var6);
            throw new ApiException("SYSTEM_ERROR", ErrorCode.getErrorMsg((String)"SYSTEM_ERROR"));
        }
    }

    private PayResponse _execute(PayRequest request) throws Exception {
        PartnerConfigEo partnerConfig = this.partnerConfigManager.getPartnerConfig(request.getAppId(), request.getAppId(), request.getPayTypeId(), request.getPayPartnerId());
        GatewayEo gateway = this.gatewayFactory.fetchGateway(request.getPayTypeId(), request.getPayPartnerId());
        PayOrderEo parentOrder = this.packagePayOrder(request, partnerConfig, gateway);
        return null;
    }

    private PayOrderEo packagePayOrder(PayRequest request, PartnerConfigEo partnerConfig, GatewayEo payGateway) {
        PayOrderEo payOrder = PayOrderEo.newInstance();
        payOrder = this.payOrderDas.selectByStoreOrderIdAndGateway(request.getStoreId(), request.getStoreOrderId(), payGateway.getCode());
        if (null != payOrder) {
            return payOrder;
        }
        payOrder = PayOrderEo.newInstance();
        payOrder.setStoreCode(request.getStoreId());
        payOrder.setAppCode(request.getAppId());
        payOrder.setUserId(request.getUserId());
        payOrder.setPtUserId(request.getPtUserId());
        payOrder.setUserName(request.getUserName());
        payOrder.setNotifyUrl(request.getNotifyUrl());
        payOrder.setStatus(OrderStatus.PROCESS.getStatus());
        payOrder.setCheckStatus(CheckStatus.PROCESS.getStatus());
        payOrder.setNotifyStatus(NotifyStatus.NONE.getStatus());
        payOrder.setBody(request.getAppName());
        payOrder.setMobile(request.getMobile());
        payOrder.setAttachInfo(request.getAttachInfo());
        payOrder.setAmount(request.getOrderAmt());
        payOrder.setStoreOrderId(request.getStoreOrderId());
        payOrder.setPayType(request.getPayTypeId());
        payOrder.setStatus(OrderStatus.PROCESS.getStatus());
        payOrder.setCheckStatus(CheckStatus.PROCESS.getStatus());
        payOrder.setOrderTime(DateUtils.ceiling((Date)new Date(), (int)13));
        payOrder.setGatewayCode(payGateway.getCode());
        payOrder.setPartnerConfigCode(partnerConfig.getCode());
        payOrder.setCallbackUrl(request.getBackUrl());
        payOrder.setRemark(request.getRemark());
        payOrder.setGwStatus(OrderStatus.PROCESS.getStatus());
        payOrder.setFee(request.getFeeAmt());
        payOrder.setPartnerCode(payGateway.getPartnerCode());
        payOrder.setEmail(request.getEmail());
        payOrder.setPartnerAccount(request.getPartnerAccount());
        Integer expireTime = null == request.getExpireTime() ? partnerConfig.getExpireTime() : request.getExpireTime();
        payOrder.setExpireTime(expireTime);
        payOrder.setTerminal(request.getTerminal());
        payOrder.setAccountId(request.getAccountId());
        if (CollectionUtils.isNotEmpty((Collection)request.getPayInfo())) {
            payOrder.setParentTradeId(payOrder.getTradeId());
        } else {
            PayOrderAttachInfoEo attachInfoEo = PayOrderAttachInfoEo.newInstance();
            attachInfoEo.setPayRequest(request.toString());
            attachInfoEo.setTradeId(payOrder.getTradeId());
            attachInfoEo.setRemark6(request.getRemark6());
            attachInfoEo.setImei(request.getImei());
            attachInfoEo.setIp(request.getIp());
            attachInfoEo.setMac(request.getMac());
            attachInfoEo.setImsi(request.getImsi());
            this.payOrderAttachInfoDas.insert((BaseEo)attachInfoEo);
        }
        payOrder.setExtension(request.getExtension());
        this.payOrderDas.insert((BaseEo)payOrder);
        return payOrder;
    }

    public void _validate(PayRequest request) throws Exception {
        this.requestCheckService.validateBaseRequest(request);
        this.validatePayOrderExist(request);
    }

    private void validatePayOrderExist(PayRequest request) {
        PayOrderEo payOrderEo = (PayOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.payOrderDas.filter().eq((Object)"store_order_id", (Object)request.getStoreOrderId())).eq((Object)"dr", (Object)0)).one();
        if (null != payOrderEo) {
            throw new BizException("\u5df2\u5b58\u5728\u8be5\u6d41\u6c34\u53f7\u7684\u652f\u4ed8\u8bb0\u5f55,\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77\u652f\u4ed8");
        }
    }
}

