package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ReceivablesImportReqDto;
import com.dtyunxi.tcbj.api.dto.response.ReceivablesImportRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author 客户数据要药店数据关联关系数据处理
 * @since 1.0.0
 */
@Api(tags = {"报表中心：客户数据要药店数据关联关系数据处理"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/relationDeal",
        url = "${tcbj.center.report.api:}"
)
public interface IRelationDealApi {

    /**
     * 客户数据要药店数据关联关系数据处理-客户名称和公司名称进行匹配核对
     *
     */
    @PostMapping(value = {"/genCusStoreCompRela"}, produces = "application/json")
    @ApiOperation(value = "客户名称和公司名称进行匹配核对", notes = "客户名称和公司名称进行匹配核对")
    RestResponse<String> genCusStoreCompRela(@RequestBody List<Long> orgIdList);
}
