package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CustomerExtReqDto;
import com.dtyunxi.tcbj.api.dto.request.StoreSearchReqDto;
import com.dtyunxi.tcbj.api.dto.response.CustomerExtRespDto;
import com.dtyunxi.tcbj.api.dto.response.CustomerStoreResponseDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Api(tags = {"报表中心: 客户信息"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/customer/distribution",
        url = "${tcbj.center.report.api:}"
)
public interface ICustomerDistributorsQueryApi {

    /**
     * 根据分销商编码查询分销商详细信息
     *
     * @param distributionCode
     * @return
     */
    @GetMapping(value = {"/queryCustomerByDistributionCode"})
    @ApiOperation(value = "根据分销商编码查询分销商详细信息", notes = "根据分销商编码查询分销商详细信息")
    RestResponse<CustomerRespDto> queryCustomerByDistributionCode(@RequestParam("distributionCode") String distributionCode);

    /**
     * 查询客户信息
     * @param customerReqDto
     * @return
     */
    @PostMapping(value = {"/queryCustomer"})
    @ApiOperation(value = "查询客户信息[客户公司信息通过全量数据校验]", notes = "查询客户信息[客户公司信息通过全量数据校验]")
    RestResponse<List<CustomerExtRespDto>> queryCustomer(@RequestBody CustomerExtReqDto customerReqDto);

    /**
     * 查询客户信息
     * @param customerReqDto
     * @return
     */
    @PostMapping(value = {"/queryCustomerList"})
    @ApiOperation(value = "查询客户信息[信用代码不关联全量表]", notes = "查询客户信息[信用代码不关联全量表]")
    RestResponse<List<CustomerRespDto>> queryCustomerList(@RequestBody CustomerExtReqDto customerReqDto);

    /**
     * 分页查询客户信息
     * @param filter
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping(value = {"/queryCustomerPage"})
    @ApiOperation(value = "分页查询客户信息", notes = "分页查询客户信息")
    RestResponse<PageInfo<CustomerExtRespDto>> queryCustomerPage(@RequestParam("filter") String filter,
                                                              @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                              @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询客户信息
     * @param customerReqDto
     * @return
     */
    @PostMapping(value = {"/queryCustomerAndUserList"})
    @ApiOperation(value = "查询客户信息关联账号信息", notes = "查询客户信息关联账号信息")
    RestResponse<List<CustomerExtRespDto>> queryCustomerAndUserList(@RequestBody CustomerExtReqDto customerReqDto);

    /**
     * 客户关联药店全量信息
     * @param filter
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping(value = {"/queryCustomerStorePage"})
    @ApiOperation(value = "客户关联药店全量信息", notes = "客户关联药店全量信息")
    RestResponse<PageInfo<CustomerStoreResponseDto>> queryCustomerStorePage(@RequestParam("filter") String filter,
                                                                            @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);





}
