package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import com.dtyunxi.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 逻辑仓库存响应dto
*
* @author wude
* @since 2022-03-07
*/
@ApiModel(value = "LogicInventoryRespDto", description = "逻辑仓库存响应dto")
public class LogicInventoryRespDto extends ResponseDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     *  仓库类型
     */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型")
    private String warehouseType;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  批次类型 common-正常,defective-残次品,其他类型待定
    */
    @ApiModelProperty(name = "batchType", value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /**
    *  总库存
    */
    @ApiModelProperty(name = "balance", value = "总库存")
    private BigDecimal balance;
    /**
    *  预占库存
    */
    @ApiModelProperty(name = "preempt", value = "预占库存")
    private BigDecimal preempt;
    /**
    *  已分配库存
    */
    @ApiModelProperty(name = "allocate", value = "已分配库存")
    private BigDecimal allocate;
    /**
    *  活动分配库存
    */
    @ApiModelProperty(name = "activityAllocate", value = "活动分配库存")
    private BigDecimal activityAllocate;
    /**
    *  在途库存
    */
    @ApiModelProperty(name = "intransit", value = "在途库存")
    private BigDecimal intransit;
    /**
    *  已调拨库存
    */
    @ApiModelProperty(name = "transfer", value = "已调拨库存")
    private BigDecimal transfer;
    /**
    *  已完成库存
    */
    @ApiModelProperty(name = "completed", value = "已完成库存")
    private BigDecimal completed;
    /**
    *  可用库存,可用库存 = 总库存 + 在途库存 - 已完成库存 - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存
    */
    @ApiModelProperty(name = "available", value = "可用库存,可用库存 = 总库存 + 在途库存 - 已完成库存 - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存")
    private BigDecimal available;
    /**
     *  待收库存
     */
    @ApiModelProperty(name = "futureIn", value = "待收库存")
    private BigDecimal futureIn;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  过期日期
    */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;
    /**
    *  生产日期
    */
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;
    /**
     *  商品长编码
     */
    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
    private String itemLongCode;
    /**
     *  商品条码
     */
    @ApiModelProperty(name = "itemBarCode", value = "商品条码")
    private String itemBarCode;
    /**
     *  商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
     *  仓库属性
     */
    @ApiModelProperty(name = "warehouseProperty", value = "仓库属性")
    private String warehouseProperty;
    /**
     *  所属物理仓
     */
    @ApiModelProperty(name = "physicsWarehouseName", value = "所属物理仓")
    private String physicsWarehouseName;
    /**
     *  仓库质量
     */
    @ApiModelProperty(name = "warehouseQuality", value = "仓库质量")
    private String warehouseQuality;
    /**
     *  是否过期
     */
    @ApiModelProperty(name = "expired", value = "是否过期 0否 1是")
    private Integer expired;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getBatchType() {
        return batchType;
    }

    public void setBatchType(String batchType) {
        this.batchType = batchType;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getPreempt() {
        return preempt;
    }

    public void setPreempt(BigDecimal preempt) {
        this.preempt = preempt;
    }

    public BigDecimal getAllocate() {
        return allocate;
    }

    public void setAllocate(BigDecimal allocate) {
        this.allocate = allocate;
    }

    public BigDecimal getActivityAllocate() {
        return activityAllocate;
    }

    public void setActivityAllocate(BigDecimal activityAllocate) {
        this.activityAllocate = activityAllocate;
    }

    public BigDecimal getIntransit() {
        return intransit;
    }

    public void setIntransit(BigDecimal intransit) {
        this.intransit = intransit;
    }

    public BigDecimal getTransfer() {
        return transfer;
    }

    public void setTransfer(BigDecimal transfer) {
        this.transfer = transfer;
    }

    public BigDecimal getCompleted() {
        return completed;
    }

    public void setCompleted(BigDecimal completed) {
        this.completed = completed;
    }

    public BigDecimal getAvailable() {
        return available;
    }

    public void setAvailable(BigDecimal available) {
        this.available = available;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }

    public String getItemLongCode() {
        return itemLongCode;
    }

    public void setItemLongCode(String itemLongCode) {
        this.itemLongCode = itemLongCode;
    }

    public String getItemBarCode() {
        return itemBarCode;
    }

    public void setItemBarCode(String itemBarCode) {
        this.itemBarCode = itemBarCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getWarehouseProperty() {
        return warehouseProperty;
    }

    public void setWarehouseProperty(String warehouseProperty) {
        this.warehouseProperty = warehouseProperty;
    }

    public String getPhysicsWarehouseName() {
        return physicsWarehouseName;
    }

    public void setPhysicsWarehouseName(String physicsWarehouseName) {
        this.physicsWarehouseName = physicsWarehouseName;
    }

    public String getWarehouseQuality() {
        return warehouseQuality;
    }

    public void setWarehouseQuality(String warehouseQuality) {
        this.warehouseQuality = warehouseQuality;
    }

    public Integer getExpired() {
        if (this.getExpireTime()==null){
            return 0;
        }else{
            if (this.getExpireTime().before(DateUtil.getSysDate())){
                return 1;
            }else{
                return 0;
            }
        }
    }

    public void setExpired(Integer expired) {
        this.expired = expired;
    }

    public BigDecimal getFutureIn() {
        return futureIn;
    }

    public void setFutureIn(BigDecimal futureIn) {
        this.futureIn = futureIn;
    }
}
