package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.ItemInterceptConfigExtRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
* 服务接口
*
* @author ghosn
* @since 2024-06-24
*/
@Api(tags = {"服务"})
@FeignClient(
    contextId = "com-yx-tcbj-center-api-query-IItemInterceptConfigQueryApi",
    name = "${tcbj.center.report.api.name:tcbj.center.report}",
    path = "/v1/item/interceptConfig",
    url = "${tcbj.center.report.api:}"
)
public interface IItemInterceptConfigQueryApi {

    /**
     * 分页数据
     *
     * @param filter   查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "分页数据", notes = "根据filter查询条件查询数据，filter=ItemInterceptConfigExtReqDto")
    RestResponse<PageInfo<ItemInterceptConfigExtRespDto>> queryByExtPage(@RequestParam("filter") String filter,
                                                                         @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                         @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
