package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * 组合套装活动返回Dto
 *
 * @author haoyang
 * @date 2021/11/23 9:43
 * @since 0.1.0
 */
public class CombinedPackageActivityRespDto {

    @ApiModelProperty(name = "activityId", value = "活动id")
    private Long activityId;

    @ApiModelProperty(name = "activityName",value = "活动名称")
    private String activityName;

    @ApiModelProperty(name = "shopId",value = "店铺id")
    private Long shopId;

    @ApiModelProperty(name = "activityTemplateId",value = "活动模板id")
    private Long activityTemplateId;

    @ApiModelProperty(name = "tag",value = "活动标签")
    private String tag;

    @ApiModelProperty(name = "organizationId",value = "组织id")
    private Long organizationId;

    @ApiModelProperty(name = "activityStock",value = "活动库存")
    private Long activityStock;

    @ApiModelProperty(name = "remainingStock",value = "剩余库存")
    private Long remainingStock;

    @ApiModelProperty(name = "organizationId",value = "套装价格")
    private BigDecimal packagePrice;

    @ApiModelProperty(name = "thresholdType",value = "套装类型 0：一口价 1：单品价")
    private Integer thresholdType;

    @ApiModelProperty(name = "promotionType", value = "促销类别：1 满减，2 满折 3 换购 4 组合商品")
    private Integer promotionType;

    @ApiModelProperty(name = "activityItemRespDtos", value = "组合套装商品信息")
    private List<CombinedPackageActivityItemRespDto> activityItemRespDtos;

    @ApiModelProperty(name = "conditionParams", value = "参数配置Json")
    private String conditionParams;

    @ApiModelProperty(name = "shoppingCartItemId", value = "小b端专用，购物车id")
    private Long shoppingCartItemId;

    @ApiModelProperty(name = "shoppingCartItemNum", value = "小b端专用，购物车的数量")
    private Integer shoppingCartItemNum = 0;

    @ApiModelProperty(name = "picture", value = "活动套装图片")
    private String picture;

    @ApiModelProperty(name = "thirdPartyCode", value = "套装编码")
    private String thirdPartyCode;

    @ApiModelProperty(name = "shopName",value = "所属店铺")
    private String shopName;

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getActivityTemplateId() {
        return activityTemplateId;
    }

    public void setActivityTemplateId(Long activityTemplateId) {
        this.activityTemplateId = activityTemplateId;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public Long getActivityStock() {
        return activityStock;
    }

    public void setActivityStock(Long activityStock) {
        this.activityStock = activityStock;
    }

    public BigDecimal getPackagePrice() {
        return packagePrice;
    }

    public void setPackagePrice(BigDecimal packagePrice) {
        this.packagePrice = packagePrice;
    }

    public List<CombinedPackageActivityItemRespDto> getActivityItemRespDtos() {
        return activityItemRespDtos;
    }

    public void setActivityItemRespDtos(List<CombinedPackageActivityItemRespDto> activityItemRespDtos) {
        this.activityItemRespDtos = activityItemRespDtos;
    }

    public String getConditionParams() {
        return conditionParams;
    }

    public void setConditionParams(String conditionParams) {
        this.conditionParams = conditionParams;
    }

    public Integer getThresholdType() {
        return thresholdType;
    }

    public void setThresholdType(Integer thresholdType) {
        this.thresholdType = thresholdType;
    }

    public Integer getPromotionType() {
        return promotionType;
    }

    public void setPromotionType(Integer promotionType) {
        this.promotionType = promotionType;
    }

    public Long getRemainingStock() {
        return remainingStock;
    }

    public void setRemainingStock(Long remainingStock) {
        this.remainingStock = remainingStock;
    }

    public Long getShoppingCartItemId() {
        return shoppingCartItemId;
    }

    public void setShoppingCartItemId(Long shoppingCartItemId) {
        this.shoppingCartItemId = shoppingCartItemId;
    }

    public Integer getShoppingCartItemNum() {
        return shoppingCartItemNum;
    }

    public void setShoppingCartItemNum(Integer shoppingCartItemNum) {
        this.shoppingCartItemNum = shoppingCartItemNum;
    }

    public String getPicture() {
        return picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getThirdPartyCode() {
        return thirdPartyCode;
    }

    public void setThirdPartyCode(String thirdPartyCode) {
        this.thirdPartyCode = thirdPartyCode;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }
}
