package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.*;
import com.dtyunxi.tcbj.api.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author minyue
 * @description: 经销商运营分析报表
 * @since 2021-12-31 13:41
 */
@Api(tags = {"报表中心：经销商运营分析报表"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/distributor",
        url = "${tcbj.center.report.api:}"
)
public interface IDistributorReportQueryApi {

    @PostMapping("/saleProgressStatistics")
    @ApiOperation("销售进度表-客户维度")
    RestResponse<PageInfo<OrderSaleProgressRespDto>> saleProgressStatistics(@RequestBody OrderSaleProgressReqDto orderSaleProgressReqDto);

    @PostMapping("/productRankingStatistics")
    @ApiOperation("产品排名-商品维度")
    RestResponse<PageInfo<OrderItemProductRankingRespDto>> productRankingStatistics(@RequestBody OrderItemProductRankingReqDto orderItemProductRankingReqDto);

    @PostMapping("/freeGiftSummaryStatistics")
    @ApiOperation("免费赠品汇总")
    RestResponse<PageInfo<FreeGiftSummaryRespDto>> freeGiftSummaryStatistics(@RequestBody FreeGiftSummaryReqDto freeGiftSummaryReqDto);

    @PostMapping("/discountStatistics")
    @ApiOperation("折扣汇总")
    RestResponse<PageInfo<RebateDetailRespDto>> discountStatistics(@RequestBody RebateDetailReqDto rebateDetailReqDto);

    @PostMapping("/creditStatementStatistics")
    @ApiOperation("授信账单汇总")
    RestResponse<PageInfo<CreditStatementStatisticsRespDto>> creditStatementStatistics(@RequestBody CreditStatementStatisticsReqDto creditStatementStatisticsReqDto);

    @PostMapping("/accountBillStatistics")
    @ApiOperation("账期汇总")
    RestResponse<PageInfo<AccountBillStatisticsRespDto>> accountBillStatistics(@RequestBody AccountBillStatisticsReqDto accountBillStatisticsReqDto);

    @PostMapping("/activityStatistics")
    @ApiOperation("促销活动汇总")
    RestResponse<PageInfo<PromotionalActivitiesStatisticsRespDto>> activityStatistics(@RequestBody PromotionalActivitiesStatisticsReqDto promotionalActivitiesStatisticsReqDto);

    @PostMapping("/orderDetailStatistics")
    @ApiOperation("订单明细汇总")
    RestResponse<PageInfo<OrderDetailStatisticsRespDto>> orderDetailStatistics(@RequestBody OrderDetailStatisticsReqDto orderDetailStatisticsReqDto);

    @PostMapping("/returnDetailStatistics")
    @ApiOperation("退款明细")
    RestResponse<PageInfo<ReturnDetailStatisticsRespDto>> returnDetailStatistics(@RequestBody ReturnDetailStatisticsReqDto returnDetailStatisticsReqDto);

    @PostMapping("/rebateOrderDetailStatistics")
    @ApiOperation("折扣明细")
    RestResponse<PageInfo<RebateOrderDetailRespDto>> rebateOrderDetailStatistics(@RequestBody RebateOrderDetailReqDto rebateOrderDetailReqDto);

    @PostMapping("/creditRecordDetailStatistics")
    @ApiOperation("信用流水明细")
    RestResponse<PageInfo<CreditRecordDetailRespDto>> creditRecordDetailStatistics(@RequestBody CreditRecordDetailReqDto creditRecordDetailReqDto);

    @PostMapping("/orderActivityDetailStatistics")
    @ApiOperation("活动明细")
    RestResponse<PageInfo<OrderActivityDetailRespDto>> orderActivityDetailStatistics(@RequestBody OrderActivityDetailReqDto orderActivityDetailReqDto);
}
