package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderAmountReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderAmountDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
 * 销售订单表服务接口
 *
 * @author haoxiao
 * @since 2022-03-10
 */
@Api(tags = {"销售订单报表服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/saleOrderReport", url = "${tcbj.center.report.api:}")
public interface ISaleOrderReportQueryApi {

    @PostMapping("/queryCountAndAmount")
    @ApiOperation(value = "销售订单金额统计", notes = "销售订单金额统计")
    RestResponse<SaleOrderAmountDto> queryAmountInfo(@RequestBody SaleOrderAmountReqDto filter);

    @GetMapping("/queryCountByCustomerId")
    @ApiOperation(value = "根据客户ID统计订单数", notes = "根据客户ID统计订单数")
    RestResponse<Integer> queryCountByCustomerId(@RequestParam(name="customerId") String customerId);
}
