package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
* 销售订单表Eo对象
*
* @author haoxiao
* @since 2022-03-10
*/
@Data
@ApiModel(value = "SaleOrderReqDto", description = "销售订单表Eo对象")
public class SaleOrderReqDto extends BaseDto {
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     *  销售订单创建时间
     */
    @ApiModelProperty(name = "saleOrderCreateTimeStart", value = "销售订单创建时间开始")
    private Date saleOrderCreateTimeStart;
    /**
     *  销售订单创建时间
     */
    @ApiModelProperty(name = "saleOrderCreateTimeEnd", value = "销售订单创建时间结束")
    private Date saleOrderCreateTimeEnd;
    /**
     *  订单备注
     */
    @ApiModelProperty(name = "orderRemark", value = "订单备注")
    private String orderRemark;

    /**
     * 逻辑仓名称
     */
    @ApiModelProperty(name = "logicalWarehouseName", value = "逻辑仓名称")
    private String logicalWarehouseName;
    /**
     *  平台订单号
     */
    @ApiModelProperty(name = "orderNo", value = "单号（平台订单号/内部销售订单号）")
    private String orderNo;
    /**
     *  店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
     *  店铺名称
     */
    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;
    /**
     *  订单类型 0-大B订单 1-积分订单 2-普通订单
     */
    @ApiModelProperty(name = "orderType", value = "订单类型 0-大B订单 1-积分订单 2-普通订单")
    private Integer orderType;
    /**
     *   订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入
     */
    @ApiModelProperty(name = "orderSource", value = " 订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入")
    private Integer orderSource;
    /**
     *  订单状态 WAIT_CHECK :待确认 WAIT_PICK ：待配货 LOCK_UN_DELIVERY :已锁未发 WAIT_DELIVERY:待发货 DELIVERED:已发货 COMPLETE:已完成 CANCEL:已取消 FINISH:已完结 SPLIT:被拆分
     */
    @ApiModelProperty(name = "saleOrderStatus", value = "订单状态 WAIT_CHECK :待确认 WAIT_PICK ：待配货 LOCK_UN_DELIVERY :已锁未发 WAIT_DELIVERY:待发货 DELIVERED:已发货 COMPLETE:已完成 CANCEL:已取消 FINISH:已完结 SPLIT:被拆分")
    private String saleOrderStatus;
    /**
     *  发货方
     */
    @ApiModelProperty(name = "sellerName", value = "发货方")
    private String sellerName;
    /**
     *  客户编码
     */
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;
    /**
     *  客户名称
     */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;

    /**
     *  收货人姓名
     */
    @ApiModelProperty(name = "deliveryName", value = "收货人姓名")
    private String deliveryName;
    /**
     *  收货人手机号
     */
    @ApiModelProperty(name = "deliveryPhone", value = "收货人手机号")
    private String deliveryPhone;
    /**
     *  收货地址
     */
    @ApiModelProperty(name = "detailAddress", value = "收货地址")
    private String detailAddress;

    /**
     *  更新时间开始
     */
    @ApiModelProperty(name = "updateTimeStart", value = "更新时间开始")
    private Date updateTimeStart;
    /**
     *  更新时间结束
     */
    @ApiModelProperty(name = "updateTimeEnd", value = "更新时间结束")
    private Date updateTimeEnd;
    /**
     *  承运商/物流公司
     */
    @ApiModelProperty(name = "logisticsCompany", value = "承运商/物流公司")
    private String logisticsCompany;
    /**
     *  拦截信息
     */
    @ApiModelProperty(name = "interceptInfo", value = "拦截信息")
    private String interceptInfo;
    /**
     *  创建人
     */
    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;

    /**
     *  发货时间开始
     */
    @ApiModelProperty(name = "deliveryTimeStart", value = "发货时间开始")
    private Date deliveryTimeStart;
    /**
     *  发货时间结束
     */
    @ApiModelProperty(name = "deliveryTimeEnd", value = "发货时间结束")
    private Date deliveryTimeEnd;

    @ApiModelProperty(name ="orderLevel",value = "订单级别（0原、1主、2子）")
    private Integer orderLevel;
    

    @ApiModelProperty(name ="saleChannel",value = "经销渠道")
    private String saleChannel;


}
