package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 查询库存预占的的请求参数
 * @author shuyi
 * @date : 2021/12/7 11:07
 * @since 1.0.0
 */
@Data
@ApiModel(value = "CargoOccupyReqDto", description = "查询库存预占的的请求参数Dto对象")
public class CargoOccupyReqDto  {

    @ApiModelProperty(name = "tenantId", value = "组织ID")
    private String tenantId;

    @ApiModelProperty(name = "depotNo", value = "仓库编码")
    private String depotNo;

    @ApiModelProperty(name = "materialList", value = "商品编码集合")
    private List<MaterialReqDto> materialList;

}
