package com.dtyunxi.tcbj.api.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.util.List;

/**
 * @description:
 * @author: yuangui
 * @date: 2022-03-18 10:30
 */
@Data
public class PCPCustomerRespDto {
    @ApiModelProperty(name="customerName", value = "客户名称")
    @JsonProperty("customerName")
    private String customerName;


    @ApiModelProperty(name="customerCode", value = "客户编码")
    @JsonProperty("customerCode")
    private String customerCode;


    @ApiModelProperty(name="customerShortName", value = "客户简称")
    @JsonProperty("customerShortName")
    private String customerShortName;


    @Valid
    @ApiModelProperty(name="customerCustomArea", value = "")
    @JsonProperty("customerCustomArea")
    private PCPCustomAreaRespDto customerCustomArea;


    @Valid
    @ApiModelProperty(name="customerArea", value = "所属区域")
    @JsonProperty("customerArea")
    private AddressRespDto customerArea = null;


    @ApiModelProperty(name="parentCustomerId", value = "上级客户Id")
    @JsonProperty("parentCustomerId")
    private String parentCustomerId;


    @ApiModelProperty(name="parentCustomerName", value = "上级客户名称")
    @JsonProperty("parentCustomerName")
    private String parentCustomerName;

    @Valid
    @ApiModelProperty(name="salesmans", value = "所属业务员")
    @JsonProperty("salesmans")
    private List<SalesmanRespDto> salesmans = null;


    @ApiModelProperty(name="wmsUnitType", value = "WMS单位类型")
    @JsonProperty("wmsUnitType")
    private String wmsUnitType;


    @ApiModelProperty(name="orgType", value = "ORG类型")
    @JsonProperty("orgType")
    private String orgType;


    @Valid
    @ApiModelProperty(name="customerCompanyInfo", value = "")
    @JsonProperty("customerCompanyInfo")
    private CompanyRespDto customerCompanyInfo;


    @Valid
    @ApiModelProperty(name="contactsInfoList", value = "联系人列表")
    @JsonProperty("contactsInfoList")
    private List<ContactRespDto> contactsInfoList = null;


    @Valid
    @ApiModelProperty(name="customerStatus", value = "")
    @JsonProperty("customerStatus")
    private PCPCustomerStatusRespDto customerStatus;

    @Valid
    @ApiModelProperty(name="customerType", value = "")
    @JsonProperty("customerType")
    private PCPCustomerTypeRespDto customerType;


    @Valid
    @ApiModelProperty(name="customerLevel", value = "")
    @JsonProperty("customerLevel")
    private PCPCustomerLevelRespDto customerLevel;


    @ApiModelProperty(name="customerId", value = "客户ID")
    @JsonProperty("customerId")
    private String customerId;


    @ApiModelProperty(name="targetWareHouse", value = "目标仓库")
    @JsonProperty("targetWareHouse")
    private String targetWareHouse;


    @ApiModelProperty(name="id", value = "唯一id")
    @JsonProperty("id")
    private Long id;
}
