package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ReceivablesReqDto;
import com.dtyunxi.tcbj.api.dto.response.BalanceOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReceivablesRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author bixuan
 * @since 1.0.0
 */
@Api(tags = {"报表中心：应收账款"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/receivables",
        url = "${tcbj.center.report.api:}"
)
public interface IReceivablesQueryApi {

    /**
     * 应收账款列表查询
     *
     * @param reqDto
     */
    @PostMapping(value = {"/page"}, produces = "application/json")
    @ApiOperation(value = "应收账款列表查询", notes = "应收账款列表查询")
    RestResponse<PageInfo<ReceivablesRespDto>> page(@RequestBody ReceivablesReqDto reqDto);

    /**
     * 应收账款详情查询
     *
     * @param reqDto
     */
    @PostMapping(value = {"/detail"}, produces = "application/json")
    @ApiOperation(value = "应收账款详情查询", notes = "应收账款详情查询")
    RestResponse<ReceivablesRespDto> detail(@RequestBody ReceivablesReqDto reqDto);

    /**
     * 未结算订单查询
     *
     * @param reqDto
     */
    @PostMapping(value = {"/balanceOrder"}, produces = "application/json")
    @ApiOperation(value = "未结算订单查询", notes = "未结算订单查询")
    RestResponse<PageInfo<BalanceOrderRespDto>> balanceOrder(@RequestBody ReceivablesReqDto reqDto);


}
