package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CountOrderItemNumReqDto;
import com.dtyunxi.tcbj.api.dto.request.CspTbPersonPartnerRelReqDto;
import com.dtyunxi.tcbj.api.dto.response.CountorderItemNumRespDto;
import com.dtyunxi.tcbj.api.dto.response.CspTbPersonPartnerRelRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 营销云业务员客户关联关系服务接口
*
* @author liguofeng
* @since 2023-01-09
*/
@Api(tags = {"报表中心:营销云业务员客户关联关系"})
@FeignClient(
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/tbPersonPartner",
    url = "${tcbj.center.report.api:}"
)
public interface ICspTbPersonPartnerRelQueryApi {


    @PostMapping("/salesManOrgIdbyMasterOuId")
    @ApiOperation("营销云业务员客户关联关系orgIds")
    RestResponse<List<Long>> salesManOrgIdbyMasterOuId(@RequestParam("masterOuId") String masterOuId);


}
