package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author minyue
 * @description: 账期汇总入参
 * @since 2022-01-13 15:00
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AccountBillReqDto", description = "账期汇总入参")
public class AccountBillStatisticsReqDto extends ReportBrandBaseReqDto {

    @ApiModelProperty(name = "placeTimeStart", value = "时间起(年月)")
    private String placeTimeStart;

    @ApiModelProperty(name = "placeTimeEnd", value = "时间(年月)")
    private String placeTimeEnd;

    @ApiModelProperty(name = "accountingPeriodType", value = "账期类型: 1:已逾期 0：未逾期")
    private Integer accountingPeriodType;

    @ApiModelProperty(name = "accountingPeriodEndTime", value = "账期到期时间")
    private Integer accountingPeriodEndTime;

}
