package com.dtyunxi.tcbj.api.biz.promotion;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.biz.promotion.dto.PromotionActivityQueryDto;
import com.dtyunxi.tcbj.api.biz.promotion.dto.PromotionExportRow;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

// ----------------------------
// Controller 实现 + Feign 实现
@RestController
@RequestMapping("/v1/promotion")
public class PromotionController implements IPromotionApi {

    @Resource
    private PromotionExportService promotionQueryService;

    @Override
    public RestResponse<List<PromotionExportRow>> queryActivity(@RequestBody PromotionActivityQueryDto queryDto) {
        List<PromotionExportRow> list = promotionQueryService.exportByOrgId(queryDto);
        return new RestResponse<>(list);
    }
}
