/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.api.biz.promotion;

import com.dtyunxi.tcbj.api.biz.promotion.dto.CustomerInfo;
import com.dtyunxi.tcbj.api.biz.promotion.dto.PromotionActivityQueryDto;
import com.dtyunxi.tcbj.api.biz.promotion.dto.PromotionExportRow;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class PromotionExportService {
    private static final Logger log = LoggerFactory.getLogger(PromotionExportService.class);
    @Resource
    private JdbcTemplate jdbcTemplate;

    public List<PromotionExportRow> exportByOrgId(PromotionActivityQueryDto req) {
        String orgId = req.getOrgId();
        log.info("\u5f00\u59cb\u5bfc\u51fa\u4fc3\u9500\u6d3b\u52a8\u6570\u636e\uff0corgId={}", (Object)orgId);
        String activityIds = (String)this.jdbcTemplate.queryForObject("SELECT GROUP_CONCAT(id) FROM mk_activity WHERE organization_id = ?", new Object[]{orgId}, String.class);
        log.info("\u67e5\u8be2\u5230\u7684\u6d3b\u52a8ID\u5217\u8868: {}", (Object)activityIds);
        if (activityIds == null || activityIds.isEmpty()) {
            log.info("\u672a\u627e\u5230\u5339\u914d\u7684\u6d3b\u52a8ID\uff0c\u8fd4\u56de\u7a7a\u5217\u8868");
            return Collections.emptyList();
        }
        List<PromotionExportRow> exportRows = this.callGenerateActivityExport(activityIds);
        HashMap<String, CustomerInfo> customerInfoMap = new HashMap<String, CustomerInfo>();
        for (String activityId : activityIds.split(",")) {
            CustomerInfo info = this.callGetCustomerInfo(activityId);
            if (info == null) continue;
            customerInfoMap.put(activityId, info);
        }
        for (PromotionExportRow row : exportRows) {
            CustomerInfo info = (CustomerInfo)customerInfoMap.get(row.getActivityCode());
            if (info != null) {
                row.setCustomerType(info.getCustomerType());
                row.setCustomerDetail(info.getCustomerDetail());
                continue;
            }
            row.setCustomerType("");
            row.setCustomerDetail("");
        }
        log.info("\u6210\u529f\u5bfc\u51fa{}\u6761\u4fc3\u9500\u6d3b\u52a8\u6570\u636e", (Object)exportRows.size());
        return exportRows;
    }

    private List<PromotionExportRow> callGenerateActivityExport(String activityIds) {
        log.info("\u51c6\u5907\u8c03\u7528\u5b58\u50a8\u8fc7\u7a0bgenerate_activity_export\uff0cactivityIds\u957f\u5ea6: {}", (Object)activityIds.length());
        return (List)this.jdbcTemplate.execute(con -> {
            log.info("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\uff0c\u8fde\u63a5\u5bf9\u8c61: {}", (Object)con);
            log.info("\u8fde\u63a5\u662f\u5426\u5173\u95ed: {}", (Object)con.isClosed());
            log.info("\u8fde\u63a5\u662f\u5426\u6709\u6548: {}", (Object)con.isValid(5));
            CallableStatement cs = con.prepareCall("{CALL yx_prod_report.generate_activity_export(?)}");
            cs.setString(1, activityIds);
            log.info("\u6210\u529f\u521b\u5efaCallableStatement\uff0c\u51c6\u5907\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b");
            return cs;
        }, cs -> {
            ArrayList<PromotionExportRow> list = new ArrayList<PromotionExportRow>();
            try {
                log.info("\u5f00\u59cb\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b...");
                boolean hasResults = cs.execute();
                log.info("\u5b58\u50a8\u8fc7\u7a0b\u6267\u884c\u5b8c\u6210\uff0c\u662f\u5426\u6709\u7ed3\u679c\u96c6: {}", (Object)hasResults);
                int resultSetCount = 0;
                while (hasResults) {
                    log.info("\u5904\u7406\u7b2c{}\u4e2a\u7ed3\u679c\u96c6", (Object)(++resultSetCount));
                    try (ResultSet rs = cs.getResultSet();){
                        if (rs == null) {
                            log.warn("\u7b2c{}\u4e2a\u7ed3\u679c\u96c6\u4e3anull", (Object)resultSetCount);
                        } else if (!rs.isBeforeFirst()) {
                            log.info("\u7b2c{}\u4e2a\u7ed3\u679c\u96c6\u4e3a\u7a7a", (Object)resultSetCount);
                        } else {
                            log.info("\u5f00\u59cb\u89e3\u6790\u7b2c{}\u4e2a\u7ed3\u679c\u96c6", (Object)resultSetCount);
                            int rowCount = 0;
                            while (rs.next()) {
                                ++rowCount;
                                PromotionExportRow row = new PromotionExportRow();
                                Integer index = rs.getObject("\u5e8f\u53f7", Integer.class);
                                row.setIndex(index != null ? index : 0);
                                row.setDivision(rs.getString("\u4e8b\u4e1a\u90e8"));
                                row.setActivityCode(rs.getString("\u6d3b\u52a8\u7f16\u53f7"));
                                row.setActivityName(rs.getString("\u6d3b\u52a8\u540d\u79f0"));
                                row.setProductType(rs.getString("\u4ea7\u54c1\u7c7b\u578b"));
                                row.setProductCode(rs.getString("\u4ea7\u54c1\u7f16\u7801"));
                                row.setProductName(rs.getString("\u4ea7\u54c1\u540d\u79f0"));
                                row.setPrice(rs.getString("\u5efa\u8bae\u96f6\u552e\u4ef7"));
                                row.setExchangePrice(rs.getString("\u6362\u8d2d\u4ef7"));
                                row.setNotAloneBuy(rs.getString("\u4e0d\u652f\u6301\u5355\u72ec\u8d2d\u4e70"));
                                row.setExchangeMethod(rs.getString("\u6362\u8d2d\u65b9\u5f0f"));
                                row.setQuotaType(rs.getString("\u989d\u5ea6\u7c7b\u578b"));
                                row.setRatio(rs.getString("\u6bd4\u4f8b"));
                                row.setCustomerType("");
                                row.setCustomerDetail("");
                                row.setActivityStartTime(rs.getString("\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4"));
                                row.setActivityEndTime(rs.getString("\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4"));
                                row.setActivityStatus(rs.getString("\u6d3b\u52a8\u72b6\u6001"));
                                list.add(row);
                            }
                            log.info("\u7b2c{}\u4e2a\u7ed3\u679c\u96c6\u89e3\u6790\u5b8c\u6210\uff0c\u5171{}\u884c", (Object)resultSetCount, (Object)rowCount);
                        }
                    }
                    hasResults = cs.getMoreResults();
                    log.info("\u662f\u5426\u5b58\u5728\u4e0b\u4e00\u4e2a\u7ed3\u679c\u96c6: {}", (Object)hasResults);
                }
                log.info("\u6240\u6709\u7ed3\u679c\u96c6\u5904\u7406\u5b8c\u6210\uff0c\u5171\u5904\u7406{}\u4e2a\u7ed3\u679c\u96c6", (Object)resultSetCount);
                return list;
            }
            catch (SQLException e) {
                log.error("\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b\u65f6\u53d1\u751fSQL\u5f02\u5e38", (Throwable)e);
                log.error("SQL\u72b6\u6001\u7801: {}", (Object)e.getSQLState());
                log.error("\u9519\u8bef\u7801: {}", (Object)e.getErrorCode());
                log.error("\u8be6\u7ec6\u6d88\u606f: {}", (Object)e.getMessage());
                throw e;
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b\u65f6\u53d1\u751f\u672a\u77e5\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b\u65f6\u53d1\u751f\u672a\u77e5\u5f02\u5e38", e);
            }
        });
    }

    private CustomerInfo callGetCustomerInfo(String activityId) {
        log.info("\u51c6\u5907\u8c03\u7528\u5b58\u50a8\u8fc7\u7a0bproc_get_activity_customer_info_full\uff0cactivityId: {}", (Object)activityId);
        return (CustomerInfo)this.jdbcTemplate.execute(con -> {
            CallableStatement cs = con.prepareCall("{CALL yx_prod_report.proc_get_activity_customer_info_full(?)}");
            cs.setString(1, activityId);
            return cs;
        }, cs -> {
            CustomerInfo info = null;
            try {
                boolean hasResults = cs.execute();
                int resultSetCount = 0;
                while (hasResults) {
                    ++resultSetCount;
                    try (ResultSet rs = cs.getResultSet();){
                        if (rs != null && rs.next()) {
                            info = new CustomerInfo();
                            info.setActivityId(activityId);
                            info.setCustomerType(rs.getString("customer_type"));
                            info.setCustomerDetail(rs.getString("customer_detail"));
                            log.info("\u6210\u529f\u83b7\u53d6\u6d3b\u52a8{}\u7684\u5ba2\u6237\u4fe1\u606f", (Object)activityId);
                        }
                    }
                    hasResults = cs.getMoreResults();
                }
                if (info == null) {
                    log.warn("\u672a\u627e\u5230\u6d3b\u52a8{}\u7684\u5ba2\u6237\u4fe1\u606f", (Object)activityId);
                }
                return info;
            }
            catch (SQLException e) {
                log.error("\u8c03\u7528proc_get_activity_customer_info_full\u65f6\u53d1\u751fSQL\u5f02\u5e38\uff0cactivityId: {}", (Object)activityId, (Object)e);
                throw e;
            }
        });
    }
}

