package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

/**
 * @author lius5
 */
@ApiModel(value = "RelationDealReqDto", description = "真实性统计对比查询ReqDto")
public class RelationDealReqDto {

    @ApiModelProperty(value = "客户编码",name = "customerCode")
    private List<Long> orgIdList;

    @ApiModelProperty(value = "需要被排除的一些特殊对象",name = "excludeMap")
    @NotNull
    private Map<String,List<String>> excludeMap;

    @ApiModelProperty(value = "补充的用于进行一些特殊处理的字符串",name = "supplyReplaceList")
    private List<String> supplyReplaceList;

    public List<String> getSupplyReplaceList() {
        return supplyReplaceList;
    }

    public void setSupplyReplaceList(List<String> supplyReplaceList) {
        this.supplyReplaceList = supplyReplaceList;
    }

    public Map<String, List<String>> getExcludeMap() {
        return excludeMap;
    }

    public void setExcludeMap(Map<String, List<String>> excludeMap) {
        this.excludeMap = excludeMap;
    }

    public List<Long> getOrgIdList() {
        return orgIdList;
    }

    public void setOrgIdList(List<Long> orgIdList) {
        this.orgIdList = orgIdList;
    }
}
