package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.Date;

/**
* 公司信息简化版本，用于一些耗时的查询进行优化
* @author lshaowu
* @time 2022/7/22 15:56
* @description
*/
@ApiModel(value = "CompanySimpleInfoDto", description = "公司信息简化版本类")
@Data
public class CompanySimpleInfoDto {

    @ApiModelProperty(name = "customerId", value = "客户id")
    private Long customerId;

    @ApiModelProperty("组织id")
    private Long orgInfoId;

    @ApiModelProperty("统一社会信用代码")
    private String creditCode;

    @ApiModelProperty("组织名称，新增必填")
    private String orgName;
}
