package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaTreeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaTreeRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 客户区域信息服务接口
*
* @author yuangui
* @since 2022-03-19
*/
@Api(tags = {"客户中心:PCP客户区域信息服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-ICustomerAreaQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v2/customer-area",
    url = "${tcbj.center.report.api:}"
)
public interface IPCPCustomerAreaQueryApi {

    /**
    * 根据id查询客户区域信息
    *
    * @param id 客户区域信息id
    * @return   客户区域信息数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询客户区域信息", notes = "根据id查询客户区域信息")
    RestResponse<CustomerAreaRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 客户区域信息分页数据
    *
    * @param filter   客户区域信息查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 客户区域信息分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "客户区域信息分页数据", notes = "根据filter查询条件查询客户区域信息数据，filter=CustomerAreaReqDto")
    RestResponse<PageInfo<CustomerAreaRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * @Description 查询客户区域树
     * @param customerAreaTreeReqDto
     * @return {@link RestResponse< List< CustomerAreaTreeRespDto>>}
     **/
    @GetMapping(value = "/tree")
    @ApiOperation(value = "查询客户区域树", notes = "查询客户区域树")
    RestResponse<List<CustomerAreaTreeRespDto>> queryForTree(@SpringQueryMap CustomerAreaTreeReqDto customerAreaTreeReqDto);

}
