package com.dtyunxi.tcbj.api.biz.customer;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaReq;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaResp;
import com.dtyunxi.tcbj.api.biz.promotion.dto.PromotionExportRow;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

// ----------------------------
// Controller 实现 + Feign 实现
@RestController
@RequestMapping("/v1/customer")
public class CustomerController implements ICustomerApi {

    @Resource
    private CustomerService customerService;

    @Override
    public RestResponse<QueryCustomerFullAreaResp> queryCustomerFullArea(@RequestBody QueryCustomerFullAreaReq queryDto) {
        QueryCustomerFullAreaResp queryCustomerFullAreaResp = customerService.queryCustomerFullArea(queryDto);
        return new RestResponse<>(queryCustomerFullAreaResp);
    }
}
