package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.QueryItemByBrandAndOrgReqDto;
import com.dtyunxi.tcbj.api.dto.request.QueryItemOrgInfoReqDto;
import com.dtyunxi.tcbj.api.dto.request.QueryProgressTradeByCustomerIdReqDto;
import com.dtyunxi.tcbj.api.dto.response.QueryItemByBrandAndOrgRespDto;
import com.dtyunxi.tcbj.api.dto.response.QueryItemWithoutSuggestedPriceRespDto;
import com.dtyunxi.tcbj.api.dto.response.QueryProgressTradeByCustomerIdRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Api(tags = {"报表中心：客户数据关联查询"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/tradeInfo",
        url = "${tcbj.center.report.api:}"
)
public interface ITradeInfoApi {

    @PostMapping(value = {"/queryItemWithoutSuggestedPrice"}, produces = "application/json")
    @ApiOperation(value = "查询没有建议零售价的item", notes = "查询没有建议零售价的item")
    RestResponse<List<QueryProgressTradeByCustomerIdRespDto>> queryProgressTradeByCustomerId(@RequestBody QueryProgressTradeByCustomerIdReqDto reqDto);


}
